; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               Fontmaschine
; -----------------------------------------------------------------------------
; Version:            1.0
; Date:               2006-09-22
; Author:             Wolfgang Reszel und Andr Kramer fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

#Singleinstance force
SkriptName = Fontmaschine v1.0

; Voreinstellungen laden
Gosub, EinstellungenLaden

; -----------------------------------------------------------------------------
; === GUI =====================================================================
; -----------------------------------------------------------------------------

; GUI aufbauen
Gui, Font, S15 Bold,
Gui, Add, Text, x16 y3 w220 h30 , %SkriptName%
Gui, Font, ,
Gui, Add, Text, x210 y12,  2006 Heise Zeitschriften Verlag GmbH && Co. KG
Gui, Add, Text, 0x1000 x0 y33 w706 h2

Gui, Add, GroupBox, x16 y40 w430 h130 , Verarbeitungsprozess
Gui, Add, Text, x26 y60 w190 h20 , Verzeichnis mit den &BMP-Dateien:
Gui, Add, Edit, x26 y80 w300 h20 vBMPVerzeichnis gEingabenPrfen, %BMPVerzeichnis%
Gui, Add, Button, x336 y79 w100 h22 vBMPVerzeichnisDurchsuchen gDurchsuchen, &Durchsuchen ...
Gui, Add, Radio, x26 y105 vMitPotraceUndIrfanView gEingabenPrfen, BMP-Dateien mit Protrace und IrfanView &optimieren
Gui, Add, Radio, x+5 vOhnePotraceUndIrfanView gEingabenPrfen, &Keine Optimierung
If MitPotraceUndIrfanView = 1
   GuiControl, , MitPotraceUndIrfanView, 1
Else
   GuiControl, , OhnePotraceUndIrfanView, 1
Gui, Add, Button, x136 y130 w90 h30 gGuiClose, &Abbrechen
Gui, Add, Button, x236 y130 w90 h30 gVerarbeitungStarten, &Starten
Gui, Font, S12, Webdings
Gui, Add, Button, x26 y130 w30 h30 vOptionenButton gOptionenEinAus, 6
Gui, Font, ,
Gui, Add, GroupBox, x16 y180 w430 h190 , Konfiguration
Gui, Add, Text, x26 y200 w190 h20 , Pfad zu &Potrace:
Gui, Add, Edit, x26 y220 w300 h20 vPotraceExe gEingabenPrfen, %PotraceExe%
Gui, Add, Button, x336 y219 w100 h22 vPotraceExeDurchsuchen gDurchsuchen, Durchsuchen ...
Gui, Add, Text, x26 y245, Parameter fr Potrace:
Gui, Add, Edit, x+5 yp-3 h20 w174 vPotraceParameter, %PotraceParameter%
Gui, Add, Button, -Wrap x+0 gPotraceParameterHelp h20 w15, ?
Gui, Add, Text, x26 y270 w190 h20 , Pfad zu &IrfanView:
Gui, Add, Edit, x26 y290 w300 h20 vIrfanViewExe gEingabenPrfen, %IrfanViewExe%
Gui, Add, Button, -Wrap x336 y289 w100 h22 vIrfanViewExeDurchsuchen gDurchsuchen, Durchsuchen ...
Gui, Add, Text, x26 y320 w190 h20 , Pfad zu &FontCreator:
Gui, Add, Edit, x26 y340 w300 h20 vFontCreatorExe gEingabenPrfen, %FontCreatorExe%
Gui, Add, Button, -Wrap x336 y339 w100 h22 vFontCreatorExeDurchsuchen gDurchsuchen, Durchsuchen ...

; Fehlt eine Pfadangabe, wird automatisch die Konfiguration eingeblendet
If (((IrfanViewExe = "" OR PotraceExe = "") AND MitPotraceUndIrfanView = 1) OR FontCreatorExe = "")
   OptionenEingeblendet = 1

Gosub, OptionenEinAus
Gosub, EingabenPrfen
Return

GuiEscape:
GuiClose:
ExitApp

; Konfiguration animiert ein-/ausblenden
OptionenEinAus:
   ; Konfiguration einblenden
   If OptionenEingeblendet = 1
   {
      OptionenEingeblendet = 0
      Loop, 10
      {
         H := A_Index*20.4+179
         Gui, Show, h%H% w464, %SkriptName%
      }
      GuiControl,,OptionenButton, 5
   }
   ; Konfiguration ausblenden
   Else If OptionenEingeblendet = 0
   {
      OptionenEingeblendet = 1
      Loop, 10
      {
         H := 384-A_Index*20.4
         Gui, Show, h%H% w464, %SkriptName%
      }
      GuiControl,,OptionenButton, 6
   }
   ; Konfiguration beim ersten Start ohne Animation ausblenden
   Else
   {
      OptionenEingeblendet = 1
      Gui, Show, h180 w464, %SkriptName%
      GuiControl,,OptionenButton, 6
   }
Return

; Bei jeder Vernderung prfen, ob die Eingabe korrekt sind
; und ggf. das Starten-Schalftflche anklickbar machen
EingabenPrfen:
   Gui, Submit, NoHide
   Fehler =
   If MitPotraceUndIrfanView = 1
   {
      IfNotExist, %PotraceExe%\potrace.exe
         Fehler++
      IfNotExist, %IrfanViewExe%\i_view32.exe
         Fehler++
      GuiControl, Enable, IrfanViewExe
      GuiControl, Enable, PotraceExe
      GuiControl, Enable, PotraceParameter
      GuiControl, Enable, IrfanViewExeDurchsuchen
      GuiControl, Enable, PotraceExeDurchsuchen
   }
   Else
   {
      GuiControl, Disable, IrfanViewExe
      GuiControl, Disable, PotraceExe
      GuiControl, Disable, PotraceParameter
      GuiControl, Disable, IrfanViewExeDurchsuchen
      GuiControl, Disable, PotraceExeDurchsuchen
   }
   IfNotExist, %FontCreatorExe%\FontCreator.exe
      Fehler++
   BMPgefunden =
   Loop, %BMPVerzeichnis%\*.bmp,0,0
   {
      BMPgefunden = 1
      break
   }
   If BMPgefunden <> 1
      Fehler++

   If Fehler <>
      GuiControl, Disable, &Starten
   Else
      GuiControl, Enable, &Starten
Return

; Verzeichnis Durchsuchen-Funktion
Durchsuchen:
   Hotkey, $ESC, Off
   StringReplace, Eingabefeld, A_GuiControl, Durchsuchen
   GuiControlGet, Verzeichnis,,%EingabeFeld%
   FileSelectFolder, Verzeichnis, *%Verzeichnis%
   If ErrorLevel = 0
      GuiControl,,%Eingabefeld%, %Verzeichnis%
   Gosub, EingabenPrfen
   Hotkey, $ESC, On
Return

EinstellungenLaden:
   ; Programmpfad fr IrfanView ermitteln
   Regread, DefIrfanViewExe, HKEY_CLASSES_ROOT,Applications\i_view32.exe\shell\open\command
   StringReplace, DefIrfanViewExe, DefIrfanViewExe, ",, A
   StringReplace, DefIrfanViewExe, DefIrfanViewExe, % " %1",, A
   SplitPath, DefIrfanViewExe, , DefIrfanViewExe
   IniRead, IrfanViewExe, Fontmaschine.ini, Einstellungen, IrfanViewExe, %DefIrfanViewExe%%A_Space%

   ; Programmpfad fr FontCreator ermitteln
   RegRead, DefFontCreatorExe, HKEY_LOCAL_MACHINE,SOFTWARE\High-Logic\FontCreator\Settings, Path
   IniRead, FontCreatorExe, Fontmaschine.ini, Einstellungen, FontCreatorExe, %DefFontCreatorExe%%A_Space%

   ; Programmpfad fr FontCreator ermitteln
   Loop, %A_Scriptdir%\potrace.exe,0,1
   {
      DefPotraceExe = %A_Loopfilefullpath%
      SplitPath, DefPotraceExe,, DefPotraceExe
      Break
   }
   IniRead, PotraceExe, Fontmaschine.ini, Einstellungen, PotraceExe, %DefPotraceExe%%A_Space%

   ; Verzeichnis mit den BMP-Dateien ermitteln
   Loop, %A_Scriptdir%\*.bmp,0,1
   {
      DefBMPVerzeichnis = %A_Loopfilefullpath%
      SplitPath, DefBMPVerzeichnis,, DefBMPVerzeichnis
      Break
   }
   IniRead, BMPVerzeichnis, Fontmaschine.ini, Einstellungen, BMPVerzeichnis, %DefBMPVerzeichnis%%A_Space%

   IniRead, PotraceParameter, Fontmaschine.ini, Einstellungen, PotraceParameter, -x 4
   IniRead, MitPotraceUndIrfanView, Fontmaschine.ini, Einstellungen, MitPotraceUndIrfanView, 0
   If MitPotraceUndIrfanView = 0
      OhnePotraceUndIrfanView = 1
Return

EinstellungenSpeichern:
   IniWrite, %BMPVerzeichnis%, Fontmaschine.ini, Einstellungen, BMPVerzeichnis
   IniWrite, %PotraceExe%, Fontmaschine.ini, Einstellungen, PotraceExe
   IniWrite, %FontCreatorExe%, Fontmaschine.ini, Einstellungen, FontCreatorExe
   IniWrite, %IrfanViewExe%, Fontmaschine.ini, Einstellungen, IrfanViewExe
   IniWrite, %PotraceParameter%, Fontmaschine.ini, Einstellungen, PotraceParameter
   IniWrite, %MitPotraceUndIrfanView%, Fontmaschine.ini, Einstellungen, MitPotraceUndIrfanView
Return

; -----------------------------------------------------------------------------
; === Tastaturkrzel ==========================================================
; -----------------------------------------------------------------------------

$ESC::
   Send, {ESC 2}

   ; Zwischenablage wiederherstellen
   ClipBoard = %Zwischenablage%

   ExitApp
Return

; -----------------------------------------------------------------------------
; === Hauptroutine ============================================================
; -----------------------------------------------------------------------------

; Verarbeitungs- und Fernsteuerungsroutine
VerarbeitungStarten:
   CoordMode, ToolTip, screen
   CoordMode, Mouse, screen
   SetTitlematchmode, 2

   ; Fontmaschine-Dialog schlieen
   Gui, Submit
   Gui, Destroy

   ; Einstellungen in Ini-Datei speichern
   Gosub, EinstellungenSpeichern

   ; Arbeitsverzeichnis festlegen
   SetWorkingDir, %BMPVerzeichnis%

   ; Zwischenablage sichern
   Zwischenablage = %ClipboardAll%

   ; Vorschlag fr Multiplier-Wert
   MultiplierValue = 20

   ; Wenn Optimierung mit Potrace aktiviert, dann ...
   If MitPotraceUndIrfanView = 1
   {
      ; Hinweis anzeigen
      SplashImage, ,M,Bilddateien werden mit Potrace und IrfanView optimiert ...,,%SkriptName%
      ; frisches Unterverzeichnis potrace anlegen
      FileRemovedir, %BMPVerzeichnis%\potrace, 1
      FileCreatedir, %BMPVerzeichnis%\potrace
      ; Als Arbeitsverzeichnis festlegen
      SetWorkingDir, %BMPVerzeichnis%\potrace
      ; Potrace auf alle BMPs anwenden und PGMs erzeugen
      RunWait, %PotraceExe%\potrace.exe -g %PotraceParameter% ..\*.bmp,,Hide
      ; Alle PGMs nach .\potrace verschieben
      FileMove, ..\*.pgm, .\, 1
      ; PGMs mit IrfanView in BMPs konvertieren
      RunWait, %IrfanViewExe%\i_view32.exe *.pgm /convert=*.bmp,,Hide
      ; PGMs lschen, da nicht mehr bentigt
      FileDelete, *.pgm
      ; Skalierungsfaktor in Potrace-Parametern ermitteln
      Loop, Parse, PotraceParameter, %A_Space%
      {
         If LastLoopField = -x
         {
            PotraceMultiplier = %A_LoopField%
            Break
         }
         If (InStr( A_LoopField, "-x") AND StrLen( A_LoopField ) > 2)
         {
            StringReplace, PotraceMultiplier, A_LoopField, -x
            Break
         }
         LastLoopField = %A_LoopField%
         PotraceMultiplier = 1
      }
      MultiplierValue := Round(MultiplierValue / PotraceMultiplier)
   }

   ; Hinweis ausblenden
   SplashImage, Off

   ; Wenn FontCreator bereits mit offener Schriftart existiert, dann ...
   IfWinExist, ahk_class TMainFormFontCreator, .ttf
   {
      ; Wenn Fenster nicht aktiv, dann aktivieren
      IfWinNotActive, ahk_class TMainFormFontCreator
         WinActivate, ahk_class TMainFormFontCreator
      ; Hinweis anzeigen
      SplashImage, ,M,Bitte alle Dateien im FontCreator schlieen!,,%SkriptName%
      ; Warten bis, alle Fonts geschlossen wurden
      Loop
      {
         IfWinNotExist, ahk_class TMainFormFontCreator, .ttf
            break
         Sleep, 150
      }
      ; Hinweis ausblenden
      SplashImage, Off
   }
   ; Wenn FontCreator nicht bereits gestartet, dann ...
   IfWinNotExist, ahk_class TMainFormFontCreator
   {
      ; FontCreator starten
      Run, %FontCreatorExe%\FontCreator.exe
      ; Warten bis Programmfenster existiert
      WinWait, ahk_class TMainFormFontCreator
   }

   ; Wenn Fenster nicht aktiv, dann aktivieren
   IfWinNotActive, ahk_class TMainFormFontCreator
      WinActivate, ahk_class TMainFormFontCreator

   ; 1 Sekunde auf Shareware-Fenster warten und entsprechend reagieren
   WinWaitActive, ahk_class TSplashForm,,1
   If ErrorLevel = 0
   {
      Send, !v
      WinWaitClose, ahk_class TSplashForm
   }
   ; 1 Sekunde auf Willkommen-Fenster warten und entsprechend reagieren
   WinWaitActive, ahk_class TWelcomeForm,,1
   If ErrorLevel = 0
   {
      Send, !c
      WinWaitClose, ahk_class TWelcomeForm
   }
   ; 1 Sekunde auf TipOfTheDay-Fenster warten und entsprechend reagieren
   WinWaitActive, ahk_class TTipOfTheDayForm,,1
   If ErrorLevel = 0
   {
      Send, {ESC}
      WinWaitClose, ahk_class TTipOfTheDayForm
   }

   ; Neuen Font anlegen
   Send, ^n
   ; Warten bis der Dialog "New TrueType Font" erscheint
   WinWaitActive, ahk_class TNewTrueTypeFontForm
   ; Gre des Dialogs ermitteln
   WinGetPos, x, y, w, h, ahk_class TNewTrueTypeFontForm
   ; Hinweis unterhalb des Dialogs einblenden
   ToolTip, %SkriptName% - Bitte einen Font-Namen eingeben`nund den Dialog mit OK besttigen., %x%, % y+h
   ; Warten bis der Dialog vom Benutzer besttigt wurde und verschwindet
   WinWaitClose, ahk_class TNewTrueTypeFontForm
   ; Hinweis ausblenden
   ToolTip
   ; Warten bis Fontbersicht erscheint
   WinWait, ahk_class TMainFormFontCreator,.ttf

   ; Hinweis, dass die Verarbeitung nun beginnt
   SplashImage, ,M,Bilddateien werden in FontCreator importiert ...,,%SkriptName%

   ; Alle BMP-Dateien einlesen
   Loop, %A_Workingdir%\*.bmp
      BMPDateien = %BMPDateien%%A_LoopFileFullPath%`n
   ; eingelesene Dateien alphabetisch sortieren
   Sort, BMPDateien

   ; Alle BMP-Dateien abarbeiten
   Loop, Parse,BMPDateien, `n
   {
      ; Leeren Eintrag berspringen
      If A_LoopField =
         continue
      ; reinen Dateinamen ermitteln
      SplitPath, A_LoopField, Dateiname
      ; Hinweis einblenden
      SplashImage, ,M,Bilddateien werden in FontCreator importiert ...,%Dateiname%,%SkriptName%

      ; Beim Ausrufezeichen beginnen
      GoTo := A_Index+3
      ; Suchen-Dialog aufrufen
      send, ^f
      ; Warten bis Suchen-Dialog aktiv
      WinWaitActive, ahk_class TFindForm
      ; Reiter im Dialog fokusieren
      ControlFocus, TPageControl1, ahk_class TFindForm
      ; Letzten Reiter auswhlen (Index)
      Send, {End}
      ; Eingabefeld 'Index' fokusieren
      ControlFocus, TSpTBXSpinEdit.UnicodeClass1, ahk_class TFindForm
      ; etwas warten
      Sleep, 100
      ; Nummer des Zeichens im Suchen-Dialog angeben und besttigen
      Send, %GoTo%{Enter}{ESC}
      ; Warten bis Suchen-Dialog verschwindet
      WinWaitClose, ahk_class TFindForm
      Sleep, 50
      ; Menbefehl "Tools/Import Image..." aufrufen
      Send, !li
      ; Warten bis Import-Dialog erscheint
      WinWaitActive, ahk_class TConvertBitmapToContoursForm
      ; "Load" ausfhren
      Send, !l
      ; Warten bis Load-Dialog aktiv
      WinWaitActive, ahk_class #32770
      ; Dateipfad der aktuellen BMP einfgen und besttigen
      ClipBoard =
      ClipBoard = %A_LoopField%
      ClipWait, 0.5
      Send, ^v{Enter}
      ; Warten bis Load-Dialog verschwindet
      WinWaitClose, ahk_class #32770
      ; Warten bis Import-Dialog wieder aktiv
      WinWaitActive, ahk_class TConvertBitmapToContoursForm
      Sleep, 100

      ; Wenn erste BMP-Datei, dann ...
      If A_Index = 1
      {
         ; Hinweis ausblenden
         SplashImage, Off
         ; Gre des Import-Dialogs ermitteln
         WinGetPos, x, y, w, h, ahk_class TConvertBitmapToContoursForm
         ; "Default" aktivieren, damit die manuell vorgenommenen
         ; Einstellungen gespeichert werden
         Control, Check,, TSpTBXCheckBox.UnicodeClass2, ahk_class TConvertBitmapToContoursForm
         ; Hinweis unter dem Import-Dialog anzeigen
         ToolTip, %SkriptName% - Bitte Einstellungen vornehmen und 'Generate' klicken`nFolgende Einstellungen sind unter 'Glyph' empfehlenswert:`nPosition: unten links`nX position: 0`nY position: 0`nMultiplier: %MultiplierValue%, %x%, % y+h
      }
      Else
      {
         ; Bei allen weiteren BMPs automatisch Generieren ausfhren
         Send, !g
      }
      ; Warten bis Import-Dialog verschwindet
      WinWaitClose, ahk_class TConvertBitmapToContoursForm
      ; Hinweis ausblenden
      ToolTip
      ; Warten bis Fortschrittbalken sichtbar
      WinWait, ahk_class TGenerateContoursCancelForm
      ; Warten bis Fortschrittbalken wieder verschwindet
      WinWaitClose, ahk_class TGenerateContoursCancelForm
      Sleep, 100
   }

   ; Zwischenablage wiederherstellen
   ClipBoard = %Zwischenablage%

   ; Hinweise ausblenden
   SplashImage, Off
   ; Fertig
   Msgbox,,%SkriptName%,Verarbeitung abgeschlossen!
   ExitApp
Return

PotraceParameterHelp:
   Gui, +OwnDialogs
   MsgBox, , Hilfe zu den Potrace-Parametern,
   ( LTrim
      Mit den Potrace-Parametern kann man die Optimierung der Buchstaben beeinflussen.

      -x N `t Die erzeugten Bilddateien werden um das N-fache skaliert,
           `t was zu hher aufgelsten Bildern fhrt. (Standard 1)

      t N `t ignoriert Flecken mit einer Gre von bis zu N Pixeln.

      -a N `t Regelt die Eckenerkennung, der hchste Wert 1.334 fhrt dazu,
           `t dass berhaupt keine Ecken erzeugt werden. Ein negativer Wert
           `t fhrt zu Polygonen ohne jegliche Rundungen. (Standard 1)

      -O N `t Toleranzwert der Kurvenoptimierung. Hhere Werte fhren zu
           `t einfacheren Pfaden, aber zu ungenaueren Ergebnissen. (Standard 0.2)

      -n   `t Kurvenoptimierung ausschalten. Normalerweise versucht Potrace
           `t benachbarte Segmente zu einem Segment zu vereinen.

      Weitere Parameter finden Sie in der Hilfe zu Potrace:
      http://potrace.sourceforge.net/potrace.html
   )
Return
