/*
============================================================================
 Name        : CHelloworldAppUi.cpp
 Author      : Frank Fitzek And Morten V. Pedseren
 Copyright   : Mobile Devices Team - AAU
 Description : CHelloworldAppUi implementation
============================================================================
*/

// INCLUDE FILES
#include "HelloworldAppui.h"
#include "HelloworldContainer.h"
#include <Helloworld.rsg>
#include "Helloworld.hrh"

#include <avkon.hrh>
#include <aknnotewrappers.h>
#include <obexconstants.h>
#include <obex.h>
#include <bt_sock.h>
#include <btextnotifiers.h>

#include "Filepusher.h"


// ================= MEMBER FUNCTIONS =======================
//
// ----------------------------------------------------------
// CHelloworldAppUi::ConstructL()
//
// ----------------------------------------------------------
//
void CHelloworldAppUi::ConstructL()
    {
    BaseConstructL();

    iAppContainer = new (ELeave) CHelloworldContainer;
    iAppContainer->SetMopParent( this );
    iAppContainer->ConstructL( ClientRect() );
    AddToStackL( iAppContainer );
    
    iFilepusher = CFilepusher::NewL();
    }

// ----------------------------------------------------
// CHelloworldAppUi::~CHelloworldAppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
CHelloworldAppUi::~CHelloworldAppUi()
    {
    if (iAppContainer)
        {
        RemoveFromStack( iAppContainer );
        delete iAppContainer;
        }
   }

// ------------------------------------------------------------------------------
// CHelloworldAppUi::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
// ------------------------------------------------------------------------------
//
void CHelloworldAppUi::DynInitMenuPaneL(
    TInt /*aResourceId*/,CEikMenuPane* /*aMenuPane*/)
    {
    }

// ----------------------------------------------------
// CHelloworldAppUi::HandleKeyEventL(
//     const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
// takes care of key event handling
// ----------------------------------------------------
//
TKeyResponse CHelloworldAppUi::HandleKeyEventL(
    const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
    {
    return EKeyWasNotConsumed;
    }

// ----------------------------------------------------
// CHelloworldAppUi::HandleCommandL(TInt aCommand)
// takes care of command handling
// ----------------------------------------------------
//
void CHelloworldAppUi::HandleCommandL(TInt aCommand)
    {
    switch ( aCommand )
        {
        case EAknSoftkeyBack:
        case EEikCmdExit:
            {
            Exit();
            break;
            }
        case EHelloworldCmdAppTest:
            {
			// Info message shown only in the emulator
			iEikonEnv->InfoMsg(_L("test"));

			// Load localized message from the resource file
			HBufC* message = CEikonEnv::Static()->AllocReadResourceLC(R_MESSAGE_TEXT);
			// Show information note dialog
            CAknInformationNote* note = new (ELeave) CAknInformationNote;
            note->ExecuteLD(message->Des());
			CleanupStack::PopAndDestroy(message);
            break;
            }
        case EPushFile:
        {
            iFilepusher->StartL();
            break;
        }
        default:
            break;
        }
    }

void CHelloworldAppUi::PushFileL()
{  
    RNotifier notifier;
TBTDeviceResponseParamsPckg respons;
TBTDeviceSelectionParamsPckg filter;
TBTDevAddr btAddr;
            
User::LeaveIfError(notifier.Connect());
CleanupClosePushL(notifier);
TRequestStatus status; 
notifier.StartNotifierAndGetResponse(status, KDeviceSelectionNotifierUid, filter, respons);
User::WaitForRequest(status);
User::LeaveIfError(status.Int());
CleanupStack::PopAndDestroy(&notifier);

            
btAddr = respons().BDAddr();

_LIT( KServerTransportName,"RFCOMM" );
_LIT( KFileName, "C:\\pushfile.txt");
static const TUint KPort = 9;

TObexBluetoothProtocolInfo protocolInfo;
protocolInfo.iTransport.Copy( KServerTransportName );
protocolInfo.iAddr.SetBTAddr( btAddr );
protocolInfo.iAddr.SetPort( KPort );
    
CObexClient *client = CObexClient::NewL(protocolInfo);
CleanupStack::PushL(client);
    
TRequestStatus status1;    
client->Connect(status1);
User::WaitForRequest(status1);
User::LeaveIfError(status1.Int());

CObexFileObject *obexFile = CObexFileObject::NewL();
CleanupStack::PushL(obexFile);
obexFile->InitFromFileL(KFileName);
//
TRequestStatus status2;
client->Put(*obexFile, status2);
User::WaitForRequest(status2);
User::LeaveIfError(status2.Int());
client->Disconnect(status);
User::WaitForRequest(status); 
User::LeaveIfError(status.Int());

CleanupStack::PopAndDestroy(1);

     
}


