/*
============================================================================
 Author      : Frank Fitzek And Morten V. Pedseren
 Copyright   : Mobile Devices Team - AAU
============================================================================
*/

#include "Filepusher.h"

#include <e32base.h>
#include <obexconstants.h>
#include <obex.h>
#include <bt_sock.h>
#include <btextnotifiers.h>

/** Adding the hard coded OBEX connection parameters */
_LIT( KServerTransportName,"RFCOMM" );
_LIT( KFileName, "C:\\pushfile.txt");
static const TUint KPort = 9;


CFilepusher* CFilepusher::NewL()
{
	CFilepusher *self = new (ELeave) CFilepusher;
	CleanupStack::PushL(self);
	self->ConstructL();
	CleanupStack::Pop(self);
	return self;
}

CFilepusher::~CFilepusher()
{
	Cancel();
       
	delete iClient;
	delete iObexFile;
}

void CFilepusher::ConstructL()
{

}

CFilepusher::CFilepusher() : CActive(EPriorityStandard), iState(EIdle)
{
	CActiveScheduler::Add(this);
}

void CFilepusher::StartL()
{
    if(iState != EIdle)
    {
        User::Leave(KErrInUse);
    }
    
    /** Search for Other Devices */
    RNotifier notifier;
    TBTDeviceResponseParamsPckg respons;
    TBTDeviceSelectionParamsPckg filter;
            
    User::LeaveIfError(notifier.Connect());
    CleanupClosePushL(notifier);
    TRequestStatus status;
    notifier.StartNotifierAndGetResponse(status, KDeviceSelectionNotifierUid, filter, respons);
    User::WaitForRequest(status);
    CleanupStack::PopAndDestroy(&notifier);
            
    iBTAddr = respons().BDAddr();
    
    /** Connecting To the OBEX Service */
    TObexBluetoothProtocolInfo protocolInfo;
    protocolInfo.iTransport.Copy( KServerTransportName );
    protocolInfo.iAddr.SetBTAddr( iBTAddr );
    protocolInfo.iAddr.SetPort( KPort );
    
    iClient = CObexClient::NewL(protocolInfo);
    iClient->Connect(iStatus);
    
    /** Change state */
    iState = EConnecting;
    
	SetActive();
}

void CFilepusher::RunL()
{
    /** If any errors occour we leave */
    User::LeaveIfError(iStatus.Int());
    
	if(iState == EConnecting)
	{
        /** Transferring the Selected File */
        iObexFile = CObexFileObject::NewL();
        iObexFile->InitFromFileL(KFileName);
        iClient->Put(*iObexFile, iStatus);

        iState = ETransferring;
		SetActive();
	}
	else if(iState == ETransferring)
	{	
		iClient->Disconnect(iStatus);
        iState = EDisconnecting;
		SetActive();		
	}
	else if(iState == EDisconnecting)
	{
        delete iObexFile;
        iObexFile = 0;
		delete iClient;
		iClient = 0;
        
        iState = EIdle;
	}
}

TInt CFilepusher::RunError(TInt aError)
{
    // Notify the user that an error occured
    delete iObexFile;
    iObexFile = 0;
    delete iClient;
    iClient = 0;
    
    iState = EIdle;
    return KErrNone;
}


	
void CFilepusher::DoCancel()
{	
    delete iObexFile;
    iObexFile = 0;
    delete iClient;
    iClient = 0;
    
    iState = EIdle;
}   

     