// $Id: Stopwatch.h 302 2007-05-03 15:20:29Z olau $

#pragma once

#include "stdafx.h"

class Stopwatch {

private:
    LARGE_INTEGER t0;
    LARGE_INTEGER t1;
    double freq;
    BOOL running;
    BOOL highResTimerAvailable;

public:
    Stopwatch(int startupMode = START_IMMEDIATELY);

    inline void start(void)
    {
        running = TRUE;
        QueryPerformanceCounter(&t0);
    }

    inline void stop(void)
    {
        QueryPerformanceCounter(&t1);
        running = FALSE;
    }

    inline double elapsed(void)
    {
        if (running != FALSE)
            stop();
        return (double) (t1.QuadPart - t0.QuadPart) * freq;
    }

    inline BOOL hasHighResolutionTimer(void)
    {
        return highResTimerAvailable;
    }

    enum StartMode {
        START_MANUALLY,
        START_IMMEDIATELY,
    };
};
