// $Id: Threads.cpp 302 2007-05-03 15:20:29Z olau $

#include "stdafx.h"

double sumSpeed = 0.0;
int speedSamples = 0;


int RenderJob::run(void)
{
    printf("RenderJob::run() thread 0x%04x, job %2d, re(c) = %.13lf, im(c) = %.13lf\n",
        GetCurrentThreadId(), m_id, m_tile->reC, m_tile->imC);
    m_iterations = mandel.render(m_tile->reC, m_tile->imC, m_tile->scale, &m_tile->bitmap, m_restart);
    printf("RenderJob::run() thread 0x%04x, job %2d, %I64d iterations\n",
        GetCurrentThreadId(), m_id, m_iterations);
    return 0;
}


void WaitForWorkerThreads()
{
    pool->waitForAll();
    EnterCriticalSection(&critSecZooming);
    int currentlyZooming = zooming;
    LeaveCriticalSection(&critSecZooming);
    if (!currentlyZooming)
        RedrawWindow(hMainWindow, NULL, NULL, RDW_INVALIDATE);
}


static void PrintStatus(double speed)
{
    ++speedSamples;
    sumSpeed += speed;
    double avgSpeed = sumSpeed / speedSamples;
    printf("** %.1lfM iters/s (avg. %.1lfM iters/s)\n"
        "  scale=%g, re(c)=%.17lf, im(c)=%.17lf\n",
        1e-6 * speed, 1e-6 * avgSpeed,
        scaleFactor, centerR, centerI);
}


static double Recalculate()
{
    stopwatch->start();
    FillPool();
    pool->run();
    pool->waitForAll();
    printf("time elapsed: %g ms\n", 1000*stopwatch->elapsed());

    double speed = CalcItersPerSecond();
    PrintStatus(speed);
    return speed;
}


static double ZoomIn(int multiple)
{
    scaleFactor *= pow(AutomaticZoomInFactor, multiple);
    return Recalculate();
}


static double ZoomOut(int multiple)
{
    scaleFactor *= pow(AutomaticZoomOutFactor, multiple);
    return Recalculate();
}


// this thread controls the automatic zoom in/out
THREADID WINAPI AutomaticZoomThread(LPVOID)
{
    SetThreadName(-1, "AutomaticZoomThread");
    bool forceAbort;
    for (;;)
    {
        while (scaleFactor > MaxZoom)
        {
            EnterCriticalSection(&critSecAbort);
            forceAbort = doAbort;
            LeaveCriticalSection(&critSecAbort);
            if (forceAbort)
            {
                return 0;
            }
            ZoomIn(1);
        }
        while (scaleFactor < MinZoom)
        {
            EnterCriticalSection(&critSecAbort);
            forceAbort = doAbort;
            LeaveCriticalSection(&critSecAbort);
            if (forceAbort)
            {
                return 0;
            }
            ZoomOut(1);
        }
    }
    return 0;
}


THREADID WINAPI TriggerThread(LPVOID params)
{
    TriggerParam *p = (TriggerParam *) params;
    SetThreadName(-1, "TriggerThread");
    bool forceAbort;
    for (;;)
    {
        EnterCriticalSection(&critSecAbort);
        forceAbort = doAbort;
        LeaveCriticalSection(&critSecAbort);
        if (forceAbort)
            return 0;

        // wait for new work
        DWORD rc = WaitForSingleObject(hTriggerEvent, INFINITE);
        if (rc != WAIT_OBJECT_0)
            fprintf(stderr, "TriggerThread() line %d: waiting on event failed\n", __LINE__);

        switch (p->action)
        {
        case TriggerPan:
            Recalculate();
            break;
        case TriggerZoom:
            Recalculate();
            zoomDelta = 1.0;
            zooming = NotZooming;
            break;
        default:
            break;
        }
    }
    return 0;
}
