// $Id: ParallelLog.h 249 2007-04-26 08:48:05Z olau $

#pragma once

struct LogEntry
{
    time_t timestamp;
    DWORD threadId;
    const char *msg;
};


class ParallelLog
{
private:
    LONG idx;
    LONG maxIdx;
    static const LONG DefaultSize = 1024;
    LogEntry *buf;

public:
    ParallelLog(LONG size = DefaultSize);
    ~ParallelLog(void);
    void addEntry(const char *msg);
    void print(void);
    void reset(void);
};
