#!/usr/bin/perl
#
# Programm zum Ablegen einer Datei in jedes Verzeichnis eines FTP-Servers
#
# Copyright: Heise Zeitschriften Verlag, Redaktion c't
# Autor: Erich Kramer, 2007
#
# benoetigt ReadKey.pm Listing.pm FTP.pm
# unter Ubuntu installieren mit:
#
# sudo apt-get install libterm-readkey-perl libwww-perl libnet-perl


use strict "vars"; # alle Variablen muessen deklariert werden!
use strict "subs";
no strict "refs";

use Net::FTP;
use Term::ReadKey;    # fuer die Passwortabfrage
use File::Listing;

my $version = "1.1";
my $stand = "08.08.2007";

my $ftp_server;
my $ftp_user;
my $ftp_pswd;
my $ftp_verzeichnis;
my $put_datei;

my @dir_liste;  # Liste der ftp-Verzeichnisse
my $ftp;


#******************************************************
# Vezeichnisse rekursiv durchgehen:
#******************************************************
sub get_dir($)
{
	my ($ftp_pfad) = @_;
	
	unless($ftp->cwd($ftp_pfad)) {
	  print "\n\"cd $ftp_pfad\" ist fehlgeschlagen: " . $ftp->message;
	  return;  # wenn der Eintrag kein Verzeichnis war: zurueck
	}
	
	foreach my $eintrag (@{parse_dir($ftp->dir())}) {
		my ($name, $type) = @$eintrag;
		next if ($name =~ /^\./);
	
		if ($type eq 'd') {
			push (@dir_liste, "$ftp_pfad/$name");
			get_dir("$ftp_pfad/$name");
		}
	}
}

#******************************************************
# main
#******************************************************
print "Programm zum Ablegen einer Datei in jedes Verzeichnis eines FTP-Servers\n";
print "Version $version von Erich Kramer\n";
print "\nStand: $stand\n";

if ((@ARGV < 2) || (@ARGV > 4)) {
	print "\nAufruf:";
	print "\nftp_spread.pl Datei Server [Username] [Passwort]\n";
	exit 0;
}

my $put_datei  = shift(@ARGV);
my $ftp_server = shift(@ARGV);
my $ftp_user   = shift(@ARGV);
my $ftp_pswd   = shift(@ARGV);

my ($mtime) = (stat($put_datei))[9];
unless ($mtime) {
	print "\nAufruf:";
	print "\nftp_spread.pl Datei Server [Username] [Passwort]";
	print "\nDie angegebene Datei ist nicht vorhanden\n";
	exit 0;
}

$ftp_server =~ s/^ftp:\/\///;  # "ftp://" am Anfang loeschen
my @server_pfade = split(/\//, $ftp_server);
$ftp_server = shift(@server_pfade);
my $ftp_verzeichnis = "/" . join("/", @server_pfade);
$ftp_verzeichnis =~ s/\/$//;  # Slash am Ende loeschen
push (@dir_liste, $ftp_verzeichnis);

# Usernamen abfragen, falls er nicht mit uebergeben wurde:
unless ($ftp_pswd) {
	print "\nBitte geben Sie den Usernamen fuer $ftp_server an: ";
	$ftp_user = <STDIN>;
	chomp $ftp_user;
}

# Passwort abfragen, falls es nicht mit uebergeben wurde:
unless ($ftp_pswd) {
	print "\nBitte geben Sie das Passwort fuer $ftp_user\@$ftp_server an: ";
	ReadMode 'noecho';
	$ftp_pswd = ReadLine 0;
	chomp $ftp_pswd;
	ReadMode 'normal';
	print "\n";
}

# beim ftp-Server anmelden:
print "\nkontaktiere $ftp_server ...";
unless($ftp = Net::FTP->new("$ftp_server", Debug => 0)) {
  print "\nkann $ftp_server nicht erreichen: $@\n";
  exit 0;
}
print "\nuser login...";
unless($ftp->login($ftp_user, $ftp_pswd)) {
  print "\nLogin fehlgeschlagen: " . $ftp->message . "\n";
  exit 0;
}

# UEbertragungsmodus auf binary setzen:
$ftp->binary;

get_dir($ftp_verzeichnis);

my @put_datei_pfad = split(/\//, $put_datei);
my $put_dateiname = pop(@put_datei_pfad);
foreach my $ftp_pfad (@dir_liste) {
	unless($ftp->put($put_datei, "$ftp_pfad/$put_dateiname")) {
	  print "\nKann \"$ftp_pfad/$put_dateiname\" nicht anlegen: " . $ftp->message . "\n";
	} else {
	  print "\n$ftp_pfad/$put_dateiname";
	}
}

$ftp->quit();
print "\nVorgang erfolgreich abgeschlossen\n";
