// Stern interaktiv
// Den Mittelpunkt der Strahlen bestimmt der Mauszeiger,
// ein Mausklick speichert eine Momentaufnahme als Bitmap.

float winkel; 
float laenge; 
float dx; 
float dy;
int breite;

// Die Methode setup() ruft Processing beim Programmstart einmal auf
void setup(){
  size(600, 600);
  background(15, 15, 20);
  // Mauscursor wird als Hand dargestellt
  cursor(HAND);
  smooth();
  // Bei Programmstart sollen die Strahlen vom Mittelpunkt des Fensters ausgehen
  mouseX = width/2;
  mouseY = height/2;
}

// Die Methode draw() ruft Processing nach setup() immer wieder neu auf
void draw (){
  // zufaellige Linienbreite
  breite = int(random(1,7));
  strokeWeight(breite);
  // zufaellige Farbe (innerhalb gewisser Grenzen)
  stroke (random (25, 150), random (5, 255), random(100));  
  // zufaelliger Winkel
  winkel = random(0, 2*PI); 
  // je breiter sie sind, umso kuerzer sollen die Linien sein
  laenge = random((min(width/2, height/2))*(7-breite)/6);
  dx = cos(winkel)*laenge;
  dy = sin(winkel)* laenge;
  line (mouseX, mouseY,  mouseX+dx, mouseY-dy); 
}

// Die Methode mousePressed() ruft Processing automatisch auf, 
// sobald eine Maustaste gedrckt wird
void mousePressed(){
  // aktueller Inhalt des Programmfensters wird als Pixelbild gespeichert
  save("Stern.png");
}
