﻿using System;
using System.Linq; 
using System.IO;   
using System.IO.Pipes;   
using System.Xml.Linq;
using System.Collections.Generic;
using System.Reflection;
using System.Configuration;
using System.Data.Linq;


namespace Linqs234
{

  class Program
  {

    static string[] Wochentage = new string[] { "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag", "Sonntag" };
    static void Main(string[] args)
    {
      // Linq2Object(); 
       Linq2Sql(); 
      // Linq2DataSet();
      // Linq2Xml(); 
    }
    static void Linq2Xml()
    {
      XElement xel = XElement.Load(@"..\..\contacts.xml");
      var erg = from xnode in xel.Elements("contact")
                where xnode.Attribute("name").Value == "Andrea"
                select xnode;
    }
    static void Linq2DataSet()
    {
      System.Data.SqlClient.SqlDataAdapter da = new System.Data.SqlClient.SqlDataAdapter("select * from Customers",
        @"Data Source=PHOENIX\SQLEXPRESS;Initial Catalog=Northwind;Integrated Security=True");
      Cust2ProdDataSet c2pds = new Cust2ProdDataSet();
      da.Fill(c2pds.Customers);
      var a = from c in c2pds.Customers
              where c.City == "Berlin"
              select c.ContactName;
    }
    static void Linq2Sql()
    {
      var cs1 = System.Configuration.ConfigurationManager.ConnectionStrings[0].ConnectionString;
      var context1 = new System.Data.Linq.DataContext(cs1);
      Cust2ProdDataContext nc = new Cust2ProdDataContext();

      // welche Kunden haben welche Produkte bestellt? 
      var custProds = from c in nc.GetTable<Customer>() from o in c.Orders
                      from od in o.Order_Details orderby c.ContactName
                      select new { c.ContactName, od.Product.ProductName };
    }

    static void Linq2Object()
    {
      var Tage = new [] { "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag", "Sonntag" };
      var Termine = new [] { new { Name = "Zahnarzt", Tag = "Montag" } };

      // LINQ-Beispiele
      var tagTage = from w in Tage select w.Substring(0, 2);
      var TageTermineJoin = from t in Tage join e in Termine on t equals e.Tag select e;

      // Anwendung von Lambda-Ausdrücken 
      var tagTage1 = Tage.Where(p => p.Contains("tag"));
      var TageTermineJoin1 = Tage.Join(Termine,     // verknüpfte Menge
        p => p,      // Tage-Elementselector für Verknüpfung 
        q => q.Tag,  // Termine-Elementselector für Verknüpfung
        (p, q) => q); // Ergebnisselector (Reihenfolge ist wichtig)
    }
  }
  // Für Kasten: Der Ball ist rund
  public static class myExtensions
  {
    public delegate bool predicate<S>(S t);
    public static IEnumerable<T> Subset<T>(this IEnumerable<T> liste, Func<T, bool> v)
    {
      List<T> erg = new List<T>(); 
      foreach (T t in liste)
        if (v(t)) erg.Add(t);
      return erg;
    }  
  }

  // partielle Methoden
  partial class PartMethod
  { 
    partial void doubler(ref double d);
  }
  partial class PartMethod
  { 
    partial void doubler(ref double d) { d*=2; } 
  }
}