// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>
// Heise Zeitschriften Verlag, Hannover, Germany

#ifndef __IMAGESCALER_P_H_
#define __IMAGESCALER_P_H_

#include <QString>
#include <QSize>
#include <QFileInfo>
#include <QImage>
#include <QImageReader>
#include <QImageWriter>


#ifdef Q_OS_WIN
static const QString PathDelimiter("\\");
#else
static const QString PathDelimiter("/");
#endif


#ifdef USE_THREADPOOL

#include <ThreadPool.h>

class ImageScalingJob : public Job
{
public:
    ImageScalingJob(const QString& imageFileName, const QSize& thumbnailSize = QSize(100, 100))
        : imageFileName(imageFileName), thumbnailSize(thumbnailSize)
    { }
    ~ImageScalingJob()
    { }
    void run(void)
    {
        QFileInfo pathInfo(imageFileName);
        QString thumbnailFileName(pathInfo.absolutePath()
            + PathDelimiter + "thumb_" + pathInfo.fileName());
		if (pathInfo.exists())
		{
			QImageReader imageReader(imageFileName);
			QImageWriter imageWriter(thumbnailFileName);
			const QImage thumbnail = imageReader.read().scaled(thumbnailSize, Qt::KeepAspectRatio, Qt::SmoothTransformation);
			imageWriter.write(thumbnail);
		}
    }

private: // variables
    QString imageFileName;
    QSize thumbnailSize;
};

#else

class ImageScalerPrivate
{
public:
    ImageScalerPrivate(const QSize& thumbnailSize = QSize(100, 100))
        : thumbnailSize(thumbnailSize)
    { }
    QString operator() (const QString& imageFileName) const
    {
        QFileInfo pathInfo(imageFileName);
        QString thumbnailFileName(pathInfo.absolutePath()
            + PathDelimiter + "thumb_" + pathInfo.fileName());
		if (pathInfo.exists())
		{
			QImageReader imageReader(imageFileName);
			QImageWriter imageWriter(thumbnailFileName);
			const QImage thumbnail = imageReader.read().scaled(thumbnailSize, Qt::KeepAspectRatio, Qt::SmoothTransformation);
			imageWriter.write(thumbnail);
	        return thumbnailFileName;
		}
		return QString();
    }
	void setSize(const QSize& s)
	{
		thumbnailSize = s;
	}

private: // variables
    QSize thumbnailSize;
};

#endif // USE_THREADPOOL


#endif // __IMAGESCALER_P_H_
