// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>
// Heise Zeitschriften Verlag, Hannover, Germany

#include <QThread>
#include "mainwindow.h"

MainWindow::MainWindow(QMainWindow *parent, Qt::WFlags flags)
    : QMainWindow(parent, flags)
{
    setWindowTitle(tr("Bildskalierer"));
    imageScalerWidget = new ImageScaler(QThread::idealThreadCount(), this);
    statusBar()->showMessage("Bilddateien zum Skalieren auswhlen ...", 3000);
    setCentralWidget(imageScalerWidget);
    QObject::connect(imageScalerWidget, SIGNAL(showMessage(const QString &)), this, SLOT(showMessage(const QString &)));
}


MainWindow::~MainWindow()
{
}


void MainWindow::showMessage(const QString &message)
{
    statusBar()->showMessage(message);
}
