#include <QApplication>
#include <QImage>
#include <QList>
#include <QThread>
#include <QDebug>
#include <QFuture>
#include <QFutureWatcher>
#include <QtConcurrentMap>


#include "progressprinter.h"

QImage scale(const QImage &image)
{
    qDebug() << "Scaling image in thread" << QThread::currentThread();
    return image.scaled(QSize(100, 100), Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
}


class MyThread : public QThread
{
	QFuture<QImage> thumbnails;
	ProgressPrinter progressPrinter;
public:
	MyThread() { }
	~MyThread() { }
	void run()
	{
		qDebug() << "thread" << QThread::currentThread() << "started";
	    const int imageCount = 20;
		// Create a list containing imageCount images.
		QList<QImage> images;
		for (int i = 0; i < imageCount; ++i)
			images.append(QImage(1600, 1200, QImage::Format_ARGB32_Premultiplied));

		// Use QtConcurrentBlocking::mapped to apply the scale function to all the
		// images in the list.
		thumbnails = QtConcurrent::mapped(images, scale);

		QFutureWatcher<QImage> watcher;
		watcher.setFuture(thumbnails);

		QObject::connect(&watcher, SIGNAL(progressValueChanged(int)), &progressPrinter, SLOT(slot_progressValueChanged(int)));

		thumbnails.waitForFinished();

		qDebug() << "thread" << QThread::currentThread() << "finished";
	}
};


int main(int argc, char* argv[])
{
    QApplication app(argc, argv);

	qDebug() << "main thread" << QThread::currentThread() << "started";

	MyThread th;
	QObject::connect(&th, SIGNAL(finished()), &app, SLOT(quit()));
	th.start();
	th.wait();

	qDebug() << "main thread" << QThread::currentThread() << "about to finish";
	int rc = app.exec();
	qDebug() << "main thread" << QThread::currentThread() << "finished.";

	return rc;
}
