#!/bin/sh
# Environment:
#  IFACE      = Logical interface name
#  MODE       = { start | stop }
#  METHOD     = manual, otherwise exit
#  ADDRFAM    = inet6, otherwise exit

# ADDRFAM muss inet6 sein
if [ "$ADDRFAM" != "inet6" ]; then
   echo "Fehlerhafter Aufruf ..."
   exit -1
fi

# Einstellungen aus /etc/default/sixxs laden:
#
# PREFIX=2001:db8:123::/48
# SUBNET=2001:db8:123:1/64
# ROUTER=2001:db8:123:1::1/64
# LAN=eth0

test -f /etc/default/sixxs && . /etc/default/sixxs || exit -1


# Adressen und Subnetz-Praefix zusammensetzen
echo "Prefix: $PREFIX"
echo "Subnet: $SUBNET"
echo "Router: $ROUTER"

case $MODE in
  start)
   ACTION=add
  ;;
  stop)
   ACTION=del
  ;;
esac

ip -6 route $ACTION $PREFIX dev lo
ip -6 route $ACTION 2000::/3 dev $IFACE
ip -6 addr  $ACTION dev $LAN $ROUTER
