VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsTasks"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private WithEvents mTasks As Outlook.Items
Attribute mTasks.VB_VarHelpID = -1
Private WithEvents mProject As Outlook.Folder
Attribute mProject.VB_VarHelpID = -1

'Objekte basierend auf der Klasse clsTasks reprsentieren die Tasks in einem Taskfolder,
'also einem Ordner unterhalt des Ordners "Projekte".

'ber diese ffentliche Eigenschaft weist man dem Objekt die Auflistung der enthaltenen Tasks zu.
Public Property Set Tasks(objTasks As Outlook.Items)
10        On Error GoTo Tasks_Err

20        Set mTasks = objTasks
          
Tasks_Exit:
30        On Error Resume Next
40        Exit Property
Tasks_Err:
50        Call Fehlerbehandlung("Projekt1/clsTasks", "Tasks", Erl, "Bemerkungen: ./.")
60        GoTo Tasks_Exit
End Property

'Gleiches gilt fr das "Projekt", also den eigentlichen Projektordner.
Public Property Set Project(objProject As Outlook.Folder)
10        On Error GoTo Project_Err

20        Set mProject = objProject

Project_Exit:
30        On Error Resume Next
40        Exit Property
Project_Err:
50        Call Fehlerbehandlung("Projekt1/clsTasks", "Project", Erl, "Bemerkungen: ./.")
60        GoTo Project_Exit
End Property

'Wenn der Ordner verschoben wird - entweder durch Drag and Drop in den Ordner "Gelschte Objekte"
'oder durch sonstige Lschvorgnge, wird diese Routine ausgelst.
Private Sub mProject_BeforeFolderMove(ByVal MoveTo As MAPIFolder, Cancel As Boolean)
          Dim strSQL As String
          Dim lngProjectID As Long
10        On Error GoTo mProject_BeforeFolderMove_Err

          'Ist das Ziel der Ordner "Gelschte Objekte", ...
20        If MoveTo.Name = "Gelschte Objekte" Then
              '... ermittelt diese Zeile die ID des Projektordners ...
30            lngProjectID = GetID(mProject.Description, "project")
              '... und stellt den Wert des Feldes GeloeschtAm des betroffenen
              'Datensatzes in der Datenbank auf das aktuelle Datum ein.
40            strSQL = "UPDATE tblProjekte SET GeloeschtAm = " & ISODatum(Now) & " WHERE ProjektID = " & lngProjectID
50            CurrentDBC.Execute strSQL, dbFailOnError
60        Else
              'Zieht man ihn anderswohin, erscheint eine passende Meldung ...
70            MsgBox "Projektordner knnen sich nur direkt unter dem Ordner 'Projekte' befinden.", vbOKOnly Or vbExclamation, "Operation nicht mglich"
              '... und die Aktion wird abgebrochen.
80            Cancel = True
90        End If

mProject_BeforeFolderMove_Exit:
100       On Error Resume Next
110       Exit Sub
mProject_BeforeFolderMove_Err:
120       Call Fehlerbehandlung("Projekt1/clsTaskItems", "mProject_BeforeFolderMove", Erl, "Bemerkungen: ./.")
130       GoTo mProject_BeforeFolderMove_Exit
End Sub

'BeforeItemMove wird ausgelst, wenn ein in dem Ordner befindliches Element verschoben werden soll.
'Dies kann nicht nur beim Lschen, sondern auch beim Verschieben in einen anderen Ordner geschehen.
Private Sub mProject_BeforeItemMove(ByVal Item As Object, ByVal MoveTo As MAPIFolder, Cancel As Boolean)
10        On Error GoTo mProject_BeforeItemMove_Err

          Dim lngProjectID As Long
          Dim lngTaskID As Long
          Dim strTask As String
          Dim strSQL As String
          Dim objTask As TaskItem
20        If TypeOf Item Is Outlook.TaskItem Then
30            Set objTask = Item
40            strTask = objTask.Subject
              'ID der Aufgabe ermitteln
50            lngTaskID = GetID(objTask.BillingInformation, "task")
              'ID des Zielordners ermitteln
60            lngProjectID = GetID(MoveTo.Description, "project")
              'Wenn Gelschte Objekte das Ziel ist, dann ...
70            If MoveTo.Name = "Gelschte Objekte" Then
                  '... Eintrag in der Datenbank als gelscht markieren
80                strSQL = "UPDATE tblAufgaben SET GeloeschtAM = " & ISODatum(Now) & " WHERE AufgabeID = " & lngTaskID
90                CurrentDBC.Execute strSQL
100           Else
                  '... sonst der Aufgabe den neuen Titel und die neue ID des bergeordneten Projekts zuweisen
110               strSQL = "UPDATE tblAufgaben SET Aufgabe = '" & strTask & "', ProjektID = " & lngProjectID & " WHERE AufgabeID = " & lngTaskID
120               CurrentDBC.Execute strSQL, dbFailOnError
130           End If
140       End If

mProject_BeforeItemMove_Exit:
150       On Error Resume Next
160       Exit Sub
mProject_BeforeItemMove_Err:
170       Call Fehlerbehandlung("Projekt1/clsTaskItems", "mProject_BeforeItemMove", Erl, "Bemerkungen: ./.")
180       GoTo mProject_BeforeItemMove_Exit
End Sub

'ItemAdd wird ausgelst, wenn der Tasks-Auflistung, also den Aufgaben eines Projekts, ein neuer Eintrag hinzufgt wird.
'Dies geschieht bei ganz neuen, aber auch bei verschobenen Items.
Private Sub mTasks_ItemAdd(ByVal Item As Object)
10        On Error GoTo mTasks_ItemAdd_Err

          Dim strAufgabe As String
          Dim strFertigstellenBis As String
          Dim strErledigtAm As String
          Dim objTask As Outlook.TaskItem
          Dim objProjectfolder As Outlook.Folder
          Dim strSQL As String
          Dim lngProjectID As Long
          Dim strDescription As String
          Dim strAction As String
          Dim strStartzeit As String
          Dim strEndzeit As String
          Dim lngTaskID As Long
20        If TypeOf Item Is Outlook.TaskItem Then
30            Set objTask = Item
              'Wenn Aufgabe schon vorhanden, dann abbrechen -
              'Datenbankeintrag wurde schon in BeforeItemMove geschrieben.
40            If GetID(objTask.BillingInformation, "task") > 0 Then
50                Exit Sub
60            End If
              'Aufgabentitel lesen
70            strAufgabe = objTask.Subject
              'bergeordneten Projektordner ermitteln
80            Set objProjectfolder = objTask.Parent
              'ID des Projekts aus der Eigenschaft Description auslesen
90            strDescription = objProjectfolder.Description
100           lngProjectID = GetID(strDescription, "project")
              'Wenn geplantes oder tatschliches Fertigstellungsdatum vorhanden, dann speichere es.
              'Die Abfrage bercksichtigt, dass leere Datumseigenschaften von Outlook als "1.1.4501" geliefert werden.
              'Wer die Anwendung nach 2100 verwenden mchte, muss hier den Code anpassen. ;-)
110           If objTask.DueDate < CDate("1.1.2100") Then
120               strFertigstellenBis = SQLDatum(objTask.DueDate)
130           Else
140               strFertigstellenBis = "NULL"
150           End If
160           If objTask.DateCompleted < CDate("1.1.2100") Then
170               strErledigtAm = SQLDatum(objTask.DateCompleted)
180           Else
190               strErledigtAm = "NULL"
200           End If
              'Aufgabe in der Datenbank speichern
210           strSQL = "INSERT INTO tblAufgaben(Aufgabe, ProjektID, FertigstellenBis, ErledigtAm) VALUES('" & strAufgabe & "', " & lngProjectID & ", " & strFertigstellenBis & ", " & strErledigtAm & ")"
220           CurrentDBC.Execute strSQL, dbFailOnError
              'Wenn erfolgreich, dann BillingInformationen auf die richtige ID einstellen
230           If CurrentDBC.RecordsAffected = 1 Then
240               objTask.BillingInformation = "[task|" & CurrentDBC.OpenRecordset("SELECT @@IDENTITY").Fields(0).Value & "]"
250               objTask.Save
260           End If
270           ThisOutlookSession.Application_Startup
280       End If
mTasks_ItemAdd_Exit:
290       On Error Resume Next
300       Exit Sub
mTasks_ItemAdd_Err:
310       Call Fehlerbehandlung("Projekt1/clsTasks", "mTasks_ItemAdd", Erl, "Bemerkungen: ./.")
320       GoTo mTasks_ItemAdd_Exit
End Sub

'Wird ausgelst, wenn ein Element der Tasks-Auflistung gendert wird.
Private Sub mTasks_ItemChange(ByVal Item As Object)
10        On Error GoTo mTasks_ItemChange_Err

          Dim lngProjectID As Long
          Dim lngTaskID As Long
          Dim strTask As String
          Dim strSQL As String
          Dim objTask As TaskItem
20        If TypeOf Item Is Outlook.TaskItem Then
30            Set objTask = Item
40            strTask = objTask.Subject
              'ID des Tasks einlesen
50            lngTaskID = GetID(objTask.BillingInformation, "task")
              'Projekt
60            strSQL = "UPDATE tblAufgaben SET Aufgabe = '" & strTask & "' WHERE AufgabeID = " & lngTaskID
70            CurrentDBC.Execute strSQL, dbFailOnError
80        End If

mTasks_ItemChange_Exit:
90        On Error Resume Next
100       Exit Sub
mTasks_ItemChange_Err:
110       Call Fehlerbehandlung("Projekt1/clsTasks", "mTasks_ItemChange", Erl, "Bemerkungen: ./.")
120       GoTo mTasks_ItemChange_Exit
End Sub

