Attribute VB_Name = "mdlGlobal"
Option Explicit

Private mCurrentDB As DAO.Database
Public Const cStrDB As String = "c:\Projektzeiterfassung\Projektzeiterfassung.accdb"
Public intCurrentItemType As Outlook.OlItemType
Public lngTaskID As Long

'Public Type TTask
'    TaskID As Long
'    ProjectID As Long
'    Subject As String
'End Type

Public Property Get CurrentDBC() As DAO.Database
10        On Error GoTo CurrentDBC_Err

20        If mCurrentDB Is Nothing Then
30            Set mCurrentDB = DBEngine.OpenDatabase(cStrDB, False)
40        End If
50        Set CurrentDBC = mCurrentDB

CurrentDBC_Exit:
60        On Error Resume Next
70        Exit Property
CurrentDBC_Err:
80        Call Fehlerbehandlung("Projekt1/mdlGlobal", "CurrentDBC", Erl, "Bemerkungen: ./.")
90        GoTo CurrentDBC_Exit
End Property

Public Function Fehlerbehandlung(strModul As String, strRoutine As String, lngZeile As Long, Optional strBemerkungen As String)
    Dim strFehler As String
    strFehler = strFehler & "Datum:              " & Format(Now, "yyyy-mm-dd, hh:nn:ss") & vbCrLf
    strFehler = strFehler & "Projekt:            Zeiterfassung" & vbCrLf
    strFehler = strFehler & "Modul:              " & strModul & vbCrLf
    strFehler = strFehler & "Routine:            " & strRoutine & vbCrLf
    strFehler = strFehler & "Fehlernummer:       " & Err.Number & vbCrLf
    strFehler = strFehler & "Fehlerbeschreibung: " & Err.Description & vbCrLf
    strFehler = strFehler & "Zeile:              " & lngZeile & vbCrLf
    strFehler = strFehler & "Bemerkungen:        " & strBemerkungen & vbCrLf
    MsgBox "Es ist ein Fehler aufgetreten. " & vbCrLf & strFehler
End Function

Public Function SQLDatum(varDate As Variant)
10        On Error GoTo SQLDatum_Err

20        SQLDatum = Format(varDate, "\#yyyy\-mm\-dd\#")

SQLDatum_Exit:
30        On Error Resume Next
40        Exit Function
SQLDatum_Err:
50        Call Fehlerbehandlung("Projekt1/mdlGlobal", "SQLDatum", Erl, "Bemerkungen: ./.")
60        GoTo SQLDatum_Exit
End Function

Public Function ISODatum(varDate As Variant)
10        On Error GoTo ISODatum_Err

20        ISODatum = Format(varDate, "\#yyyy\/mm\/dd hh\:nn\:ss\#")

ISODatum_Exit:
30        On Error Resume Next
40        Exit Function
ISODatum_Err:
50        Call Fehlerbehandlung("Projekt1/mdlGlobal", "ISODatum", Erl, "Bemerkungen: ./.")
60        GoTo ISODatum_Exit
End Function

Public Function GetID(str As String, strItemType As String) As Long
    On Error GoTo GetID_Err

    Dim intPosStart As Integer
    Dim intPosEnde As Integer
    Dim lngID As Long
    Dim intItemTypeLen As Integer
    intItemTypeLen = Len(strItemType)
    intPosStart = InStr(1, str, "[" & strItemType & "|")
    If intPosStart > 0 Then
        intPosEnde = InStr(intPosStart, str, "]")
        If intPosEnde > 0 Then
            lngID = Mid(str, intPosStart + 2 + intItemTypeLen, intPosEnde - intPosStart - 2 - intItemTypeLen)
        End If
    End If
    GetID = lngID

GetID_Exit:
    On Error Resume Next
    Exit Function
GetID_Err:
    Call Fehlerbehandlung("Projekt1/ThisOutlookSession", "GetID", Erl, "Bemerkungen: ./.")
    GoTo GetID_Exit
End Function

Public Sub SQLMessage(strMessage As String, bolResult As Boolean)
10        On Error GoTo SQLMessage_Err

20        If Not bolResult Then
30            MsgBox "Die Operation '" & strMessage & "' war nicht erfolgreich.", vbOKOnly Or vbCritical, "Synchronisierungsfehler"
40        End If

SQLMessage_Exit:
50        On Error Resume Next
60        Exit Sub
SQLMessage_Err:
70        Call Fehlerbehandlung("Projekt1/mdlGlobal", "SQLMessage", Erl, "Bemerkungen: ./.")
80        GoTo SQLMessage_Exit
End Sub
