; AutoCut.au3 -- c't Magazin 10/08
; Karsten Violka (kav@ctmagazin.de), Stefan Porteck (spo@ctmagazin.de)

#include <GUIConstants.au3>
#include <File.au3>
#include <Array.au3>

AutoItSetOption("TrayIconHide", 1)
AutoItSetOption("MustDeclareVars", 1)
AutoItSetOption("GUIOnEventMode", 1)

Global Const $INIFILE = "AutoCut.ini"

Global $cfg_outPath
Global $cfg_cuttermaran
Global $cfg_projectx
Global $cfg_comskip
Global $cfg_ffmpeg

Global $inpOutPath
Global $inpCuttermaran
Global $inpProjectx
Global $inpComskip
Global $inpFfmpeg
Global $inpSourceFile
Global $edtOutput
Global $prgProgressBar
Global $btnStart

buildGUI()
loadConfig()
writeToGUI()
GUISetState() ; Programmfenster sichtbar machen

If $CmdLine[0] > 0 Then
	GUICtrlSetData($inpSourceFile, $CmdLine[1])
	evtStart()
EndIf

While 1
	Sleep(1000) ; Endlosschleife fr den On-Event-Modus
WEnd

; ----- Ende des Hauptprogramms

Func buildGUI()
	GUICreate("AutoCut 0.07", 500, 400)
	GUISetFont(10, 400, 0, "Sans Serif")
	
	$edtOutput = GUICtrlCreateEdit("", 0, 221, 500, 120, $ES_READONLY + $ES_MULTILINE + $WS_VSCROLL + $ES_AUTOVSCROLL)
	$prgProgressBar = GUICtrlCreateProgress(10, 361, 340, 20)
	$btnStart = GUICtrlCreateButton("Start", 380, 360, 100, 24)
	
	Local $tab = GUICtrlCreateTab(0, 0, 500, 220)
	Local $tabMain = GUICtrlCreateTabItem("Konvertieren und TV-Werbung entfernen")
	
	GUICtrlCreateLabel("Quelldatei", 16, 40, 119, 20)
	$inpSourceFile = GUICtrlCreateInput("", 100, 40, 350, 22)
	Local $btnSourceFile = GUICtrlCreateButton("...", 460, 40, 20, 20)
	
	GUICtrlCreateLabel("Zielordner", 16, 80, 119, 20)
	$inpOutPath = GUICtrlCreateInput("", 100, 80, 350, 22)
	Local $btnOutPath = GUICtrlCreateButton("...", 460, 80, 20, 20)
	
	Local $tabConfig = GUICtrlCreateTabItem("Konfiguration")

	GUICtrlCreateGroup("Programme", 10, 30, 480, 175)

	GUICtrlCreateLabel("ffmpeg", 16, 50, 119, 20)
	$inpFfmpeg = GUICtrlCreateInput("", 120, 50, 330, 22)
	Local $btnFfmpeg = GUICtrlCreateButton("...", 460, 50, 20, 20)
	
	GUICtrlCreateLabel("ProjectX", 16, 90, 119, 20)
	$inpProjectx = GUICtrlCreateInput("", 120, 90, 330, 22)
	Local $btnProjectx = GUICtrlCreateButton("...", 460, 90, 20, 20)

	GUICtrlCreateLabel("Cuttermaran", 16, 130, 119, 20)
	$inpCuttermaran = GUICtrlCreateInput("", 120, 130, 330, 22)
	Local $btnCuttermaran = GUICtrlCreateButton("...", 460, 130, 20, 20)

	GUICtrlCreateLabel("Comskip", 16, 170, 119, 20)
	$inpComskip = GUICtrlCreateInput("", 120, 170, 330, 22)
	Local $btnComskip = GUICtrlCreateButton("...", 460, 170, 20, 20)

	; Ereignis-Funktionen zuordnen
	GUISetOnEvent($GUI_EVENT_CLOSE, "evtExit")
	GUICtrlSetOnEvent($btnSourceFile, "evtSourceFile")
	GUICtrlSetOnEvent($btnOutPath, "evtOutPath")
	GUICtrlSetOnEvent($btnProjectx, "evtProjectxPath")
	GUICtrlSetOnEvent($btnCuttermaran, "evtCuttermaranPath")
	GUICtrlSetOnEvent($btnComskip, "evtComskipPath")
	GUICtrlSetOnEvent($btnFfmpeg, "evtFfmpegPath")
	GUICtrlSetOnEvent($btnStart, "evtStart")
EndFunc   ;==>buildGUI

;----- Ereignisfunktionen
Func evtSourceFile()
	chooseFile($inpSourceFile, "Quelldatei", "Video-Datei (*.mpg; *.dvr-ms)")
EndFunc   ;==>evtSourceFile

Func evtOutPath()
	Local $folder = FileSelectFolder("Ausgabe-Verzeichnis", "", 2)
	If $folder <> "" Then
		GUICtrlSetData($inpOutPath, $folder)
	EndIf
EndFunc   ;==>evtOutPath

Func evtProjectxPath()
	chooseFile($inpProjectx, "ProjectX", "Java-Archiv (*.jar)")
EndFunc   ;==>evtProjectxPath

Func evtCuttermaranPath()
	chooseFile($inpCuttermaran, "Cuttermaran", "Ausfhrbare Datei (*.exe)")
EndFunc   ;==>evtCuttermaranPath

Func evtComskipPath()
	chooseFile($inpComskip, "Comskip", "Ausfhrbare Datei (*.exe)")
EndFunc   ;==>evtComskipPath

Func evtFfmpegPath()
	chooseFile($inpFfmpeg, "ffmpeg", "Ausfhrbare Datei (*.exe)")
EndFunc   ;==>evtFfmpegPath

Func chooseFile($inpField, $strTitle, $strFilter)
	Local $file = FileOpenDialog($strTitle, "", $strFilter, 1)
	If $file <> "" Then
		GUICtrlSetData($inpField, $file)
	EndIf
EndFunc

Func evtExit() ; Fenster schlieen
	readFromGUI()
	saveConfig()
	Exit
EndFunc   ;==>evtExit

Func evtStart() ; Startknopf
	readFromGUI()
	saveConfig()
	GUICtrlSetState($btnStart, $GUI_DISABLE)
	autoCut(GUICtrlRead($inpSourceFile), $cfg_outPath)
	GUICtrlSetState($btnStart, $GUI_ENABLE)
EndFunc   ;==>evtStart

Func loadConfig()
	$cfg_outPath = IniRead(@ScriptDir & "\" & $INIFILE, "Paths", "Output", "")
	$cfg_cuttermaran = IniRead(@ScriptDir & "\" & $INIFILE, "Paths", "Cuttermaran", "")
	$cfg_projectx = IniRead(@ScriptDir & "\" & $INIFILE, "Paths", "Projectx", "")
	$cfg_comskip = IniRead(@ScriptDir & "\" & $INIFILE, "Paths", "Comskip", "")
	$cfg_ffmpeg = IniRead(@ScriptDir & "\" & $INIFILE, "Paths", "Ffmpeg", "")
EndFunc   ;==>loadConfig

Func saveConfig()
	IniWrite(@ScriptDir & "\" & $INIFILE, "Paths", "Output", $cfg_outPath)
	IniWrite(@ScriptDir & "\" & $INIFILE, "Paths", "Cuttermaran", $cfg_cuttermaran)
	IniWrite(@ScriptDir & "\" & $INIFILE, "Paths", "Projectx", $cfg_projectx)
	IniWrite(@ScriptDir & "\" & $INIFILE, "Paths", "Comskip", $cfg_comskip)
	IniWrite(@ScriptDir & "\" & $INIFILE, "Paths", "Ffmpeg", $cfg_ffmpeg)
EndFunc   ;==>saveConfig

Func writeToGUI()
	GUICtrlSetData($inpOutPath, $cfg_outPath)
	GUICtrlSetData($inpCuttermaran, $cfg_cuttermaran)
	GUICtrlSetData($inpProjectx, $cfg_projectx)
	GUICtrlSetData($inpComskip, $cfg_comskip)
	GUICtrlSetData($inpFfmpeg, $cfg_ffmpeg)
EndFunc   ;==>writeToGUI

Func readFromGUI()
	$cfg_outPath = GUICtrlRead($inpOutPath)
	$cfg_cuttermaran = GUICtrlRead($inpCuttermaran)
	$cfg_projectx = GUICtrlRead($inpProjectx)
	$cfg_comskip = GUICtrlRead($inpComskip)
	$cfg_ffmpeg = GUICtrlRead($inpFfmpeg)
EndFunc   ;==>readFromGUI

;----- Hauptfunktionen

Func autoCut($sourceFile, $destinationPath)
	Local $cutFile = ""
	Local $m2vFile = ""
	
	If Not checkTools() Then
		print ("----- abgebrochen")
		Return
	ElseIf Not FileExists($sourceFile) Then
		print("Fehler: Quelldatei existiert nicht")
		print ("----- abgebrochen")
		Return
	EndIf
	
	print("----- start")	
	If getExtension($sourceFile) == ".dvr-ms" Then
		print("Konvertiere ins Format .mpg...")
		$sourceFile = convertDvr2MPEG($sourceFile, $destinationPath)
	EndIf

	If Not FileExists($sourceFile) Then
		print("Fehler: Konvertierung fehlgeschlagen")
		Return
	EndIf
	
	If getExtension($sourceFile) == ".mpg" Then
		print("Demuxe...")
		$m2vFile = demux($sourceFile)
		
		print("Comskip sucht nach TV-Werbung...")
		$cutFile = comskip($sourceFile)
		
		If FileExists($cutFile) Then
			print("Starte Cuttermaran...")
			cuttermaran($cutFile)
		Else
			print("kein .cpf-File!")
		EndIf
	EndIf
	print("Lsche temporre Dateien...")
	deleteTempFiles($sourceFile, $destinationPath)
	
	print("----- fertig")
EndFunc   ;==>autoCut

Func checkTools()
	If Not FileExists($cfg_ffmpeg) Then
		print("Fehler: ffmpeg fehlt")
		Return False
	EndIf

	If Not FileExists($cfg_projectx) Then
		print("Fehler: ProjectX fehlt")
		Return False
	EndIf
	
	If RunWait(@ComSpec & ' /c java', @ScriptDir, @SW_HIDE) Then
		print("Fehler: Java-Laufzeitumgebung fehlt")
		Return False
	EndIf

	If Not FileExists($cfg_comskip) Then
		print("Fehler: comskip fehlt")
		Return False
	EndIf
	
	If Not FileExists($cfg_cuttermaran) Then
		print("Fehler: Cuttermaran fehlt")
		Return False
	EndIf
	
	Return True
EndFunc

Func convertDvr2MPEG($sourceFile, $destinationPath)
	Local $progress = 0
	Local $sourceSize = FileGetSize($sourceFile)
	Local $cmd = '"' & $cfg_ffmpeg & '" -y -i "' & $sourceFile & _
			'" -vcodec copy -acodec copy -f dvd "' & _
			$destinationPath & '\' & getFileName($sourceFile) & '.mpg"'
	Local $process = Run($cmd, $destinationPath, @SW_HIDE, $STDERR_CHILD)
	
	While 1
		Local $line = StderrRead($process)
		If @error Then ExitLoop
		$progress = (100 / $sourceSize) * regExMatch($line, "size=\s*(\d+)kB") * 1024
		; der regulre Ausdruck filtert aus der Kommandozeilen-Ausgabe den Fortschritt in KByte
		GUICtrlSetData($prgProgressBar, $progress)
	WEnd
	GUICtrlSetData($prgProgressBar, 0)

	Local $return = $destinationPath & "\" & getFileName($sourceFile) & ".mpg"
	
	If FileExists($return) Then
		Return $return
	Else
		debug("Fehler: " & $return & "existiert nach Konvertierung nicht")
		Return ""
	EndIf
EndFunc   ;==>convertDvr2MPEG

; ProjectX speichert das Ergebnis im selben Pfad
; liefert bei Erfolg den Pfad zur .m2v-Datei zurck.
Func demux($sourceFile)
	Local $progress = 0
	Local $sourceSize = FileGetSize($sourceFile)
	Local $cmd = @ComSpec & ' /c java -jar "' & $cfg_projectx & '" "' & _
			$sourceFile & '" -name "' & getFileName($sourceFile) & '.m2v" -demux'
	Local $process = Run($cmd, @ScriptDir, @SW_HIDE, $STDOUT_CHILD)
	
	While 1
		Local $line = StdoutRead($process)
		If @error Then ExitLoop
		$progress = regExMatch($line, ".(\d+)\s%")
		If $progress > 0 Then
			GUICtrlSetData($prgProgressBar, $progress)
		EndIf
	WEnd
	
	GUICtrlSetData($prgProgressBar, 0)
	
	Local $return = getPathWithoutExtension($sourceFile) & ".m2v"
	
	If FileExists($return) Then
		Return $return
	Else
		debug("Fehler: " & $return & "existiert nach demux nicht")
		Return ""
	EndIf
EndFunc   ;==>demux

; in comskip.ini darf das Debug-Window nicht eingeschaltet sein, andernfalls endet der Prozess nicht von selbst.
; in comskip.ini muss output_cuttermaran auf 1 gesetzt sein!
Func comskip($sourceFile)
	Local $progress = 0
	Local $sourceSize = FileGetSize($sourceFile)
	Local $cmd = @ComSpec & ' /c ' & $cfg_comskip & ' "' & $sourceFile & '" --ini=comskip.ini'
	Local $i
	
	Local $process = Run($cmd, @ScriptDir)
	
	While ProcessExists($process) ; Bei comskip lsst sich die Ausgabe nicht so einfach auslesen
		$i = $i + 10
		GUICtrlSetData($prgProgressBar, Mod($i, 110))
		Sleep(200)
	WEnd
	GUICtrlSetData($prgProgressBar, 0)
	
	Local $cpfFile = getPathWithoutExtension($sourceFile) & ".cpf"
	
	If FileExists($cpfFile) Then
		Return $cpfFile
	Else
		Return ""
	EndIf
EndFunc   ;==>comskip

;cpf-Datei als Eingabe
Func cuttermaran($sourceFile)
	Local $cmd = @ComSpec & ' /c ' & $cfg_cuttermaran & ' "' & $sourceFile & '"'
	Local $process = Run($cmd, "", @SW_HIDE)
	While ProcessExists($process)
		Sleep(1000)
		If WinExists("mplex output") Then
			If ControlCommand("mplex output", "", "Play", "IsEnabled") Then
				debug("mplex schlieen")
				WinClose("mplex output")
				Sleep(1000)
				WinClose("Cuttermaran")
			EndIf
		EndIf
	WEnd
EndFunc   ;==>cuttermaran

;lscht die temporren Dateien im Zielordner, die zu einer Quelldatei gehren
Func deleteTempFiles($sourceFile, $destinationPath)
	FileDelete($destinationPath & "\" & getFileName($sourceFile) & ".mpg")
	FileDelete($destinationPath & "\" & getFileName($sourceFile) & ".cpf")
	FileDelete($destinationPath & "\" & getFileName($sourceFile) & ".edl")
	FileDelete($destinationPath & "\" & getFileName($sourceFile) & ".log")
	FileDelete($destinationPath & "\" & getFileName($sourceFile) & ".m2v")
	FileDelete($destinationPath & "\" & getFileName($sourceFile) & ".m2v.info")
	FileDelete($destinationPath & "\" & getFileName($sourceFile) & ".m2v_log.txt")
	FileDelete($destinationPath & "\" & getFileName($sourceFile) & ".mp2")
	FileDelete($destinationPath & "\" & getFileName($sourceFile) & ".txt")
	FileDelete($destinationPath & "\" & getFileName($sourceFile) & ".logo.txt")
EndFunc   ;==>deleteTempFiles

; Hilfsfunktionen -------------------------------------------------------------

Func getFileName($path)
	Local $array[4]
	$array = pathSplit($path)
	Return $array[3]
EndFunc   ;==>getFileName

Func getExtension($path)
	Local $array[4]
	$array = pathSplit($path)
	Return $array[4]
EndFunc   ;==>getExtension

Func getPathWithoutExtension($path)
	Local $array[4]
	$array = pathSplit($path)
	Return $array[1] & $array[2] & $array[3]
EndFunc   ;==>getPathWithoutExtension

; Nutzt die Bibliotheksfunktion _PathSplit, liefert nur das Array mit den Ergebnissen zurck
Func pathSplit($path)
	Local $drive, $dir, $fname, $ext
	Return _PathSplit($path, $drive, $dir, $fname, $ext)
EndFunc   ;==>pathSplit

;Liefert den Ergebnis-String, auf den der regulre Ausdruck matcht.
Func regExMatch($string, $regex)
	Local $array[1]
	$array = StringRegExp($string, $regex, 1)
	If @error = 0 Then
		Return $array[0]
	Else
		Return 0
	EndIf
EndFunc   ;==>regExMatch

;Quelle: http://snippets.dzone.com/posts/show/4680
;Meldung an DebugView kann man mit dem Sysinternals-Werkzeug DebugView einsehen
Func debug($msg, $error = @error, $extended = @extended, $ScriptLineNumber = @ScriptLineNumber)
	Local $out = "-debug- " & $msg & ", Zeile:" & $ScriptLineNumber & ", Fehler: " & $error & " " & $extended
	;Output to application attaching a console to the script engine
	ConsoleWrite($out & @CRLF)
	;Output to debugger (dbgview.exe)
	DllCall("kernel32.dll", "none", "OutputDebugString", "str", $out)
EndFunc   ;==>debug

Func print($text)
	GUICtrlSetData($edtOutput, GUICtrlRead($edtOutput) & $text & @CRLF)
EndFunc   ;==>print