#!/bin/sh
# fix_wanem.sh
# (c) 2008 Johannes Endres und c't

# Zuerst Links auf die rc-Skripte setzen, damit sie beim Booten laufen
# Netz-Interfaces automatisch konfigurieren
ln -s /etc/init.d/ifupdown-clean /etc/rcS.d/S18ifupdown-clean
ln -s /etc/init.d/ifupdown /etc/rcS.d/S39ifupdown
ln -s /etc/init.d/mountkernfs.sh /etc/rcS.d/S02mountkernfs.sh
ln -s /etc/init.d/hostname.sh /etc/rcS.d/S02hostname.sh

# Wichtig: Parameter aus /etc/sysctl setzen
ln -s /etc/init.d/procps.sh /etc/rcS.d/S30procps.sh

# Netzwerk automatisch einrichten
TARGET=/etc/init.d/networking
ln -s $TARGET /etc/rc0.d/S35networking
ln -s $TARGET /etc/rc6.d/S35networking
ln -s $TARGET /etc/rcS.d/S40networking

# SSH fr den Kommandozeilenzugang automatisch starten
TARGET=/etc/init.d/ssh
ln -s $TARGET /etc/rc0.d/K20ssh
ln -s $TARGET /etc/rc1.d/K20ssh
ln -s $TARGET /etc/rc2.d/S20ssh
ln -s $TARGET /etc/rc3.d/S20ssh
ln -s $TARGET /etc/rc4.d/S20ssh
ln -s $TARGET /etc/rc5.d/S20ssh
ln -s $TARGET /etc/rc6.d/K20ssh

# Web-Interface automatisch starten
TARGET=/etc/init.d/apache2
ln -s $TARGET /etc/rc0.d/K09apache2
ln -s $TARGET /etc/rc1.d/K09apache2
ln -s $TARGET /etc/rc2.d/S91apache2
ln -s $TARGET /etc/rc3.d/S91apache2
ln -s $TARGET /etc/rc4.d/S91apache2
ln -s $TARGET /etc/rc5.d/S91apache2
ln -s $TARGET /etc/rc6.d/K09apache2

# Kernel-Parameter anpassen, wie WANem sie braucht
# Das funktioniert nur, wenn procps.sh wie oben velinkt automtisch luft
echo net.ipv4.conf.eth2.send_redirects = 0 >>/etc/sysctl.conf
echo net.ipv4.conf.eth1.send_redirects = 0 >>/etc/sysctl.conf
echo net.ipv4.conf.eth0.send_redirects = 0 >>/etc/sysctl.conf
echo net.ipv4.conf.lo.send_redirects = 0 >>/etc/sysctl.conf
echo net.ipv4.conf.default.send_redirects = 0 >>/etc/sysctl.conf
echo net.ipv4.conf.all.send_redirects = 0 >>/etc/sysctl.conf
echo net.ipv4.ip_no_pmtu_disc = 1 >>/etc/sysctl.conf
echo net.ipv4.ip_forward = 1 >>/etc/sysctl.conf

# User anlegen und Passwrter setzen
useradd -s /bin/bash perc
echo "Passwort fr den User perc"
passwd perc

echo "Passwort fr den Superuser root"
passwd root
