// *****************************************************************
// Filename:  FaceRecognitionOrganizer.h
// Copyright: Pedram Azad, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:	  Pedram Azad
// Date:      02.05.2008
// *****************************************************************

#ifndef _FACE_RECOGNITION_ORGANIZER_H_
#define _FACE_RECOGNITION_ORGANIZER_H_


// *****************************************************************
// necessary includes
// *****************************************************************

#include "Image/ByteImage.h"
#include "Threading/Thread.h"
#include <qobject.h>
#include <string>


// *****************************************************************
// Forward class declarations
// *****************************************************************

class QLCDNumber;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QPushButton;
class QSlider;
class QLabel;
class CViewDatabase;
class CApplicationHandlerInterface;
class CQTWindow;
class CVideoCaptureInterface;




// *****************************************************************
// CFaceRecognitionOrganizer
// *****************************************************************

class CFaceRecognitionOrganizer : public QObject, public CThread
{
	Q_OBJECT
	
public:
	// constructor
	CFaceRecognitionOrganizer();
	
	// destructor
	~CFaceRecognitionOrganizer();
	
	
	// public methods
	bool Run(int argc, char **args);


private slots:
	void SetPassword();
	void ShowPerson();
	void RecordButtonClicked();
	void Delete();

	void ShowVideoSourceDialog();
	void ShowVideoFormatDialog();
	void OpenCamera();


private:
	// private methods
	void SetSize(int width, int height, CByteImage::ImageType type);
	int ThreadMethod();
	
	// actions (initiated by buttons)
	void ShowViews(CViewDatabase *pDatabase, int nCurrentItem);

	
	// private attributes
	CQTWindow *m_pWindow;
	
	QLCDNumber *m_pLCDRecognitionThreshold;
	QLineEdit *m_pLineEditName;
	QComboBox *m_pComboBoxPersons;
	QCheckBox *m_pCheckBoxShowSegmentedImage;
	QCheckBox *m_pCheckBoxUseColorSegmentation;
	QPushButton *m_pRecordButton;
	QPushButton *m_pShowPersonButton;
	QPushButton *m_pDeleteButton;
	QPushButton *m_pOpenPasswordDialogButton;
	QSlider *m_pSliderColorH;
	QSlider *m_pSliderColorHT;
	QSlider *m_pSliderColorMinS;
	QSlider *m_pSliderColorMaxS;
	QSlider *m_pSliderColorMinV;
	QSlider *m_pSliderColorMaxV;
	QSlider *m_pSliderRecognitionThreshold;
	QLabel *m_pLabelHTol;
	QLabel *m_pLabelMinS;
	QLabel *m_pLabelMaxS;
	QLabel *m_pLabelMinV;
	QLabel *m_pLabelMaxV;
	QLabel *m_pLabelRecognitionThreshold;
	QLabel *m_pLabelName;
	QLabel *m_pLabelH;

	#ifdef WIN32
	// specific for Video for Windows
	QPushButton *m_pShowVideoSourceDialogButton;
	QPushButton *m_pShowVideoFormatDialogButton;
	QPushButton *m_pOpenCameraButton;
	QComboBox *m_pComboBoxVideoDrivers;
	#endif

	CByteImage *m_pImage;
	CByteImage *m_pHSVImage;
	CByteImage *m_pSegmentedImage;
	CByteImage *m_pGrayscaleImage;
	
	CViewDatabase *m_pPersonDatabase;
	CVideoCaptureInterface *m_pVideoCapture;

	bool m_bRecording;
	int m_nIndex;
	int m_nRecognizedCounter;
	std::string m_sName;
	std::string m_sPassword;
};



#endif /* _FACE_RECOGNITION_ORGANIZER_H_ */
