﻿Imports de.amazon.webservices
Imports System.Linq

Partial Class controls_singledvd
    Inherits System.Web.UI.UserControl

    Private _dvd As dvd, _dataContext As DataClassesDataContext

    Public Property dvd() As dvd
        Get
            Return _dvd
        End Get
        Set(ByVal value As dvd)
            _dvd = value
        End Set
    End Property

    Public Property dataContext() As DataClassesDataContext
        Get
            Return _dataContext
        End Get
        Set(ByVal value As DataClassesDataContext)
            _dataContext = value
        End Set
    End Property

    Public Shared Function AmznQuery(ByVal id As String, _
                                       ByVal idtype As ItemLookupRequestIdType) _
                                       As ItemLookupResponse
        Dim aws As AWSECommerceService = New AWSECommerceService
        aws.Url = "http://soap.amazon.de/onca/soap?Service=AWSECommerceService"

        Dim amznProduct As New ItemLookup
        Dim amznProductQuery As New ItemLookupRequest

        With amznProductQuery
            .IdType = idtype
            .ResponseGroup = New String() {"Small", "ItemAttributes", "Tracks", _
                                           "Images", "BrowseNodes", "OfferSummary", _
                                           "EditorialReview", "Reviews"}
            .ItemId = New String() {id.Trim}
        End With

        amznProduct.Request = New ItemLookupRequest() {amznProductQuery}

        '--------------------- Ihre AWS-Key-Id ---------------------
        amznProduct.AWSAccessKeyId = "IhreAWSKeyId"

        '-------------------- Bitte löschen (Anfang) --------------------
        If amznProduct.AWSAccessKeyId = "IhreAWSKeyId" Or _
            amznProduct.AWSAccessKeyId = vbNullString Then
            Throw New Exception("Bitte gegen Sie Ihre AWS-Key-Id ein und löschen Sie anschließend diesen Abschnitt")
        End If
        '-------------------- Bitte löschen (Ende) --------------------

        Return aws.ItemLookup(amznProduct)
    End Function

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        title.InnerText = dvd.title.Trim

        Dim amznDvd As ItemLookupResponse = AmznQuery(dvd.asin, ItemLookupRequestIdType.ASIN)
        If amznDvd IsNot Nothing Then
            If amznDvd.Items(0).Item IsNot Nothing Then
                With amznDvd.Items(0).Item(0)
                    Dim pic As New HtmlControls.HtmlImage
                    infos.Text = String.Format("({0}, {1})", dvd.year, _
                    .ItemAttributes.Publisher)

                    If .SmallImage IsNot Nothing Then
                        pic.Src = .SmallImage.URL
                        title.Controls.Add(pic)
                    End If
                End With
            End If
        End If
    End Sub
End Class
