﻿Imports System.Data.OleDb
Imports Microsoft.Office.Interop.Access

Public Class frmQueryAnalyzer

    Private Sub cmdNeu_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdNeu.Click
        Me.txtSQL.Text = ""
        Me.txtMeldung.Text = ""
        Me.ctlDataGridView.DataSource = Nothing
    End Sub

    Private Sub cmdSpeichern_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSpeichern.Click
        Dim strSQL As String
        Dim strQuery As String
        Dim cnn As ADODB.Connection

        cnn = objAccess.CurrentProject.Connection
        strSQL = Me.txtSQL.Text
        strQuery = InputBox("Bitte geben Sie einen Abfragenamen ein.")
        Try
            If Len(strQuery) > 0 Then
                Dim cmd As New ADODB.Command
                Dim cat As New ADOX.Catalog
                cat.ActiveConnection = objAccess.CurrentProject.Connection
                If IstAuswahlabfrage(strSQL) Then
                    cmd.CommandText = strSQL
                    cat.Views.Append(strQuery, cmd)
                Else
                    cmd.CommandText = strSQL
                    cat.Procedures.Append(strQuery, cmd)
                End If
                objAccess.RefreshDatabaseWindow()
                Me.txtMeldung.ForeColor = Drawing.Color.Blue
                Me.txtMeldung.Text = "Die Abfrage wurde erfolgreich angelegt."
            End If
        Catch ex As Exception
            Me.txtMeldung.ForeColor = Drawing.Color.Red
            Me.txtMeldung.Text = ex.ToString
        End Try
    End Sub

    Private Function IstAuswahlabfrage(ByVal strSQL As String) As Boolean
        IstAuswahlabfrage = (StrComp(strSQL.Substring(0, 6), "SELECT", vbTextCompare) = 0 And InStr(1, strSQL, " INTO ", vbTextCompare) = 0)
    End Function

    Private Sub cmdTesten_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdTesten.Click
        ExecuteSQL(True)
    End Sub

    Private Sub ExecuteSQL(ByVal bolTesten As Boolean)
        Dim strSQL As String
        Dim strStart As String
        Dim strMeldungTest As String = ""
        Dim strMeldungAusfuehren As String = ""
        Dim strSQLAction As String = ""
        Try
            strSQL = FullTrim(txtSQL.Text)
            Dim strConnection As String = objAccess.CurrentProject.Connection.ConnectionString
            'Auswahlabfrage ...
            If IstAuswahlabfrage(strSQL) Then
                '                strConnection = "Provider=Microsoft.ACE.OLEDB.12.0;Data Source=" & objAccess.CurrentProject.Path & "\" & objAccess.CurrentProject.Name & ";User Id=admin;Password=;"
                Dim conn As OleDbConnection = New OleDbConnection(strConnection)
                Dim comm As OleDbCommand = New OleDbCommand(strSQL, conn)
                Dim dataadapter As OleDbDataAdapter = New OleDbDataAdapter(comm)
                Dim ds As DataSet = New DataSet()
                conn.Open()
                dataadapter.Fill(ds, "Query")
                conn.Close()
                Me.txtMeldung.Text = "Ergebnis:"
                Me.ctlDataGridView.DataSource = ds
                Me.ctlDataGridView.DataMember = "Query"
                '... oder Aktionsabfrage?
            Else
                'Nur die betroffenen Datensätze anzeigen ...
                If bolTesten Then
                    strStart = UCase(strSQL.Substring(0, InStr(1, strSQL, " ") - 1))
                    Select Case strStart
                        Case "INSERT"
                            strMeldungAusfuehren = "Eingefügte Datensätze:"
                            strMeldungTest = "Einzufügende Datensätze:"
                            strSQLAction = SelectFromInsert(strSQL)
                        Case "UPDATE"
                            strMeldungAusfuehren = "Aktualisierte Datensätze:"
                            strMeldungTest = "Zu aktualisierende Datensätze:"
                            strSQLAction = SelectFromUpdate(strSQL)
                        Case "DELETE"
                            strMeldungAusfuehren = "Zu löschende Datensätze:"
                            strMeldungTest = "Gelöschte Datensätze:"
                            strSQLAction = SelectFromDelete(strSQL)
                        Case "SELECT"
                            strMeldungAusfuehren = "Datensätze der neuen Tabelle:"
                            strMeldungTest = "Hinzuzufügende Datensätze:"
                            strSQLAction = SelectFromSelectInto(strSQL)
                    End Select
                    Me.txtMeldung.ForeColor = Drawing.Color.Blue
                    Me.txtMeldung.Text = strMeldungTest
                    '                    strConnection = "Provider=Microsoft.ACE.OLEDB.12.0;Data Source=" & objAccess.CurrentProject.Path & "\" & objAccess.CurrentProject.Name & ";User Id=admin;Password=;"
                    Dim conn As OleDbConnection = New OleDbConnection(strConnection)
                    Dim comm As OleDbCommand = New OleDbCommand(strSQLAction, conn)
                    Dim dataadapter As OleDbDataAdapter = New OleDbDataAdapter(comm)
                    Dim ds As DataSet = New DataSet()
                    conn.Open()
                    dataadapter.Fill(ds, "Query")
                    conn.Close()
                    Me.txtMeldung.Text = "Ergebnis:"
                    Me.ctlDataGridView.DataSource = ds
                    Me.ctlDataGridView.DataMember = "Query"
                    '... oder Aktionsabfrage direkt ausführen?
                Else
                    Dim com As OleDbCommand
                    Dim conn As OleDbConnection = New OleDbConnection(strConnection)
                    conn.Open()
                    com = New OleDbCommand(strSQL, conn)
                    com.ExecuteNonQuery()
                    conn.Close()
                    Me.txtMeldung.ForeColor = Drawing.Color.Blue
                    Me.txtMeldung.Text = strMeldungAusfuehren
                End If
            End If
        Catch e As Exception
            MsgBox(e.Message)
        End Try
    End Sub

    Private Sub cmdAusfuehren_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdAusfuehren.Click
        ExecuteSQL(False)
    End Sub

    Private Function SelectFromUpdate(ByVal strSQL As String) As String
        Dim strSQLAction As String
        Dim intPosStart As Integer
        Dim intPosEnde As Integer
        Dim strWhere As String
        Dim strTabellenname As String

        strSQLAction = strSQL
        intPosStart = InStr(1, strSQLAction, "UPDATE ")
        intPosEnde = InStr(intPosStart, strSQLAction, "SET")
        strTabellenname = Mid(strSQLAction, intPosStart + 7, intPosEnde - intPosStart - 7)
        intPosStart = InStr(1, strSQLAction, "WHERE ")
        If intPosStart > 0 Then
            strWhere = Mid(strSQLAction, intPosStart)
        Else
            strWhere = ""
        End If
        strSQLAction = "SELECT * FROM " & strTabellenname & " " & strWhere
        SelectFromUpdate = strSQLAction

    End Function

    Private Function SelectFromDelete(ByVal strSQL As String) As String
        Dim strSQLAction As String
        strSQLAction = strSQL
        strSQLAction = Replace(strSQLAction, "*", "")
        strSQLAction = Replace(strSQLAction, "DELETE ", "SELECT * ", , , CompareMethod.Text)
        SelectFromDelete = strSQLAction
    End Function

    Private Function SelectFromInsert(ByVal strSQL As String) As String
        Dim strSQLAction As String
        Dim intPosStart As Integer
        Dim intPosEnde As Integer
        Dim strTabellenname As String
        Dim strFelder As String
        Dim arrFelder() As String
        Dim strWerte As String
        Dim arrWerte() As String
        Dim i As Integer
        strSQLAction = strSQL
        If InStr(1, strSQLAction, " SELECT ") > 0 Then
            strSQLAction = Mid(strSQLAction, InStr(1, strSQLAction, "SELECT ", vbTextCompare))
        Else
            intPosStart = InStr(1, strSQLAction, "INSERT INTO ", CompareMethod.Text)
            intPosEnde = InStr(intPosStart, strSQLAction, "(", CompareMethod.Text)
            strTabellenname = Mid(strSQLAction, intPosStart + 12, intPosEnde - intPosStart - 12)
            intPosStart = InStr(1, strSQLAction, "(", CompareMethod.Text)
            intPosEnde = InStr(intPosStart, strSQLAction, ")", CompareMethod.Text)
            strFelder = Mid(strSQLAction, intPosStart + 1, intPosEnde - intPosStart - 1)
            arrFelder = Split(strFelder, ",")
            intPosStart = InStr(intPosEnde, strSQLAction, "(", CompareMethod.Text)
            intPosEnde = InStr(intPosStart, strSQLAction, ")", CompareMethod.Text)
            strWerte = Mid(strSQLAction, intPosStart + 1, intPosEnde - intPosStart - 1)
            arrWerte = Split(strWerte, ",")
            strSQLAction = "SELECT DISTINCT "
            For i = LBound(arrFelder) To UBound(arrFelder)
                strSQLAction = strSQLAction & arrWerte(i) & " AS " & arrFelder(i) & ", "
            Next i
            strSQLAction = strSQLAction.Substring(0, Len(strSQLAction) - 2)
            strSQLAction = strSQLAction & " FROM " & strTabellenname & " UNION SELECT " & strFelder & " FROM " & strTabellenname & " WHERE 1=2"
        End If
        SelectFromInsert = strSQLAction
    End Function

    Private Function SelectFromSelectInto(ByVal strSQL As String) As String
        Dim strSQLAction As String
        Dim intPosStart As Integer
        Dim intPosEnde As Integer
        strSQLAction = strSQL
        intPosStart = InStr(1, strSQLAction, "INTO")
        intPosEnde = InStr(intPosStart, strSQLAction, "FROM")
        strSQLAction = strSQLAction.Substring(1, intPosStart - 1) & " " & Mid(strSQLAction, intPosEnde)
        SelectFromSelectInto = strSQLAction
    End Function

    Private Sub frmQueryAnalyzer_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim tbl As New DataTable
        '        Dim strMDW As String = objAccess.SysCmd(AcSysCmdAction.acSysCmdGetWorkgroupFile)
        Dim strConnection As String = objAccess.CurrentProject.Connection.ConnectionString
        Dim cnn As New OleDbConnection(strConnection)
        Dim adapter As New OleDbDataAdapter("SELECT Type, Name FROM MSysObjects WHERE (Type = 1 OR Type = 5) AND NOT Name LIKE '~sq%' AND NOT Name LIKE 'MSys%'", cnn)
        adapter.Fill(tbl)
        cboObjekte.DisplayMember = "Name"
        cboObjekte.ValueMember = "Type"
        cboObjekte.DataSource = tbl
    End Sub

    Private Sub cboObjekte_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboObjekte.SelectedIndexChanged
        Dim strAbfragename As String
        Dim strTabellenname As String
        Dim strSQL As String
        Dim tdf As dao.TableDef
        Select Case cboObjekte.SelectedValue
            Case 1
                strTabellenname = cboObjekte.Text.ToString
                If Len(strTabellenname) > 0 Then
                    db = objAccess.CurrentDb
                    tdf = db.TableDefs(strTabellenname)
                    strSQL = "SELECT "
                    For Each fld In tdf.Fields
                        strSQL = strSQL & fld.Name & ", "
                    Next fld
                    strSQL = strSQL.Substring(0, Len(strSQL) - 2)
                    strSQL = strSQL & " FROM " & strTabellenname
                    Me.txtSQL.Text = strSQL
                End If
            Case 5
                strAbfragename = cboObjekte.Text
                If Len(strAbfragename) > 0 Then
                    strSQL = objAccess.Application.CurrentDb.QueryDefs(strAbfragename).SQL
                    strSQL = Replace(strSQL, vbCrLf, " ")
                    strSQL = Replace(strSQL, vbCr, " ")
                    strSQL = Replace(strSQL, vbLf, " ")
                    Me.txtSQL.Text = Trim(strSQL)
                End If
        End Select
    End Sub
End Class