
#include <string> 
#include <map> 
#include <fstream>
#include <iostream>
#include <sstream>
#include <boost/regex.hpp> 

// purpose: 
// takes the contents of a file in the form of a string 
// and searches for all the C++ class definitions, storing 
// their locations in a map of strings/int's 
typedef std::map<std::string, int, std::less<std::string> > map_type; 

boost::regex expression(
   "^(template[[:space:]]*<[^;:{]+>[[:space:]]*)?"
   "(class|struct)[[:space:]]*"
   "(\\<\\w+\\>([[:blank:]]*\\([^)]*\\))?"
   "[[:space:]]*)*(\\<\\w*\\>)[[:space:]]*"
   "(<[^;:{]+>[[:space:]]*)?(\\{|:[^;\\{()]*\\{)"); 

void IndexClasses(map_type& m, const std::string& file) 
{ 
   std::string::const_iterator start, end; 
   start = file.begin(); 
   end = file.end(); 
      boost::match_results<std::string::const_iterator> what; 
   boost::match_flag_type flags = boost::match_default; 
   while (boost::regex_search(start, end, what, expression, flags)) 
   { 
      // what[0] contains the whole string 
      // what[5] contains the class name. 
      // what[6] contains the template specialisation if any. 
      // add class name and position to map: 
      m[std::string(what[5].first, what[5].second) 
            + std::string(what[6].first, what[6].second)] 
         = what[5].first - file.begin(); 
      // update search position: 
      start = what[0].second; 
      // update flags: 
      flags |= boost::match_prev_avail; 
      flags |= boost::match_not_bob; 
   } 
}


int main(int argc, char* argv[])
{
    if (argc < 2)
        return 1;
	const char* filename = argv[1];
    std::stringstream buf;
    map_type m;
    std::ifstream f(filename);
    if (f.is_open()) {
        while (!f.eof()) {
            std::string line;
            getline(f, line);
            buf << line << std::endl;
        }
    }
    std::cout << buf.str();
    std::string str = buf.str();
    IndexClasses(m, str);
    return 0;
}