// $Id$
// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag. Alle Rechte vorbehalten.

#include <iostream>
#include <fstream>
#include <vector>

#include <boost/regex.hpp>
#include <boost/tuple/tuple.hpp>

using namespace std;

typedef boost::tuple<string, string> argument;
typedef vector<argument> argumentlist;

void parse(const char* fname, argumentlist& args)
{
	ifstream file(fname);
	const char* re_assignment = "^(\\w+)\\s*=\\s*(\\w*)";
	if (file.is_open())
	{
		string line;
		boost::regex re(re_assignment);
		boost::cmatch match;
		while (!file.eof())
		{
			getline(file, line);
			cout << endl << ">>> " << line << endl;
			if (regex_match(line.c_str(), match, re))
			{
				if (match.size() == 3)
				{
					cout << " Schlssel: " << match[1] << endl
						<< " Wert     : " << match[2] << endl;
					args.push_back(make_tuple(match[1], match[2]));
				}
			}
		}
		file.close();
	}
}


int main(int argc, char* argv[])
{
	const char* filename = argv[1];
	argumentlist args;
	parse(filename, args);
	for (argumentlist::const_iterator i = args.begin(); i != args.end(); ++i)
	{
		string key;
		string val;
        boost::tuples::tie(key, val) = (*i);
		cout << key << " = " << val << endl;
	}
	return 0;
}
