// $Id$
// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag. Alle Rechte vorbehalten.

#include <iostream>
#include <fstream>
#include <regex>
#include <tuple>
#include <vector>

typedef std::tr1::tuple<std::string, std::string> argument;
typedef std::vector<argument> argumentlist;


void parse(const char* fname, argumentlist& args)
{
    std::ifstream file(fname);
	const char* re_assignment = "^(\\w+)\\s*=\\s*(\\w*)";
	if (file.is_open())
	{
        std::tr1::regex re(re_assignment);
        std::tr1::regex rx("wert");
		std::tr1::smatch match;
        std::string replacement = "<$&>";
		while (!file.eof())
		{
    		std::string line;
			getline(file, line);
            std::cout << std::endl << ">>> " << line << std::endl;
            std::cout << std::tr1::regex_replace(line, rx, replacement) << std::endl;
			if (std::tr1::regex_match(line, match, re))
			{
				if (match.size() == 3)
				{
					std::cout << " Schlssel: '" << match[1] << "'" << std::endl
						<< " Wert     : '" << match[2] << "'" << std::endl;
					args.push_back(make_tuple(match[1], match[2]));
				}
			}
		}
		file.close();
	}
}


int main(int argc, char* argv[])
{
    if (argc < 2)
        return 1;
	const char* filename = argv[1];
	argumentlist args;
	parse(filename, args);
	for (argumentlist::const_iterator i = args.begin(); i != args.end(); ++i)
	{
        std::string key = std::tr1::get<0>(*i);
		std::string val = std::tr1::get<1>(*i);
		// std::tr1::tie(key, val) = (*i);
        std::cout << key << " = " << val << std::endl;
	}
	return 0;
}
