// $Id$
// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag. Alle Rechte vorbehalten.

#define BENCHMARK

#ifdef BENCHMARK
#include <Windows.h>
#endif

#include <string>
#include <fstream>
#include <iostream>
#include <cstdio>

#include <random>

using namespace std;
using namespace std::tr1;

const int SZ = 100000;

#ifdef BENCHMARK
LARGE_INTEGER freq;
LARGE_INTEGER t0;
#endif

void start(string msg)
{
#ifdef BENCHMARK
	cout << "  " << msg;
	QueryPerformanceCounter(&t0);
#endif
}


void stop(LONGLONG& ms)
{
#ifdef BENCHMARK
	LARGE_INTEGER t;
	QueryPerformanceCounter(&t);
	LONGLONG duration = 1000LL * (t.QuadPart - t0.QuadPart) / freq.QuadPart;
	ms += duration;
	cout << duration << " ms " << endl;
#endif
}


template <typename T>
void save(const char* filename, T* data)
{
	ifstream ifs;
	ifs.open(filename);
	if (ifs.is_open())
	{
		cout << endl << "  Lschen von " << filename << " ..." << endl;
		ifs.close();
		_unlink(filename);
	}
	cout << endl << "Schreiben der Zufallszahlen nach " << filename << " ...";
	ofstream fs(filename);
	if (fs.good())
	{
		for (int i = 0; i < SZ; ++i)
			fs << data[i] << endl;
	}
	fs.close();
    cout << endl;
}



int main(int argc, char* argv[])
{
#ifdef BENCHMARK
	QueryPerformanceFrequency(&freq);
#endif

	const int TRIES = 5;
	
	LONGLONG t_gen1 = 0;
	LONGLONG t_gen2 = 0;
	LONGLONG t_gen3 = 0;

    double* arr1 = new double[SZ];
    unsigned long* arr2 = new unsigned long[SZ];
    unsigned long* arr3 = new unsigned long[SZ];

    for (int j = 0; j < TRIES; ++j)
	{
		cout << "Durchlauf " << j+1 << endl;

        ranlux3_01 gen1;
        normal_distribution<double> dist1(0, 100);
	    variate_generator<ranlux3_01&, normal_distribution<double> > rng1(gen1, dist1);
		start("ranlux3_01 ... ");
		for (unsigned long i = 0; i < SZ; ++i)
			arr1[i] = gen1();
		stop(t_gen1);

        minstd_rand gen2;
        uniform_int<unsigned long> dist2(0, 100);
	    variate_generator<minstd_rand&, uniform_int<unsigned long> > rng2(gen2, dist2);
    	start("minstd_rand ... ");
		for (unsigned long i = 0; i < SZ; ++i)
			arr2[i] = gen2();
		stop(t_gen2);

        mt19937 gen3;
        uniform_int<unsigned long> dist3(0, 100);
	    variate_generator<mt19937&, uniform_int<unsigned long> > rng3(gen3, dist3);
		start("mt19937 ... ");
		for (unsigned long i = 0; i < SZ; ++i)
			arr3[i] = gen3();
		stop(t_gen3);

		cout << endl << endl;
	}

	cout << "Mittelwerte:" << endl;
	cout << "  ranlux3_01  = " << t_gen1 / TRIES << " ms" << endl;
	cout << "  minstd_rand = " << t_gen2 / TRIES << " ms" << endl;
	cout << "  mt19937     = " << t_gen3 / TRIES << " ms" << endl;

    save("ranlux3_01.txt", arr1);
    save("minstd_rand.txt", arr2);
    save("mt19937.txt", arr3);

    delete [] arr3;
    delete [] arr2;
    delete [] arr1;

	cout << endl;
}
