// $Id$
// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag. Alle Rechte vorbehalten.

#define BENCHMARK

#ifdef BENCHMARK
#include <Windows.h>
#endif

#include <ctime>
#include <string>
#include <iostream>
#include <cstdio>
#include <vector>

#include <boost/random.hpp>
#include <boost/array.hpp>

using namespace std;

const int SZ = 10000000;

#ifdef BENCHMARK
LARGE_INTEGER freq;
LARGE_INTEGER t0;
#endif

void start(string msg)
{
#ifdef BENCHMARK
	cout << "  " << msg;
	QueryPerformanceCounter(&t0);
#endif
}


void stop(LONGLONG& ms)
{
#ifdef BENCHMARK
	LARGE_INTEGER t;
	QueryPerformanceCounter(&t);
	LONGLONG duration = 1000LL * (t.QuadPart - t0.QuadPart) / freq.QuadPart;
	ms += duration;
	cout << duration << " ms " << endl;
#endif
}

typedef double ResultType;
volatile ResultType x;

inline ResultType gen(void)
{
    x++;
    return x;
}


int main(int argc, char* argv[])
{
#ifdef BENCHMARK
	QueryPerformanceFrequency(&freq);
#endif

    x = 0;

	const int TRIES = 5;
	
	LONGLONG t_arr_w = 0;
	LONGLONG t_arr_w2 = 0;
	LONGLONG t_arr_r = 0;
	LONGLONG t_arr_r2 = 0;
	LONGLONG t_a_w_i = 0;
	LONGLONG t_a_w_x = 0;
	LONGLONG t_a_r_i = 0;
	LONGLONG t_a_r_x = 0;
	LONGLONG t_v_w_i = 0;
	LONGLONG t_v_wu_i = 0;
	LONGLONG t_v_w_x = 0;
	LONGLONG t_v_r_i = 0;
	LONGLONG t_v_r_x = 0;

	for (int j = 0; j < TRIES; ++j)
	{
		cout << "Durchlauf " << j+1 << endl;
		ResultType* arr = new ResultType[SZ];
        boost::array<ResultType, SZ>* a = new boost::array<ResultType, SZ>;
        std::vector<ResultType>* v = new std::vector<ResultType>;

		start("[] schreiben ... ");
		for (unsigned long i = 0; i < SZ; ++i)
			arr[i] = gen();
		stop(t_arr_w);

		start("[] schreiben ... ");
		ResultType* arr2 = arr;
		for (unsigned long i = 0; i < SZ; ++i)
			*(arr2++) = gen();
		stop(t_arr_w2);

		start("[] lesen ... ");
		arr2 = arr;
		for (unsigned long i = 0; i < SZ; ++i)
			volatile ResultType blah = *(arr2++);
		stop(t_arr_r2);

		start("[] lesen ... ");
		for (unsigned long i = 0; i < SZ; ++i)
			volatile ResultType blah = arr[i];
		stop(t_arr_r);

		start("array schreiben (Iterator) ... ");
        for (boost::array<ResultType, SZ>::iterator i = a->begin(); i != a->end(); ++i)
			*i = gen();
		stop(t_a_w_i);

		start("array schreiben [] ... ");
		for (unsigned long i = 0; i < SZ; ++i)
			(*a)[i] = gen();
		stop(t_a_w_x);

		start("array lesen (Iterator) ... ");
		for (boost::array<ResultType, SZ>::iterator i = a->begin(); i != a->end(); ++i)
			volatile ResultType blah = (*i);
		stop(t_a_r_i);

		start("array lesen [] ... ");
		for (unsigned long i = 0; i < SZ; ++i)
			volatile ResultType blah = (*a)[i];
		stop(t_a_r_x);

		start("vector (nicht initialisiert) schreiben ... ");
		for (unsigned long i = 0; i < SZ; ++i)
			v->push_back(gen());
		stop(t_v_wu_i);

		start("vector schreiben (Iterator) ... ");
		for (vector<ResultType>::iterator i = v->begin(); i != v->end(); ++i)
			*i = gen();
		stop(t_v_w_i);

		start("vector schreiben [] ... ");
		for (unsigned long i = 0; i < SZ; ++i)
			(*v)[i] = gen();
		stop(t_v_w_x);

		start("vector lesen (Iterator) ... ");
		for (vector<ResultType>::iterator i = v->begin(); i != v->end(); ++i)
			volatile ResultType blah = (*i);
		stop(t_v_r_i);

		start("vector lesen [] ... ");
		for (unsigned long i = 0; i < SZ; ++i)
			volatile ResultType blah = (*v)[i];
		stop(t_v_r_x);

		delete a;
		delete v;
		delete [] arr;

		cout << endl << endl;
	}

	cout << "Mittelwerte:" << endl;
	cout << "  Array schreiben, a[i]              = " << t_arr_w  / TRIES << " ms" << endl;
	cout << "  Array schreiben, *(a++)            = " << t_arr_w2 / TRIES << " ms" << endl;
	cout << "  Array lesen, a[i]                  = " << t_arr_r  / TRIES << " ms" << endl;
	cout << "  Array lesen, *(a++)                = " << t_arr_r2  / TRIES << " ms" << endl;
	cout << "  boost::array schreiben (Iterator)  = " << t_a_w_i  / TRIES << " ms" << endl;
	cout << "  boost::array schreiben []          = " << t_a_w_x  / TRIES << " ms" << endl;
	cout << "  boost::array lesen (Iterator)      = " << t_a_r_i  / TRIES << " ms" << endl;
	cout << "  boost::array lesen []              = " << t_a_r_x  / TRIES << " ms" << endl;
	cout << "  std::vector (!init) schreiben      = " << t_v_wu_i / TRIES << " ms" << endl;
	cout << "  std::vector schreiben (Iterator)   = " << t_v_w_i  / TRIES << " ms" << endl;
	cout << "  std::vector schreiben []           = " << t_v_w_x  / TRIES << " ms" << endl;
	cout << "  std::vector lesen (Iterator)       = " << t_v_r_i  / TRIES << " ms" << endl;
	cout << "  std::vector lesen []               = " << t_v_r_x  / TRIES << " ms" << endl;
	cout << endl;
}
