// $Id$
// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag. Alle Rechte vorbehalten.

#include <iostream>
#include <set>
#include <vector>
#include <algorithm>

#include <boost/array.hpp>
#include <boost/shared_ptr.hpp>

#include "basicuse.h"

using namespace std;


struct Foo {
	int x;
	Foo(int _x) : x(_x) { }
	~Foo() { cout << "Zerstren eines Foo mit x = " << x << endl; }
};

typedef boost::shared_ptr<Foo> FooPtr;

struct SetOps {
	bool operator()(const FooPtr& a, const FooPtr& b)
	{ return a->x < b->x; }
};

typedef vector<FooPtr> MyVector;
typedef set<FooPtr, SetOps> MySet;


void basicuse(void)
{
	MyVector v;
	MySet s;

    boost::array<int, 4> a = { 2, 1, 3, 2 };

	for (boost::array<int, 4>::const_iterator i = a.begin(); i != a.end(); ++i) 
	{
		FooPtr p(new Foo(*i));
		v.push_back(p);
		s.insert(p);
	}

	cout << "vector: ";
	for (MyVector::const_iterator i = v.begin(); i != v.end(); ++i)
		cout << (*i)->x << " ";

	cout << endl;
	
	cout << "set: "; 
	for (MySet::const_iterator i = s.begin(); i != s.end(); ++i)
		cout << (*i)->x << " ";

	cout << endl;

	v.clear();

	cout << "v geleert." << endl;

	s.clear();

	cout << "s geleert." << endl;

	cout << "Ende." << endl;

}

