// $Id$
// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag. Alle Rechte vorbehalten.

#define BENCHMARK

#ifdef BENCHMARK
#include <Windows.h>
#endif

#include <string>
#include <iostream>
#include <random>
#include <map>
#include <unordered_map>


using namespace std;
using namespace std::tr1;


const int SZ = 100000;

#ifdef BENCHMARK
LARGE_INTEGER freq;
LARGE_INTEGER t0;
#endif

void start(string msg)
{
#ifdef BENCHMARK
    cout << "  " << msg;
	QueryPerformanceCounter(&t0);
#endif
}


void stop(LONGLONG& ms)
{
#ifdef BENCHMARK
	LARGE_INTEGER t;
	QueryPerformanceCounter(&t);
	LONGLONG duration = 1000LL * (t.QuadPart - t0.QuadPart) / freq.QuadPart;
	ms += duration;
	cout << duration << " ms " << endl;
#endif
}

typedef unsigned long KeyType;
typedef unsigned long ValType;

mt19937 gen;
uniform_int<KeyType> dist(0, 100);
variate_generator<mt19937&, uniform_int<KeyType> > rng(gen, dist);



int main(int argc, char* argv[])
{
#ifdef BENCHMARK
	QueryPerformanceFrequency(&freq);
#endif

	const int TRIES = 5;
	
	LONGLONG t_map_ordered_w = 0;
	LONGLONG t_map_ordered_r = 0;
	LONGLONG t_map_unordered_w = 0;
	LONGLONG t_map_unordered_r = 0;

    for (int j = 0; j < TRIES; ++j)
    {
        cout << "Durchlauf " << j+1 << endl;

        {
            map<KeyType, ValType> m;

            start("map schreiben ... ");
            for (int i = 0; i < SZ; ++i)
                m[rng()] = 1;
            stop(t_map_ordered_w);

            start("map lesen ... ");
            for (int i = 0; i < SZ; ++i)
                volatile ValType x = m[i];
            stop(t_map_ordered_r);
        }

        {
            unordered_map<KeyType, ValType> um(SZ/2);

            start("unordered_map schreiben ... ");
            for (int i = 0; i < SZ; ++i)
                um[rng()] = 1;
            stop(t_map_unordered_w);

            start("unordered_map lesen ... ");
            for (int i = 0; i < SZ; ++i)
                volatile ValType x = um[i];
            stop(t_map_unordered_r);
        }
    }

    cout << "Mittelwerte:" << endl;
    cout << "  map, ordered, schreiben       = " << t_map_ordered_w  / TRIES << " ms" << endl;
	cout << "  map, ordered, lesen           = " << t_map_ordered_r  / TRIES << " ms" << endl;
	cout << "  map, unordered, schreiben     = " << t_map_unordered_w  / TRIES << " ms" << endl;
	cout << "  map, unordered, lesen         = " << t_map_unordered_r  / TRIES << " ms" << endl;
	cout << endl;

   	return 0;
}
