{type:"class",attributes:{"packageName":"qx.bom","type":"bootstrap","fullName":"qx.bom.Request","name":"Request"},children:[{type:"desc",attributes:{"text":"<p>Cross browser compatible unified XMLHttp transport low-level implementation.\nMimics an ideal browser without any quirks and is <span class=\"caps\">API</span> identical to\nthe W3C definition.</p>\n\n<p>Additional support for:</p>\n\n<ul>\n<li>the methods {@link #getRequestHeader} and {@link #removeRequestHeader}</li>\n<li>the <code>timeout</code> property and the <code>ontimeout</code> event</li>\n<li>the <code>onabort</code> event</li>\n<li>the <code>onload</code> event</li>\n<li>the <code>onerror</code> event</li>\n</ul>\n\n<p>These features are being considered for a future version of the XMLHttpRequest\nspecification by the W3C at <a href=\"http://www.w3.org/TR/XMLHttpRequest/\">http://www.w3.org/TR/XMLHttpRequest/</a>.</p>\n\n<p>For an higher level implementation with additional comfort please have a look\nat {@link qx.io2.HttpRequest}.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true","name":"ctor"}}]},{type:"constants",children:[{type:"constant",attributes:{"type":"Number","name":"HEADERS_RECEIVED","value":"2"}},{type:"constant",attributes:{"type":"Number","name":"UNSENT","value":"0"}},{type:"constant",attributes:{"type":"Number","name":"LOADING","value":"3"}},{type:"constant",attributes:{"type":"Number","name":"DONE","value":"4"}},{type:"constant",attributes:{"type":"Number","name":"OPENED","value":"1"}}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__abortHelper"},children:[{type:"desc",attributes:{"text":"<p>Internal helper for all aborting actions.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__cleanTransport"},children:[{type:"desc",attributes:{"text":"<p>Cleans up the native transport object and some other internal stuff.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__createNative"},children:[{type:"desc",attributes:{"text":"<p>Internal helper to return a new native XMLHttpRequest object suitable for\nthe client.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>native XMLHttpRequest object (IE uses ActiveX as default if enabled)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__dummyFunction"},children:[{type:"desc",attributes:{"text":"<p>Dummy function as fallback for internal ready state listener</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__fireReadyStateChange"},children:[{type:"desc",attributes:{"text":"<p>Internal helper to &#8220;fire&#8221; the onreadystatechange function</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__getDocument"},children:[{type:"desc",attributes:{"text":"<p>Internal helper to preprocess the <code>responseXML</code> to get\na valid <span class=\"caps\">XML</span> document.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The document. If the document contained an error <code>null</code> instead.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__onNativeReadyStateChange"},children:[{type:"desc",attributes:{"text":"<p>Internal callback for native <code>readystatechange</code> event.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__onNativeTimeout"},children:[{type:"desc",attributes:{"text":"<p>Internal callback for native <code>timeout</code> event.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__synchronizeValues"},children:[{type:"desc",attributes:{"text":"<p>Internal helper to store the values from the native object locally. This helps\nto omit exceptions when the user tries this directly.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"abort"},children:[{type:"desc",attributes:{"text":"<p>Stops the current request.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getAllResponseHeaders"},children:[{type:"desc",attributes:{"text":"<p>Returns complete set of headers (labels and values) as a string</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>All headers</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"label"},children:[{type:"desc",attributes:{"text":"<p>Label of the header entry</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the value of a given header label.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The value or <code>null</code> when not defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getResponseHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"label"},children:[{type:"desc",attributes:{"text":"<p>Name of the header label</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the string value of a single header label</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The selected header&#8217;s value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"isSuccessful"},children:[{type:"desc",attributes:{"text":"<p>Wether the currently running or finished request is successful.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code> when the request is successful.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"onabort"},children:[{type:"desc",attributes:{"text":"<p>Method which is executed when the user aborts the running request.</p>\n\n<p>This method needs to be overwritten by the user to get\ninformed about the user abort.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"onerror"},children:[{type:"desc",attributes:{"text":"<p>Method which is executed when the request fails.</p>\n\n<p>This method needs to be overwritten by the user to get\ninformed about the failure of the running request.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"onload"},children:[{type:"desc",attributes:{"text":"<p>Method which is executed when the request was finished successfully.</p>\n\n<p>This method needs to be overwritten by the user to get\ninformed about the successful load of the request.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"onreadystatechange"},children:[{type:"desc",attributes:{"text":"<p>Event handler for an event that fires at every state change.</p>\n\n<p>This method needs to be overwritten by the user to get\ninformed about the communication progress.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"ontimeout"},children:[{type:"desc",attributes:{"text":"<p>Event handler for an event that fires when the timeout limit is reached.</p>\n\n<p>This method needs to be overwritten by the user to get\ninformed about the timeout.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"open"},children:[{type:"params",children:[{type:"param",attributes:{"name":"method"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">HTTP</span> method to use. Valid values: <span class=\"caps\">GET</span>, <span class=\"caps\">POST</span>, <span class=\"caps\">PUT</span>, <span class=\"caps\">HEAD</span> and <span class=\"caps\">DELETE</span>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"url"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">URL</span> to open</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"async"},children:[{type:"desc",attributes:{"text":"<p>Whether the request should be asynchronous</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"username"},children:[{type:"desc",attributes:{"text":"<p>Optional user name</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"password"},children:[{type:"desc",attributes:{"text":"<p>Optional password</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Assigns destination <span class=\"caps\">URL</span>, method, and other optional attributes of a pending request</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"removeRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"label"},children:[{type:"desc",attributes:{"text":"<p>Name of the header label</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Value of the header field</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes a label from the header to be sent with a request.</p>\n\n<p>Uses local cache to omit dependency to <code>open()</code> call.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"send"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"","name":"data"},children:[{type:"desc",attributes:{"text":"<p>String or <span class=\"caps\">XML</span> <span class=\"caps\">DOM</span> object data</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}},{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Transmits the request, optionally with postable string or <span class=\"caps\">XML</span> <span class=\"caps\">DOM</span> object data</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"label"},children:[{type:"desc",attributes:{"text":"<p>Name of the header label</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Value of the header field</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Assigns a label/value pair to the header to be sent with a request.</p>\n\n<p>Uses local cache to omit dependency to <code>open()</code> call.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]}]}