{type:"class",attributes:{"name":"Exchange","isInternal":"true","packageName":"qx.io.remote","access":"internal","superClass":"qx.core.Object","fullName":"qx.io.remote.Exchange","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Transport layer to control which transport class (XmlHttp, Iframe or Script)\ncan be used.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRequest"},children:[{type:"desc",attributes:{"text":"<p>request object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.io.remote.Request"}}]}]}]},{type:"desc",attributes:{"text":"<p>Contructor method.</p>"}}]}]},{type:"events",children:[{type:"event",attributes:{"name":"aborted"},children:[{type:"desc",attributes:{"text":"<p>Fired whenever a request is aborted</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.io.remote.Response"}}]}]},{type:"event",attributes:{"name":"changeState"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #state}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"completed"},children:[{type:"desc",attributes:{"text":"<p>Fired whenever a request is completed</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.io.remote.Response"}}]}]},{type:"event",attributes:{"name":"failed"},children:[{type:"desc",attributes:{"text":"<p>Fired whenever a request has failed</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.io.remote.Response"}}]}]},{type:"event",attributes:{"name":"receiving"},children:[{type:"desc",attributes:{"text":"<p>Fired whenever a request is received</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"sending"},children:[{type:"desc",attributes:{"text":"<p>Fired whenever a request is send</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"timeout"},children:[{type:"desc",attributes:{"text":"<p>Fired whenever a request has timed out</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.io.remote.Response"}}]}]}]},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"canHandle"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vImpl"},children:[{type:"desc",attributes:{"text":"<p>transport implementation</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"vNeeds"},children:[{type:"desc",attributes:{"text":"<p>requirements for the request like e.g. &#8220;cross-domain&#8221;</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"vResponseType"},children:[{type:"desc",attributes:{"text":"<p>content type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Checks which supported transport class can handle the request with the\ngiven content type.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"initTypes"},children:[{type:"desc",attributes:{"text":"<p>Initializes the available type of transport classes and\nchecks for the supported ones.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"registerType"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vClass"},children:[{type:"desc",attributes:{"text":"<p>transport class</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"vId"},children:[{type:"desc",attributes:{"text":"<p>unique id</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Registers a transport type.\nAt the moment one out of XmlHttp, Iframe or Script.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"statusCodeToString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vStatusCode"},children:[{type:"desc",attributes:{"text":"<p>request status code</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Status code to string conversion</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>String presentation of status code</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"wasSuccessful"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vStatusCode"},children:[{type:"desc",attributes:{"text":"<p>status code of the request</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"vReadyState"},children:[{type:"desc",attributes:{"text":"<p>readystate of the request</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"vIsLocal"},children:[{type:"desc",attributes:{"text":"<p>whether the request is a local one</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Called from the transport class when a request was completed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns boolean value depending on the status code</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}},{type:"entry",attributes:{"type":"var"}}]}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.io.remote.Exchange#implementation","name":"_applyImplementation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Current value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>Previous value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Apply method for the implementation property.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.io.remote.Exchange#state","name":"_applyState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Current value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>Previous value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Apply method for the state property.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onabort"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for &#8220;abort&#8221; event.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_oncompleted"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for &#8220;completed&#8221; event.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onfailed"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for &#8220;failed&#8221; event.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onreceiving"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for &#8220;receiving&#8221; event.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onsending"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for &#8220;sending&#8221; event.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_ontimeout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for &#8220;timeout&#8221; event.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"abort"},children:[{type:"desc",attributes:{"text":"<p>Force the transport into the aborted (&#8220;aborted&#8221;)\n state.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getImplementation","fromProperty":"implementation"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>implementation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #implementation}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>implementation</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getRequest","fromProperty":"request"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>request</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>request</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getState","fromProperty":"state"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>state</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initImplementation","fromProperty":"implementation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>implementation</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>implementation</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #implementation}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initRequest","fromProperty":"request"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>request</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>request</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initState","fromProperty":"state"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>state</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>state</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"resetImplementation","fromProperty":"implementation"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>implementation</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #implementation}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetRequest","fromProperty":"request"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>request</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetState","fromProperty":"state"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>state</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"send"},children:[{type:"desc",attributes:{"text":"<p>Sends the request.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns true if the request was sent.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}},{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"setImplementation","fromProperty":"implementation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>implementation</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>implementation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #implementation}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setRequest","fromProperty":"request"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>request</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>request</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setState","fromProperty":"state"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>state</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"timeout"},children:[{type:"desc",attributes:{"text":"<p>Force the transport into the timeout state.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"true","apply":"_applyImplementation","check":"qx.io.remote.transport.Abstract","name":"implementation","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Set the implementation to use to send the request with.</p>\n\n<p>The implementation should be a subclass of qx.io.remote.transport.Abstract and\n must implement all methods in the transport <span class=\"caps\">API</span>.</p>"}}]},{type:"property",attributes:{"check":"qx.io.remote.Request","allowNull":"true","name":"request","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Set the request to send with this transport.</p>"}}]},{type:"property",attributes:{"name":"state","defaultValue":"\"configured\"","propertyType":"new","apply":"_applyState","possibleValues":"\"configured\",\"sending\",\"receiving\",\"completed\",\"aborted\",\"timeout\",\"failed\"","event":"changeState"},children:[{type:"desc",attributes:{"text":"<p>Current state of the transport layer.</p>"}}]}]}]}