{type:"class",attributes:{"name":"Stack","packageName":"qx.ui.container","superClass":"qx.ui.core.Widget","fullName":"qx.ui.container.Stack","type":"class"},children:[{type:"desc",attributes:{"text":"<p>The stack container puts its child widgets on top of each other and only the\ntopmost widget is visible.</p>\n\n<p>This is used e.g. in the tab view widget. Which widget is visible can be\ncontrolled by using the {@link #selected} property.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  // create stack container\n  var stack = new qx.ui.container.Stack();\n\n  // add some children\n  stack.add(new qx.ui.core.Widget().set({\n   backgroundColor: \"red\";\n  }));\n  stack.add(new qx.ui.core.Widget().set({\n   backgroundColor: \"green\";\n  }));\n  stack.add(new qx.ui.core.Widget().set({\n   backgroundColor: \"blue\";\n  }));\n\n  // select green widget\n  stack.setSelected(stack.getChildren()[1]);\n\n  this.getRoot().add(stack);\n</pre>\n\n<p>This example creates an stack with three children. Only the selected &#8220;green&#8221;\nwidget is visible.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://qooxdoo.org/documentation/0.8/widget/Stack\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo wiki.</a>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.ui.core.Widget","isCtor":"true","name":"ctor"}}]},{type:"events",children:[{type:"event",attributes:{"name":"change"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #selected}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.container.Stack#dynamic","name":"_applyDynamic"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>dynamic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyDynamic}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.container.Stack#selected","name":"_applySelected"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>selected</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applySelected}.</p>"}}]},{type:"method",attributes:{"name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>Any widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds a new child to the stack</p>"}}]},{type:"method",attributes:{"name":"getChildren"},children:[{type:"desc",attributes:{"text":"<p>Returns all children</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>List of all children</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"name":"getDynamic","fromProperty":"dynamic"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>dynamic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>dynamic</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSelected","fromProperty":"selected"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>selected</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selected}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>selected</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"indexOf"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>Any child</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Detects the position of the given widget in the\nchildren list of this widget.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initDynamic","fromProperty":"dynamic"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>dynamic</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>dynamic</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSelected","fromProperty":"selected"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>selected</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>selected</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #selected}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isDynamic","fromProperty":"dynamic"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>dynamic</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"next"},children:[{type:"desc",attributes:{"text":"<p>Go to the next child in the children list.</p>"}}]},{type:"method",attributes:{"name":"previous"},children:[{type:"desc",attributes:{"text":"<p>Go to the previous child in the children list.</p>"}}]},{type:"method",attributes:{"name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>Any widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the given widget from the stack</p>"}}]},{type:"method",attributes:{"name":"resetDynamic","fromProperty":"dynamic"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>dynamic</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSelected","fromProperty":"selected"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>selected</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #selected}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setDynamic","fromProperty":"dynamic"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>dynamic</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>dynamic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSelected","fromProperty":"selected"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>selected</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>selected</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selected}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleDynamic","fromProperty":"dynamic"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>dynamic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"Boolean","apply":"_applyDynamic","defaultValue":"false","name":"dynamic","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Whether the size of the widget depends on the selected child. When\ndisabled (default) the size is configured to the largest child.</p>"}}]},{type:"property",attributes:{"name":"selected","check":"qx.ui.core.Widget","allowNull":"true","propertyType":"new","apply":"_applySelected","event":"change"},children:[{type:"desc",attributes:{"text":"<p>The selected child</p>"}}]}]}]}