{type:"class",attributes:{"name":"ColorSelector","packageName":"qx.ui.control","superClass":"qx.ui.core.Widget","fullName":"qx.ui.control.ColorSelector","type":"class"},children:[{type:"desc",attributes:{"text":"<p>A typical color selector as known from native applications.</p>\n\n<p>Includes support for <span class=\"caps\">RGB</span> and <span class=\"caps\">HSB</span> color areas.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Widget","isCtor":"true","name":"ctor"},children:[{type:"desc",attributes:{"text":"<p>Creates a ColorSelector.</p>"}}]}]},{type:"events",children:[{type:"event",attributes:{"name":"dialogcancel"},children:[{type:"desc",attributes:{"text":"<p>Fired when the &#8220;Cancel&#8221; button is clicked.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"dialogok"},children:[{type:"desc",attributes:{"text":"<p>Fired when the &#8220;OK&#8221; button is clicked.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.control.ColorSelector#blue","name":"_applyBlue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>blue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyBlue}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.control.ColorSelector#brightness","name":"_applyBrightness"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>brightness</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyBrightness}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.control.ColorSelector#green","name":"_applyGreen"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>green</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyGreen}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.control.ColorSelector#hue","name":"_applyHue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>hue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyHue}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.control.ColorSelector#red","name":"_applyRed"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>red</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyRed}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.control.ColorSelector#saturation","name":"_applySaturation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>saturation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applySaturation}.</p>"}}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_createChildControlImpl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"}}]}]},{type:"method",attributes:{"access":"protected","name":"_onAppear"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener for appear.\nSets preview pane&#8217;s background color to the current color.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onBrightnessFieldMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener of mousedown event on the brightness field.\nAdjusts the color by changing the brightness.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onBrightnessHandleMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener of mousedown event on the brightness handle.\nAdjusts the color by changing the brightness.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onBrightnessHandleMouseMove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener of mousemove event on the brightness handle.\nForwards the event to _setBrightnessOnFieldEvent().</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onBrightnessHandleMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener of mouseup event on the brightness handle.\nReleases the capture.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onBrightnessPaneMouseWheel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener of mousewheel event on the brightness pane.\nAdjusts the color by changing the brightness.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onColorFieldClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener of click event on the color field.\nSets red, green and blue values to clicked color field&#8217;s background color.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onHexFieldChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"desc",attributes:{"text":"<p>Changes red, green and blue value to the corresponding hexfield value.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onHueSaturationFieldMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener of mousedown event on the saturation field.\nAdjusts the color by changing the saturation.\nSets mouse capture.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onHueSaturationHandleMouseMove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener of mousemove event on the saturation handle.\nForwards the event to _onHueSaturationHandleMouseMove().</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onHueSaturationHandleMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener of mouseup event on the saturation handle.\nReleases mouse capture.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onHueSaturationPaneMouseWheel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener of mousewheel event on the saturation pane.\nAdjusts the color by changing the saturation.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setBlueFromSpinner"},children:[{type:"desc",attributes:{"text":"<p>Sets widget&#8217;s blue value to spinner&#8217;s value.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setBrightnessFromSpinner"},children:[{type:"desc",attributes:{"text":"<p>Sets widget&#8217;s brightness value to spinner&#8217;s value.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setBrightnessGradiant"},children:[{type:"desc",attributes:{"text":"<p>Updates the background of the brightness field to give a nicer gradiant</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setBrightnessOnFieldEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incomingming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the brightness and moves the brightness handle.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setGreenFromSpinner"},children:[{type:"desc",attributes:{"text":"<p>Sets widget&#8217;s green value to spinner&#8217;s value.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setHexFromRgb"},children:[{type:"desc",attributes:{"text":"<p>Sets hexfield value to it&#8217;s corresponding red, green and blue value.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setHueFromRgb"},children:[{type:"desc",attributes:{"text":"<p>Sets hue value to it&#8217;s corresponding red, green and blue value.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setHueFromSpinner"},children:[{type:"desc",attributes:{"text":"<p>Sets widget&#8217;s hue value to spinner&#8217;s value.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setHueSaturationOnFieldEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Incoming event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the saturation and moves the saturation handle.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setPreviewFromRgb"},children:[{type:"desc",attributes:{"text":"<p>Sets preview pane&#8217;s background color to corresponding red, green and blue color values.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setRedFromSpinner"},children:[{type:"desc",attributes:{"text":"<p>Sets widget&#8217;s red value to spinner&#8217;s value.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setRgbFromHue"},children:[{type:"desc",attributes:{"text":"<p>Sets red, green and blue value to corresponding hue value.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setSaturationFromSpinner"},children:[{type:"desc",attributes:{"text":"<p>Sets widget&#8217;s saturation value to spinner&#8217;s value.</p>"}}]},{type:"method",attributes:{"name":"getBlue","fromProperty":"blue"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>blue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>blue</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getBrightness","fromProperty":"brightness"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>brightness</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #brightness}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>brightness</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getGreen","fromProperty":"green"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>green</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>green</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getHue","fromProperty":"hue"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>hue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #hue}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>hue</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getRed","fromProperty":"red"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>red</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>red</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSaturation","fromProperty":"saturation"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>saturation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #saturation}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>saturation</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initBlue","fromProperty":"blue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>blue</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>blue</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initBrightness","fromProperty":"brightness"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>brightness</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>brightness</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #brightness}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initGreen","fromProperty":"green"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>green</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>green</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initHue","fromProperty":"hue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>hue</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>hue</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #hue}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initRed","fromProperty":"red"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>red</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>red</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSaturation","fromProperty":"saturation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>saturation</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>saturation</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #saturation}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"resetBlue","fromProperty":"blue"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>blue</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetBrightness","fromProperty":"brightness"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>brightness</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #brightness}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetGreen","fromProperty":"green"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>green</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetHue","fromProperty":"hue"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>hue</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #hue}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetRed","fromProperty":"red"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>red</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSaturation","fromProperty":"saturation"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>saturation</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #saturation}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setBlue","fromProperty":"blue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>blue</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>blue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setBrightness","fromProperty":"brightness"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>brightness</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>brightness</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #brightness}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setGreen","fromProperty":"green"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>green</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>green</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setHue","fromProperty":"hue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>hue</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>hue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #hue}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setPreviousColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRed"},children:[{type:"desc",attributes:{"text":"<p>Red color value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"vGreen"},children:[{type:"desc",attributes:{"text":"<p>Green color value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"vBlue"},children:[{type:"desc",attributes:{"text":"<p>Blue color value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets previous color&#8217;s to given values.</p>"}}]},{type:"method",attributes:{"name":"setRed","fromProperty":"red"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>red</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>red</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSaturation","fromProperty":"saturation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>saturation</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>saturation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #saturation}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"appearance","docFrom":"qx.ui.core.Widget","defaultValue":"\"colorselector\"","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.core.Widget"}},{type:"property",attributes:{"check":"Integer","apply":"_applyBlue","defaultValue":"255","name":"blue","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The numeric blue value of the selected color.</p>"}}]},{type:"property",attributes:{"check":"Number","apply":"_applyBrightness","defaultValue":"100","name":"brightness","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The numeric brightness value.</p>"}}]},{type:"property",attributes:{"check":"Integer","apply":"_applyGreen","defaultValue":"255","name":"green","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The numeric green value of the selected color.</p>"}}]},{type:"property",attributes:{"check":"Number","apply":"_applyHue","defaultValue":"0","name":"hue","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The numeric hue value.</p>"}}]},{type:"property",attributes:{"check":"Integer","apply":"_applyRed","defaultValue":"255","name":"red","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The numeric red value of the selected color.</p>"}}]},{type:"property",attributes:{"check":"Number","apply":"_applySaturation","defaultValue":"0","name":"saturation","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The numeric saturation value.</p>"}}]}]}]}