{type:"class",attributes:{"name":"ScrollPane","packageName":"qx.ui.core","superClass":"qx.ui.core.Widget","fullName":"qx.ui.core.ScrollPane","type":"class"},children:[{type:"desc",attributes:{"text":"<p>This class represents a scroll able pane. This means that this widget\nmay contain content which is bigger than the available (inner)\ndimensions of this widget. The widget also offer methods to control\nthe scrolling position. It can only have exactly one child.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.ui.core.Widget","isCtor":"true","name":"ctor"}}]},{type:"events",children:[{type:"event",attributes:{"name":"scrollX"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #scrollX}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"scrollY"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #scrollY}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"update"},children:[{type:"desc",attributes:{"text":"<p>Fired on resize of both the container or the content.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.ScrollPane#scrollX","name":"_applyScrollX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"typeof value=='number'&&value>=0&&value<=this.getScrollMaxX()"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"typeof value=='number'&&value>=0&&value<=this.getScrollMaxX()"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>scrollX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyScrollX}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.ScrollPane#scrollY","name":"_applyScrollY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"typeof value=='number'&&value>=0&&value<=this.getScrollMaxY()"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"typeof value=='number'&&value>=0&&value<=this.getScrollMaxY()"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>scrollY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyScrollY}.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onAppear"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Appear event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for appear event of content</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onScroll"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Scroll event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for scroll event of content</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onUpdate"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Resize event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for resize event of content and container</p>"}}]},{type:"method",attributes:{"name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"null","name":"widget"},children:[{type:"desc",attributes:{"text":"<p>The content widget of the pane</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Configures the content of the scroll pane. Replaces any existing child\nwith the newly given one.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getChild"},children:[{type:"desc",attributes:{"text":"<p>Returns the current content.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The current layout content</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"name":"getItemBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Item to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the top offset of the end of the given item in relation to the\ninner height of this widget.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Top offset</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getItemLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Item to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the left offset of the given item in relation to the\ninner width of this widget.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Top offset</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getItemRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Item to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the left offset of the end of the given item in relation to the\ninner width of this widget.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Right offset</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getItemTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Item to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the top offset of the given item in relation to the\ninner height of this widget.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Top offset</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getScrollMaxX"},children:[{type:"desc",attributes:{"text":"<p>The maximum horizontal scroll position.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Maximum horizontal scroll position.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getScrollMaxY"},children:[{type:"desc",attributes:{"text":"<p>The maximum vertical scroll position.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Maximum vertical scroll position.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getScrollSize"},children:[{type:"desc",attributes:{"text":"<p>The size (identical with the preferred size) of of the content.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Size of the content (keys: <code>width</code> and <code>height</code>)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getScrollX","fromProperty":"scrollX"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>scrollX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>scrollX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getScrollY","fromProperty":"scrollY"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>scrollY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>scrollY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initScrollX","fromProperty":"scrollX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>scrollX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>scrollX</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initScrollY","fromProperty":"scrollY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>scrollY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>scrollY</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"null","name":"widget"},children:[{type:"desc",attributes:{"text":"<p>The content widget of the pane</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the given widget from the content. The pane is empty\nafterwards as only one child is supported by the pane.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetScrollX","fromProperty":"scrollX"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>scrollX</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollX}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetScrollY","fromProperty":"scrollY"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>scrollY</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollY}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"scrollByX"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"0","name":"x"},children:[{type:"desc",attributes:{"text":"<p>Amount to scroll</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls the element&#8217;s content horizontally by the given amount.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"scrollByY"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"0","name":"y"},children:[{type:"desc",attributes:{"text":"<p>Amount to scroll</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls the element&#8217;s content vertically by the given amount.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"scrollToX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The vertical position to scroll to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls the element&#8217;s content to the given left coordinate</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"scrollToY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The horizontal position to scroll to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls the element&#8217;s content to the given top coordinate</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setScrollX","fromProperty":"scrollX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>scrollX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>scrollX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setScrollY","fromProperty":"scrollY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>scrollY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>scrollY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"scrollX","defaultValue":"0","event":"scrollX","propertyType":"new","apply":"_applyScrollX","check":"typeof value=='number'&&value>=0&&value<=this.getScrollMaxX()"},children:[{type:"desc",attributes:{"text":"<p>The horizontal scroll position</p>"}}]},{type:"property",attributes:{"name":"scrollY","defaultValue":"0","event":"scrollY","propertyType":"new","apply":"_applyScrollY","check":"typeof value=='number'&&value>=0&&value<=this.getScrollMaxY()"},children:[{type:"desc",attributes:{"text":"<p>The vertical scroll position</p>"}}]}]}]}