{type:"class",attributes:{"name":"Widget","packageName":"qx.ui.core","mixins":"qx.locale.MTranslation","superClass":"qx.ui.core.LayoutItem","childClasses":"qx.ui.basic.Atom,qx.ui.basic.Image,qx.ui.basic.Label,qx.ui.container.Composite,qx.ui.container.SlideBar,qx.ui.container.Stack,qx.ui.control.ColorSelector,qx.ui.control.DateChooser,qx.ui.core.AbstractScrollArea,qx.ui.core.ScrollBar,qx.ui.core.ScrollPane,qx.ui.embed.Canvas,qx.ui.embed.Html,qx.ui.embed.Iframe,qx.ui.form.AbstractField,qx.ui.form.AbstractSelectBox,qx.ui.form.Slider,qx.ui.form.Spinner,qx.ui.form.SplitButton,qx.ui.groupbox.GroupBox,qx.ui.menu.AbstractButton,qx.ui.menu.Menu,qx.ui.menu.Separator,qx.ui.root.Abstract,qx.ui.splitpane.Pane,qx.ui.splitpane.Slider,qx.ui.splitpane.Splitter,qx.ui.table.Table,qx.ui.table.pane.Header,qx.ui.table.pane.Pane,qx.ui.table.pane.Scroller,qx.ui.tabview.TabView,qx.ui.toolbar.Part,qx.ui.toolbar.Separator,qx.ui.toolbar.ToolBar,qx.ui.tree.AbstractTreeItem,qx.ui.window.Desktop,qx.ui.window.Window","fullName":"qx.ui.core.Widget","type":"class"},children:[{type:"desc",attributes:{"text":"<p>This is the base class for all widgets.</p>\n\n<p>A widget consists of at least three <span class=\"caps\">HTML</span> elements. The container element,\nwhich is\nadded to the parent widget has two child Element: The &#8220;decoration&#8221; and the\n&#8220;content&#8221; element. The decoration element has a lower z-Index and contains\nmarkup to render the widget&#8217;s background and border using an implementation\nof {@link qx.ui.decoration.IDecorator}.The content element is positioned\ninside the &#8220;container&#8221; element to respect paddings and contains the &#8220;real&#8221;\nwidget element.</p>\n\n<pre>\n-container------------\n|                    |\n|  -decoration----   |\n|  | -content----|-  |\n|  | |           ||  |\n|  --|------------|  |\n|    --------------  |\n|                    |\n----------------------\n</pre>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://qooxdoo.org/documentation/0.8/widget/Widget\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo wiki.</a>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"}}]},{type:"events",children:[{type:"event",attributes:{"name":"activate"},children:[{type:"desc",attributes:{"text":"<p>When the widget gets active (receives keyboard events etc.)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Focus"}}]}]},{type:"event",attributes:{"name":"appear"},children:[{type:"desc",attributes:{"text":"<p>Fired after the widget appears on the screen.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"blur"},children:[{type:"desc",attributes:{"text":"<p>The event is fired when the widget gets blurred. Only widgets which are\n{@link #focusable} receive this event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Focus"}}]}]},{type:"event",attributes:{"name":"capture"},children:[{type:"desc",attributes:{"text":"<p>Fired is the widget becomes the capturing widget by a call to {@link #capture}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"changeAppearance"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #appearance}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeBackgroundColor"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #backgroundColor}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeContextMenu"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #contextMenu}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeDecorator"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #decorator}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeEnabled"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #enabled}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeFont"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #font}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeShadow"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #shadow}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeTextColor"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #textColor}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeVisibility"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #visibility}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeZIndex"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #zIndex}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"click"},children:[{type:"desc",attributes:{"text":"<p>Widget is clicked using the left mouse button.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]},{type:"event",attributes:{"name":"contextmenu"},children:[{type:"desc",attributes:{"text":"<p>Widget is clicked using the right mouse button.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]},{type:"event",attributes:{"name":"dblclick"},children:[{type:"desc",attributes:{"text":"<p>Widget is double clicked using the left mouse button.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]},{type:"event",attributes:{"name":"deactivate"},children:[{type:"desc",attributes:{"text":"<p>When the widget gets inactive</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Focus"}}]}]},{type:"event",attributes:{"name":"disappear"},children:[{type:"desc",attributes:{"text":"<p>Fired after the widget disappears from the screen.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"drag"},children:[{type:"desc",attributes:{"text":"<p>Fired during the drag. Contains the current mouse coordinates\nusing {@link #qx.event.type.Drag#getDocumentLeft} and\n{@link #qx.event.type.Drag#getDocumentTop}</p>\n\n<p>Modeled after the <span class=\"caps\">WHATWG</span> specification of Drag&amp;Drop:\n<a href=\"http://www.whatwg.org/specs/web-apps/current-work/#dnd\">http://www.whatwg.org/specs/web-apps/current-work/#dnd</a></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]},{type:"event",attributes:{"name":"dragchange"},children:[{type:"desc",attributes:{"text":"<p>Fired when the drag configuration has been modified e.g. the user\npressed a key which changed the selected action.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]},{type:"event",attributes:{"name":"dragend"},children:[{type:"desc",attributes:{"text":"<p>Fired on the source (drag) target every time a drag session was ended.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]},{type:"event",attributes:{"name":"dragleave"},children:[{type:"desc",attributes:{"text":"<p>Fired on a potential drop target when leaving it.</p>\n\n<p>Modeled after the <span class=\"caps\">WHATWG</span> specification of Drag&amp;Drop:\n<a href=\"http://www.whatwg.org/specs/web-apps/current-work/#dnd\">http://www.whatwg.org/specs/web-apps/current-work/#dnd</a></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]},{type:"event",attributes:{"name":"dragover"},children:[{type:"desc",attributes:{"text":"<p>Fired on a potential drop target when reaching it via the mouse.\nThis event can be canceled if none of the incoming data types\nare supported.</p>\n\n<p>Modeled after the <span class=\"caps\">WHATWG</span> specification of Drag&amp;Drop:\n<a href=\"http://www.whatwg.org/specs/web-apps/current-work/#dnd\">http://www.whatwg.org/specs/web-apps/current-work/#dnd</a></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]},{type:"event",attributes:{"name":"dragstart"},children:[{type:"desc",attributes:{"text":"<p>Initiate the drag-and-drop operation. This event is cancelable\nwhen the drag operation is currently not allowed/possible.</p>\n\n<p>Modeled after the <span class=\"caps\">WHATWG</span> specification of Drag&amp;Drop:\n<a href=\"http://www.whatwg.org/specs/web-apps/current-work/#dnd\">http://www.whatwg.org/specs/web-apps/current-work/#dnd</a></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]},{type:"event",attributes:{"name":"drop"},children:[{type:"desc",attributes:{"text":"<p>Fired on the drop target when the drag&amp;drop action is finished\nsuccessfully. This event is normally used to transfer the data\nfrom the drag to the drop target.</p>\n\n<p>Modeled after the <span class=\"caps\">WHATWG</span> specification of Drag&amp;Drop:\n<a href=\"http://www.whatwg.org/specs/web-apps/current-work/#dnd\">http://www.whatwg.org/specs/web-apps/current-work/#dnd</a></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]},{type:"event",attributes:{"name":"droprequest"},children:[{type:"desc",attributes:{"text":"<p>Fired when the drop was successfully done and the target widget\nis now asking for data. The listener should transfer the data,\nrespecting the selected action, to the event. This can be done using\nthe event&#8217;s {@link #qx.event.type.Drag#addData} method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]},{type:"event",attributes:{"name":"focus"},children:[{type:"desc",attributes:{"text":"<p>The event is fired when the widget gets focused. Only widgets which are\n{@link #focusable} receive this event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Focus"}}]}]},{type:"event",attributes:{"name":"focusin"},children:[{type:"desc",attributes:{"text":"<p>When the widget itself or any child of the widget receive the focus.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Focus"}}]}]},{type:"event",attributes:{"name":"focusout"},children:[{type:"desc",attributes:{"text":"<p>When the widget itself or any child of the widget lost the focus.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Focus"}}]}]},{type:"event",attributes:{"name":"keydown"},children:[{type:"desc",attributes:{"text":"<p>This event if fired if a keyboard button is pushed down. This event is\nonly fired once if the user keeps the key pressed for a while.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]},{type:"event",attributes:{"name":"keyinput"},children:[{type:"desc",attributes:{"text":"<p>This event is fired if the pressed key or keys result in a printable\ncharacter. Since the character is not necessarily associated with a\nsingle physical key press, the event does not have a key identifier\ngetter. This event gets repeated if the user keeps pressing the key(s).</p>\n\n<p>The unicode code of the pressed key can be read using\n{@link qx.event.type.KeyInput#getKeyCode}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeyInput"}}]}]},{type:"event",attributes:{"name":"keypress"},children:[{type:"desc",attributes:{"text":"<p>This event is fired any time a key is pressed. It will be repeated if\nthe user keeps the key pressed. The pressed key can be determined using\n{@link qx.event.type.KeySequence#getKeyIdentifier}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]},{type:"event",attributes:{"name":"keyup"},children:[{type:"desc",attributes:{"text":"<p>This event if fired if a keyboard button is released. This event is\nonly fired once if the user keeps the key pressed for a while.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]},{type:"event",attributes:{"name":"losecapture"},children:[{type:"desc",attributes:{"text":"<p>Fired is the widget looses the capturing mode by a call to\n{@link #releaseCapture} or a mouse click.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"mousedown"},children:[{type:"desc",attributes:{"text":"<p>Mouse button is pressed on the widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]},{type:"event",attributes:{"name":"mousemove"},children:[{type:"desc",attributes:{"text":"<p>Fired if the mouse cursor moves over the widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]},{type:"event",attributes:{"name":"mouseout"},children:[{type:"desc",attributes:{"text":"<p>Fired if the mouse cursor leaves widget.</p>\n\n<p>Note: This event is also dispatched if the widget is disabled!</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]},{type:"event",attributes:{"name":"mouseover"},children:[{type:"desc",attributes:{"text":"<p>Fired if the mouse cursor enters the widget.</p>\n\n<p>Note: This event is also dispatched if the widget is disabled!</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]},{type:"event",attributes:{"name":"mouseup"},children:[{type:"desc",attributes:{"text":"<p>Mouse button is released on the widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]},{type:"event",attributes:{"name":"mousewheel"},children:[{type:"desc",attributes:{"text":"<p>Fired if the mouse wheel is used over the widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]},{type:"event",attributes:{"name":"move"},children:[{type:"desc",attributes:{"text":"<p>Fired on move (after layouting) of the widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"resize"},children:[{type:"desc",attributes:{"text":"<p>Fired on resize (after layouting) of the widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__addHelper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>The child to add.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"name":"options"},children:[{type:"desc",attributes:{"text":"<p>Optional layout data for the widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"desc",attributes:{"text":"<p>Convenience function to add a child widget. It will insert the child to\nthe parent widget and schedule a layout update.</p>"}}]},{type:"method",attributes:{"access":"private","name":"__createContentElement"},children:[{type:"desc",attributes:{"text":"<p>Create the widget&#8217;s content <span class=\"caps\">HTML</span> element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The content <span class=\"caps\">HTML</span> element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__createDecoratorElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"decorator"},children:[{type:"desc",attributes:{"text":"<p>Any instance implementing the decorator interface</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.decoration.IDecorator"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates an element which may be used for a\ndecoration render to fill.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The element to be used for decorations/shadows</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__removeHelper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>The child to remove.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>Convenience function to remove a child widget. It will remove it\nfrom the parent widget and schedule a layout update.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the widget to add.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"options"},children:[{type:"desc",attributes:{"text":"<p>Optional layout data for widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds a new child widget.</p>\n\n<p>The supported keys of the layout options map depend on the layout manager\nused to position the widget. The options are documented in the class\ndocumentation of each layout manager {@link qx.ui.layout}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_addAfter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>widget to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"name":"after"},children:[{type:"desc",attributes:{"text":"<p>widget, after which the new widget will be inserted</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"options"},children:[{type:"desc",attributes:{"text":"<p>Optional layout data for widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add a widget after another already inserted widget</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_addAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>widget to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>Index, at which the widget will be inserted</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"options"},children:[{type:"desc",attributes:{"text":"<p>Optional layout data for widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add a child widget at the specified index</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_addBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>widget to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"name":"before"},children:[{type:"desc",attributes:{"text":"<p>widget before the new widget will be inserted.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"options"},children:[{type:"desc",attributes:{"text":"<p>Optional layout data for widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add a widget before another already inserted widget</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_afterAddChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>The added child.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.LayoutItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method gets called each time after a child widget was added and can\nbe overridden to get notified about child adds.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_afterRemoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>The removed child.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.LayoutItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method gets called each time after a child widget was removed and\ncan be overridden to get notified about child removes.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#appearance","name":"_applyAppearance"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>appearance</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyAppearance}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#backgroundColor","name":"_applyBackgroundColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Color"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Color"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>backgroundColor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyBackgroundColor}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#contextMenu","name":"_applyContextMenu"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>contextMenu</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyContextMenu}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#cursor","name":"_applyCursor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>cursor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyCursor}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#decorator","name":"_applyDecorator"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Decorator"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Decorator"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>decorator</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyDecorator}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#draggable","name":"_applyDraggable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>draggable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyDraggable}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#droppable","name":"_applyDroppable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>droppable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyDroppable}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#enabled","name":"_applyEnabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyEnabled}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#focusable","name":"_applyFocusable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>focusable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyFocusable}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#font","name":"_applyFont"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Font"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Font"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>font</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyFont}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#keepActive","name":"_applyKeepActive"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>keepActive</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyKeepActive}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#keepFocus","name":"_applyKeepFocus"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>keepFocus</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyKeepFocus}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#opacity","name":"_applyOpacity"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>opacity</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyOpacity}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#paddingRight","name":"_applyPadding"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>paddingBottom</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyPadding}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#selectable","name":"_applySelectable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>selectable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applySelectable}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#shadow","name":"_applyShadow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Decorator"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Decorator"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>shadow</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyShadow}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#tabIndex","name":"_applyTabIndex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>tabIndex</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyTabIndex}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#textColor","name":"_applyTextColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Color"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Color"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>textColor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyTextColor}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#visibility","name":"_applyVisibility"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>visibility</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyVisibility}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#zIndex","name":"_applyZIndex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>zIndex</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyZIndex}.</p>"}}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.LayoutItem","overriddenFrom":"qx.ui.core.LayoutItem","name":"_computeSizeHint"}},{type:"method",attributes:{"access":"protected","name":"_createChildControl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>ID of the child control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Force the creation of the given child control by ID.</p>\n\n<p>Do not override this method! Override {@link #_createChildControlImpl}\ninstead if you need to support new controls.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The created control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_createChildControlImpl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>ID of the child control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Internal method to create child controls. This method\nshould be overwritten by classes which extends this one\nto support new child control types.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The created control or <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_createContainerElement"},children:[{type:"desc",attributes:{"text":"<p>Create the widget&#8217;s container <span class=\"caps\">HTML</span> element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The container <span class=\"caps\">HTML</span> element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_createContentElement"},children:[{type:"desc",attributes:{"text":"<p>Creates the content element. The style properties\nposition and zIndex are modified from the Widget\ncore.</p>\n\n<p>This function may be overridden to customize a class\ncontent.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_createProtectorElement"},children:[{type:"desc",attributes:{"text":"<p>Creates the protector element used to block mouse events\nfrom the decoration.</p>\n\n<p>This is needed because of the way the decorations work. Most\nof them tend to replace the underlying <span class=\"caps\">HTML</span> of a widget\ndynamically on mouse over. But this also means that the\nnative mouse out is not fired on the new content with which\nthe old content is replaced. This is a fact given through\nthe native behavior of the browser.</p>\n\n<p>The protector is placed between the content and the decoration.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The protector element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_disposeChildControls"},children:[{type:"desc",attributes:{"text":"<p>Dispose all registered controls. This is automatically\nexecuted by the widget.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_excludeChildControl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>ID of the child control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Excludes the given child control by ID</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_findTopControl"},children:[{type:"desc",attributes:{"text":"<p>Finds and returns the top level control. This is the first\nwidget which is not a child control of any other widget.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The top control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getChildControl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>ID of the child control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"notcreate"},children:[{type:"desc",attributes:{"text":"<p>Whether the child control\n   should not be created dynamically if not yet available.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the child control from the given ID. Returns\n<code>null</code> when the child control is unknown.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Child control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getChildren"},children:[{type:"desc",attributes:{"text":"<p>Returns the children list</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The children array (Arrays are\n  reference types, please to not modify them in-place)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem","dimensions":"1"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getContentHeightForWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>Incoming width (as limitation)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the computed height for the given width.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Computed height while respecting the given width.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getContentHint"},children:[{type:"desc",attributes:{"text":"<p>Returns the recommended/natural dimensions of the widget&#8217;s content.</p>\n\n<p>For labels and images this may be their natural size when defined without\nany dimensions. For containers this may be the recommended size of the\nunderlaying layout manager.</p>\n\n<p>Developer note: This can be overwritten by the derived classes to allow\na custom handling here.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.LayoutItem","overriddenFrom":"qx.ui.core.LayoutItem","name":"_getHeightForWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"width"}}]}]},{type:"method",attributes:{"access":"protected","name":"_getLayout"},children:[{type:"desc",attributes:{"text":"<p>Get the widget&#8217;s layout manager.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The widget&#8217;s layout manager</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.layout.Abstract"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_hasChildControl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>ID of the child control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the given ID is assigned to a child control.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> when the child control is registered."}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_hasChildren"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget contains children.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code> when the widget has children.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_indexOf"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the widget to query for</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the index position of the given widget if it is\na child widget. Otherwise it returns <code>-1</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The index position or <code>-1</code> when\n  the given widget is no child of this layout.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_isChildControlVisible"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>ID of the child control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the given child control is visible.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> when the child control is visible."}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onContextMenuOpen"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for <code>contextmenu</code> event</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onDrag"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Drag event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for own <code>dragmove</code> event.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onDragChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Drag event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for own <code>dragchange</code> event.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onDragEnd"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Drag event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for own <code>dragend</code> event.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onDragStart"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Drag event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Drag"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for own <code>dragstart</code> event.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onStopEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Any bubbling event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener which stops a bubbling event from\npropagates further.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the widget to remove</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>Remove the given child widget.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_removeAll"},children:[{type:"desc",attributes:{"text":"<p>Remove all children.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_removeAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>Index of the widget to remove.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Remove the widget at the specified index.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_setLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"layout"},children:[{type:"desc",attributes:{"text":"<p>The new layout or\n    <code>null</code> to reset the layout.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.layout.Abstract"}}]}]}]},{type:"desc",attributes:{"text":"<p>Set a layout manager for the widget. A a layout manager can only be connected\nwith one widget. Reset the connection with a previous widget first, if you\nlike to use it in another widget instead.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_showChildControl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>ID of the child control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Shows the given child control by ID</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the child control</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"name":"activate"},children:[{type:"desc",attributes:{"text":"<p>Activate this widget e.g. for keyboard events.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"addChildrenToQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"queue"},children:[{type:"desc",attributes:{"text":"<p>The queue to add widgets to</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Recursively adds all children to the given queue</p>"}}]},{type:"method",attributes:{"name":"addState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"state"},children:[{type:"desc",attributes:{"text":"<p>The state to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets a state.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"blur"},children:[{type:"desc",attributes:{"text":"<p>Remove focus from this widget.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"capture"},children:[{type:"desc",attributes:{"text":"<p>Enables mouse event capturing. All mouse events will dispatched on this\nwidget until capturing is disabled using {@link #releaseCapture} or a\nmouse button is clicked. If the widgets becomes the capturing widget the\n{@link #capture} event is fired. Once it looses capture mode the\n{@link #losecapture} event is fired.</p>"}}]},{type:"method",attributes:{"access":"internal","isInternal":"true","name":"checkAppearanceNeeds"},children:[{type:"desc",attributes:{"text":"<p>Helper method called from the visibility queue to detect outstanding changes\nto the appearance.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.core.LayoutItem","overriddenFrom":"qx.ui.core.LayoutItem","name":"clearSeparators"}},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.ui.core.LayoutItem","name":"clone"}},{type:"method",attributes:{"name":"deactivate"},children:[{type:"desc",attributes:{"text":"<p>Deactivate this widget e.g. for keyboard events.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"destroy"},children:[{type:"desc",attributes:{"text":"<p>Removes this widget from its parent and dispose it.</p>\n\n<p>Please note that the widget is not disposed synchronously. The\nreal dispose happens after the next queue flush.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"exclude"},children:[{type:"desc",attributes:{"text":"<p>Hide this widget and exclude it from the underlying layout.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"focus"},children:[{type:"desc",attributes:{"text":"<p>Focus this widget.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getAnonymous","fromProperty":"anonymous"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>anonymous</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #anonymous}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>anonymous</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getAppearance","fromProperty":"appearance"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>appearance</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #appearance}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>appearance</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getBackgroundColor","fromProperty":"backgroundColor"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>backgroundColor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #backgroundColor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>backgroundColor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getChildrenContainer"},children:[{type:"desc",attributes:{"text":"<p>Returns the widget which contains the children and\nis relevant for layouting them. This is from the user point of\nview and may not be identical to the technical structure.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Widget which contains the children.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"name":"getContainerElement"},children:[{type:"desc",attributes:{"text":"<p>Returns the element wrapper of the widget&#8217;s container element.\nThis method exposes widget internal and must be used with caution!</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The widget&#8217;s container element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"getContainerLocation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"mode"},children:[{type:"desc",attributes:{"text":"<p>A supported option. See comment above.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Computes the location of the container element in context of the document dimensions.</p>\n\n<p>Supported modes:</p>\n\n<ul>\n<li><code>margin</code>: Calculate from the margin box of the element (bigger than the visual appearance: including margins of given element)</li>\n<li><code>box</code>: Calculates the offset box of the element (default, uses the same size as visible)</li>\n<li><code>border</code>: Calculate the border box (useful to align to border edges of two elements).</li>\n<li><code>scroll</code>: Calculate the scroll box (relevant for absolute positioned content).</li>\n<li><code>padding</code>: Calculate the padding box (relevant for static/relative positioned content).</li>\n</ul>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns a map with <code>left</code>, <code>top</code>,\n  <code>right</code> and <code>bottom</code> which contains the distance\n  of the element relative to the document.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getContentElement"},children:[{type:"desc",attributes:{"text":"<p>Returns the element wrapper of the widget&#8217;s content element.\nThis method exposes widget internal and must be used with caution!</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The widget&#8217;s content element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"getContentLocation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"mode"},children:[{type:"desc",attributes:{"text":"<p>A supported option. See comment above.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Computes the location of the content element in context of the document dimensions.</p>\n\n<p>Supported modes:</p>\n\n<ul>\n<li><code>margin</code>: Calculate from the margin box of the element (bigger than the visual appearance: including margins of given element)</li>\n<li><code>box</code>: Calculates the offset box of the element (default, uses the same size as visible)</li>\n<li><code>border</code>: Calculate the border box (useful to align to border edges of two elements).</li>\n<li><code>scroll</code>: Calculate the scroll box (relevant for absolute positioned content).</li>\n<li><code>padding</code>: Calculate the padding box (relevant for static/relative positioned content).</li>\n</ul>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns a map with <code>left</code>, <code>top</code>,\n  <code>right</code> and <code>bottom</code> which contains the distance\n  of the element relative to the document.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getContextMenu","fromProperty":"contextMenu"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>contextMenu</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #contextMenu}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>contextMenu</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getCursor","fromProperty":"cursor"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>cursor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cursor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>cursor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getDecorator","fromProperty":"decorator"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>decorator</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #decorator}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>decorator</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getDecoratorElement"},children:[{type:"desc",attributes:{"text":"<p>Returns the element wrapper of the widget&#8217;s decorator element.\nThis method exposes widget internals and must be used with caution!</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The widget&#8217;s decorator element (may be null)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"name":"getDraggable","fromProperty":"draggable"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>draggable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #draggable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>draggable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getDroppable","fromProperty":"droppable"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>droppable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #droppable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>droppable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getEnabled","fromProperty":"enabled"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>enabled</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getEventTarget"},children:[{type:"desc",attributes:{"text":"<p>Returns the next event target in the parent chain. May\nalso return the widget itself if it is not anonymous.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A working event target of this widget.\n   May be <code>null</code> as well.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"name":"getFocusable","fromProperty":"focusable"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>focusable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #focusable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>focusable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getFocusElement"},children:[{type:"desc",attributes:{"text":"<p>Returns the element which should be focused.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The html element to focus.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"getFocusTarget"},children:[{type:"desc",attributes:{"text":"<p>Returns the next focus target in the parent chain. May\nalso return the widget itself if it is not anonymous and focusable.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A working focus target of this widget.\n   May be <code>null</code> as well.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"name":"getFont","fromProperty":"font"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>font</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #font}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>font</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getInnerSize"},children:[{type:"desc",attributes:{"text":"<p>Returns the widget&#8217;s computed inner size as available\nthrough the layout process.</p>\n\n<p>This function is guaranteed to return a correct value\nduring a {@link #changeSize} or {@link #changePosition} event dispatch.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The widget inner dimension in pixel (if the layout is\n   valid). Contains the keys <code>width</code> and <code>height</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getInsets"},children:[{type:"desc",attributes:{"text":"<p>Return the insets of the widget&#8217;s inner element relative to its\ncontainer element. The inset is the sum of the padding and border width.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Contains the keys <code>top</code>, <code>right</code>,\n  <code>bottom</code> and <code>left</code>. All values are integers.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getKeepActive","fromProperty":"keepActive"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>keepActive</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepActive}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>keepActive</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getKeepFocus","fromProperty":"keepFocus"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>keepFocus</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepFocus}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>keepFocus</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"internal","isInternal":"true","name":"getLayoutChildren"},children:[{type:"desc",attributes:{"text":"<p>Returns all children, which are layout relevant. This excludes all widgets,\nwhich have a {@link qx.ui.core.Widget#visibility} value of <code>exclude</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>All layout relevant children.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget","dimensions":"1"}}]}]}]},{type:"method",attributes:{"name":"getOpacity","fromProperty":"opacity"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>opacity</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #opacity}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>opacity</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getPaddingBottom","fromProperty":"paddingBottom"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>paddingBottom</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingBottom}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>paddingBottom</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getPaddingLeft","fromProperty":"paddingLeft"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>paddingLeft</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingLeft}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>paddingLeft</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getPaddingRight","fromProperty":"paddingRight"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>paddingRight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingRight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>paddingRight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getPaddingTop","fromProperty":"paddingTop"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>paddingTop</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingTop}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>paddingTop</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSelectable","fromProperty":"selectable"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>selectable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selectable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>selectable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getShadow","fromProperty":"shadow"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>shadow</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shadow}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>shadow</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getTabIndex","fromProperty":"tabIndex"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>tabIndex</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #tabIndex}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>tabIndex</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getTextColor","fromProperty":"textColor"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>textColor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #textColor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>textColor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getToolTip","fromProperty":"toolTip"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>toolTip</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #toolTip}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>toolTip</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getVisibility","fromProperty":"visibility"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>visibility</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #visibility}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>visibility</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getZIndex","fromProperty":"zIndex"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>zIndex</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #zIndex}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>zIndex</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"hasLayoutChildren"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the layout has children, which are layout relevant. This\nexcludes all widgets, which have a {@link qx.ui.core.Widget#visibility}\nvalue of <code>exclude</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the layout has layout relevant children</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"hasState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"state"},children:[{type:"desc",attributes:{"text":"<p>the state to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns whether a state is set.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the state is set.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"hide"},children:[{type:"desc",attributes:{"text":"<p>Hide this widget.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAnonymous","fromProperty":"anonymous"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>anonymous</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>anonymous</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #anonymous}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAppearance","fromProperty":"appearance"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>appearance</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>appearance</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #appearance}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initBackgroundColor","fromProperty":"backgroundColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>backgroundColor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>backgroundColor</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #backgroundColor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initContextMenu","fromProperty":"contextMenu"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>contextMenu</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>contextMenu</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #contextMenu}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initCursor","fromProperty":"cursor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>cursor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>cursor</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #cursor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initDecorator","fromProperty":"decorator"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>decorator</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>decorator</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #decorator}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initDraggable","fromProperty":"draggable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>draggable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>draggable</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #draggable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initDroppable","fromProperty":"droppable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>droppable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>droppable</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #droppable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initEnabled","fromProperty":"enabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>enabled</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>enabled</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initFocusable","fromProperty":"focusable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>focusable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>focusable</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #focusable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initFont","fromProperty":"font"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>font</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>font</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #font}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initKeepActive","fromProperty":"keepActive"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>keepActive</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>keepActive</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #keepActive}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initKeepFocus","fromProperty":"keepFocus"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>keepFocus</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>keepFocus</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #keepFocus}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initOpacity","fromProperty":"opacity"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>opacity</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>opacity</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #opacity}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initPaddingBottom","fromProperty":"paddingBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>paddingBottom</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>paddingBottom</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingBottom}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initPaddingLeft","fromProperty":"paddingLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>paddingLeft</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>paddingLeft</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingLeft}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initPaddingRight","fromProperty":"paddingRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>paddingRight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>paddingRight</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingRight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initPaddingTop","fromProperty":"paddingTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>paddingTop</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>paddingTop</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingTop}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSelectable","fromProperty":"selectable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>selectable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>selectable</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #selectable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initShadow","fromProperty":"shadow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>shadow</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>shadow</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #shadow}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initTabIndex","fromProperty":"tabIndex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>tabIndex</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>tabIndex</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #tabIndex}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initTextColor","fromProperty":"textColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>textColor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>textColor</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #textColor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initToolTip","fromProperty":"toolTip"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>toolTip</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>toolTip</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #toolTip}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initVisibility","fromProperty":"visibility"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>visibility</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>visibility</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #visibility}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initZIndex","fromProperty":"zIndex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>zIndex</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>zIndex</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #zIndex}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.LayoutItem","overriddenFrom":"qx.ui.core.LayoutItem","name":"invalidateLayoutCache"}},{type:"method",attributes:{"name":"invalidateLayoutChildren"},children:[{type:"desc",attributes:{"text":"<p>Resets the cache for children which should be layouted.</p>"}}]},{type:"method",attributes:{"name":"isAnonymous","fromProperty":"anonymous"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>anonymous</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #anonymous}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isDraggable","fromProperty":"draggable"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>draggable</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #draggable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isDroppable","fromProperty":"droppable"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>droppable</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #droppable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isEnabled","fromProperty":"enabled"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>enabled</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.core.LayoutItem","name":"isExcluded"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget is locally excluded.</p>\n\n<p>Note: This method does not respect the hierarchy.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code> when the widget is excluded</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isFocusable","fromProperty":"focusable"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>focusable</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #focusable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isHidden"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget is locally hidden.</p>\n\n<p>Note: This method does not respect the hierarchy.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code> when the widget is hidden</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isKeepActive","fromProperty":"keepActive"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>keepActive</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepActive}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isKeepFocus","fromProperty":"keepFocus"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>keepFocus</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepFocus}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isSelectable","fromProperty":"selectable"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>selectable</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selectable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isTabable"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget is reachable by pressing the <span class=\"caps\">TAB</span> key.</p>\n\n<p>Normally tests for both, the focusable property and a positive or\nundefined tabIndex property. The widget must have a <span class=\"caps\">DOM</span> element\nsince only visible widgets are tabable.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the element is tabable.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isVisible"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget is locally visible.</p>\n\n<p>Note: This method does not respect the hierarchy.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code> when the widget is visible</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"releaseCapture"},children:[{type:"desc",attributes:{"text":"<p>Disables mouse capture mode enabled by {@link #capture}.</p>"}}]},{type:"method",attributes:{"name":"removeState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"state"},children:[{type:"desc",attributes:{"text":"<p>the state to clear.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Clears a state.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.LayoutItem","overriddenFrom":"qx.ui.core.LayoutItem","name":"renderLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"left"}},{type:"param",attributes:{"name":"top"}},{type:"param",attributes:{"name":"width"}},{type:"param",attributes:{"name":"height"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.LayoutItem","overriddenFrom":"qx.ui.core.LayoutItem","name":"renderSeparator"},children:[{type:"params",children:[{type:"param",attributes:{"name":"separator"}},{type:"param",attributes:{"name":"bounds"}}]}]},{type:"method",attributes:{"name":"replaceState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>Previous state</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New state</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Replaces the first state with the second one.</p>\n\n<p>This method is ideal for state transitions e.g. normal => selected.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAnonymous","fromProperty":"anonymous"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>anonymous</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #anonymous}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAppearance","fromProperty":"appearance"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>appearance</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #appearance}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetBackgroundColor","fromProperty":"backgroundColor"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>backgroundColor</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #backgroundColor}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetContextMenu","fromProperty":"contextMenu"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>contextMenu</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #contextMenu}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetCursor","fromProperty":"cursor"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>cursor</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #cursor}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetDecorator","fromProperty":"decorator"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>decorator</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #decorator}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetDraggable","fromProperty":"draggable"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>draggable</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #draggable}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetDroppable","fromProperty":"droppable"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>droppable</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #droppable}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetEnabled","fromProperty":"enabled"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>enabled</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetFocusable","fromProperty":"focusable"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>focusable</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #focusable}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetFont","fromProperty":"font"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>font</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #font}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetKeepActive","fromProperty":"keepActive"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>keepActive</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #keepActive}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetKeepFocus","fromProperty":"keepFocus"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>keepFocus</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #keepFocus}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetOpacity","fromProperty":"opacity"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>opacity</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #opacity}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetPadding","fromProperty":"padding"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>padding</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #padding}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetPaddingBottom","fromProperty":"paddingBottom"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>paddingBottom</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingBottom}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetPaddingLeft","fromProperty":"paddingLeft"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>paddingLeft</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingLeft}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetPaddingRight","fromProperty":"paddingRight"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>paddingRight</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingRight}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetPaddingTop","fromProperty":"paddingTop"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>paddingTop</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingTop}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSelectable","fromProperty":"selectable"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>selectable</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #selectable}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetShadow","fromProperty":"shadow"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>shadow</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #shadow}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetTabIndex","fromProperty":"tabIndex"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>tabIndex</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #tabIndex}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetTextColor","fromProperty":"textColor"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>textColor</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #textColor}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetToolTip","fromProperty":"toolTip"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>toolTip</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #toolTip}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetVisibility","fromProperty":"visibility"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>visibility</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #visibility}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetZIndex","fromProperty":"zIndex"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>zIndex</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #zIndex}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.core.LayoutItem","name":"scheduleLayoutUpdate"},children:[{type:"desc",attributes:{"text":"<p>Marks the layout of this widget as invalid and triggers a layout update.\nThis is a shortcut for <code>qx.ui.core.queue.Layout.add(this);</code>.</p>"}}]},{type:"method",attributes:{"name":"scrollChildIntoView"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>Child to scroll into view</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"alignX"},children:[{type:"desc",attributes:{"text":"<p>Alignment of the item. Allowed values:\n  <code>left</code> or <code>right</code>. Could also be null.\n  Without a given alignment the method tries to scroll the widget\n  with the minimum effort needed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"alignY"},children:[{type:"desc",attributes:{"text":"<p>Alignment of the item. Allowed values:\n  <code>top</code> or <code>bottom</code>. Could also be null.\n  Without a given alignment the method tries to scroll the widget\n  with the minimum effort needed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"true","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the execution should be made\n  directly when possible</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>The method scrolls the given item into view.</p>"}}]},{type:"method",attributes:{"name":"scrollChildIntoViewX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>Child to scroll into view</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"align"},children:[{type:"desc",attributes:{"text":"<p>Alignment of the item. Allowed values:\n  <code>left</code> or <code>right</code>. Could also be null.\n  Without a given alignment the method tries to scroll the widget\n  with the minimum effort needed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"true","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the execution should be made\n  directly when possible</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>The method scrolls the given item into view (x-axis only).</p>"}}]},{type:"method",attributes:{"name":"scrollChildIntoViewY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>Child to scroll into view</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"align"},children:[{type:"desc",attributes:{"text":"<p>Alignment of the element. Allowed values:\n  <code>top</code> or <code>bottom</code>. Could also be null.\n  Without a given alignment the method tries to scroll the widget\n  with the minimum effort needed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"true","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the execution should be made\n  directly when possible</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>The method scrolls the given item into view (y-axis only).</p>"}}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.ui.core.LayoutItem","name":"serialize"}},{type:"method",attributes:{"name":"setAnonymous","fromProperty":"anonymous"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>anonymous</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>anonymous</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #anonymous}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAppearance","fromProperty":"appearance"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>appearance</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>appearance</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #appearance}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setBackgroundColor","fromProperty":"backgroundColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>backgroundColor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>backgroundColor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #backgroundColor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setContextMenu","fromProperty":"contextMenu"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>contextMenu</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>contextMenu</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #contextMenu}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setCursor","fromProperty":"cursor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>cursor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>cursor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cursor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setDecorator","fromProperty":"decorator"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>decorator</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>decorator</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #decorator}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setDomLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Left position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Directly modifies the relative left position in relation\nto the parent element.</p>\n\n<p>Use with caution! This may be used for animations, drag&amp;drop\nor other cases where high performance location manipulation\nis important. Otherwise please use {@link #setUserBounds} instead.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setDomPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"left"},children:[{type:"desc",attributes:{"text":"<p>Left position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"top"},children:[{type:"desc",attributes:{"text":"<p>Top position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Directly modifies the relative left and top position in relation\nto the parent element.</p>\n\n<p>Use with caution! This may be used for animations, drag&amp;drop\nor other cases where high performance location manipulation\nis important. Otherwise please use {@link #setUserBounds} instead.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setDomTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Top position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Directly modifies the relative top position in relation\nto the parent element.</p>\n\n<p>Use with caution! This may be used for animations, drag&amp;drop\nor other cases where high performance location manipulation\nis important. Otherwise please use {@link #setUserBounds} instead.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setDraggable","fromProperty":"draggable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>draggable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>draggable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #draggable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setDroppable","fromProperty":"droppable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>droppable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>droppable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #droppable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setEnabled","fromProperty":"enabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>enabled</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setFocusable","fromProperty":"focusable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>focusable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>focusable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #focusable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setFont","fromProperty":"font"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>font</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>font</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #font}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setKeepActive","fromProperty":"keepActive"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>keepActive</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>keepActive</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepActive}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setKeepFocus","fromProperty":"keepFocus"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>keepFocus</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>keepFocus</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepFocus}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.LayoutItem","overriddenFrom":"qx.ui.core.LayoutItem","name":"setLayoutParent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"parent"}}]}]},{type:"method",attributes:{"name":"setOpacity","fromProperty":"opacity"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>opacity</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>opacity</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #opacity}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setPadding","fromProperty":"padding"},children:[{type:"params",children:[{type:"param",attributes:{"name":"paddingTop"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #paddingTop}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"paddingRight"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #paddingRight}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"paddingBottom"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #paddingBottom}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"paddingLeft"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #paddingLeft}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the values of the property group <code>padding</code>.</p>\n\n<p>This setter supports a shorthand mode compatible with the way margins and paddins are set in <span class=\"caps\">CSS</span>.</p>\n\n<p>For further details take a look at the property definition: {@link #padding}.</p>"}}]},{type:"method",attributes:{"name":"setPaddingBottom","fromProperty":"paddingBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>paddingBottom</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>paddingBottom</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingBottom}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setPaddingLeft","fromProperty":"paddingLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>paddingLeft</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>paddingLeft</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingLeft}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setPaddingRight","fromProperty":"paddingRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>paddingRight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>paddingRight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingRight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setPaddingTop","fromProperty":"paddingTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>paddingTop</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>paddingTop</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #paddingTop}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSelectable","fromProperty":"selectable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>selectable</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>selectable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selectable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setShadow","fromProperty":"shadow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>shadow</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>shadow</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shadow}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setTabIndex","fromProperty":"tabIndex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>tabIndex</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>tabIndex</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #tabIndex}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setTextColor","fromProperty":"textColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>textColor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>textColor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #textColor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setToolTip","fromProperty":"toolTip"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>toolTip</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>toolTip</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #toolTip}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setVisibility","fromProperty":"visibility"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>visibility</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>visibility</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #visibility}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setZIndex","fromProperty":"zIndex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>zIndex</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>zIndex</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #zIndex}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"show"},children:[{type:"desc",attributes:{"text":"<p>Make this widget visible.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"syncAppearance"},children:[{type:"desc",attributes:{"text":"<p>Renders the appearance using the current widget states.</p>\n\n<p>Used exclusively by {qx.ui.core.queue.Appearance}.</p>"}}]},{type:"method",attributes:{"name":"syncWidget"},children:[{type:"desc",attributes:{"text":"<p>This method is called during the flush of the\n{@link qx.ui.core.queue.Widget widget queue}.</p>"}}]},{type:"method",attributes:{"access":"internal","isInternal":"true","name":"tabFocus"},children:[{type:"desc",attributes:{"text":"<p>Focus this widget when using the keyboard. This is\nmainly thought for the advanced qooxdoo keyboard handling\nand should not be used by the application developer.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"toggleAnonymous","fromProperty":"anonymous"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>anonymous</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #anonymous}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleDraggable","fromProperty":"draggable"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>draggable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #draggable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleDroppable","fromProperty":"droppable"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>droppable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #droppable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleEnabled","fromProperty":"enabled"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleFocusable","fromProperty":"focusable"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>focusable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #focusable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleKeepActive","fromProperty":"keepActive"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>keepActive</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepActive}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleKeepFocus","fromProperty":"keepFocus"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>keepFocus</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepFocus}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleSelectable","fromProperty":"selectable"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>selectable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selectable}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"updateAppearance"},children:[{type:"desc",attributes:{"text":"<p>Refreshes the appearance of this widget and all\nregistered child controls.</p>"}}]},{type:"method",attributes:{"access":"internal","isInternal":"true","name":"visualizeBlur"},children:[{type:"desc",attributes:{"text":"<p>Event handler which is executed when the widget lost the focus.</p>\n\n<p>This method is used by the {@link #qx.ui.core.FocusHandler} to\nremove states etc. from a previously focused widget.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"internal","isInternal":"true","name":"visualizeFocus"},children:[{type:"desc",attributes:{"text":"<p>Event handler which is executed when the widget receives the focus.</p>\n\n<p>This method is used by the {@link #qx.ui.core.FocusHandler} to\napply states etc. to a focused widget.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"Boolean","defaultValue":"false","name":"anonymous","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget is anonymous.</p>\n\n<p>Anonymous widgets are ignored in the event hierarchy. This is useful\nfor combined widgets where the internal structure do not have a custom\nappearance with a different styling from the element around. This is\nespecially true for widgets like checkboxes or buttons where the text\nor icon are handled synchronously for state changes to the outer widget.</p>"}}]},{type:"property",attributes:{"name":"appearance","defaultValue":"\"widget\"","event":"changeAppearance","propertyType":"new","apply":"_applyAppearance","check":"String"},children:[{type:"desc",attributes:{"text":"<p>The appearance ID. This ID is used to identify the appearance theme\nentry to use for this widget. This controls the styling of the element.</p>"}}]},{type:"property",attributes:{"name":"backgroundColor","check":"Color","allowNull":"true","propertyType":"new","apply":"_applyBackgroundColor","event":"changeBackgroundColor","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The background color the rendered widget.</p>"}}]},{type:"property",attributes:{"name":"contextMenu","check":"qx.ui.menu.Menu","allowNull":"true","propertyType":"new","apply":"_applyContextMenu","event":"changeContextMenu"},children:[{type:"desc",attributes:{"text":"<p>Whether to show a context menu and which one</p>"}}]},{type:"property",attributes:{"name":"cursor","defaultValue":"null","allowNull":"true","inheritable":"true","propertyType":"new","apply":"_applyCursor","check":"String","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Mapping to native style property cursor.</p>\n\n<p>The name of the cursor to show when the mouse pointer is over the widget.\nThis is any valid CSS2 cursor name defined by W3C.</p>\n\n<p>The following values are possible crossbrowser:\n<ul><li>default</li>\n<li>crosshair</li>\n<li>pointer</li>\n<li>move</li>\n<li>n-resize</li>\n<li>ne-resize</li>\n<li>e-resize</li>\n<li>se-resize</li>\n<li>s-resize</li>\n<li>sw-resize</li>\n<li>w-resize</li>\n<li>nw-resize</li>\n<li>text</li>\n<li>wait</li>\n<li>help </li>\n</ul></p>"}}]},{type:"property",attributes:{"name":"decorator","defaultValue":"null","event":"changeDecorator","allowNull":"true","propertyType":"new","apply":"_applyDecorator","check":"Decorator","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The decorator property points to an object, which is responsible\nfor drawing the widget&#8217;s decoration, e.g. border, background or shadow</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyDraggable","defaultValue":"false","name":"draggable","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget acts as a source for drag&amp;drop operations</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyDroppable","defaultValue":"false","name":"droppable","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget acts as a target for drag&amp;drop operations</p>"}}]},{type:"property",attributes:{"name":"enabled","defaultValue":"true","check":"Boolean","inheritable":"true","propertyType":"new","apply":"_applyEnabled","event":"changeEnabled"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget is enabled. Disabled widgets are usually grayed out\nand do not process user created events. While in the disabled state most\nuser input events are blocked. Only the {@link #mouseover} and\n{@link #mouseout} events will be dispatched.</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyFocusable","defaultValue":"false","name":"focusable","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget is focusable e.g. rendering a focus border and visualize\nas active element.</p>\n\n<p>See also {#isTabable} which allows runtime checks for <code>isChecked</code>\nor other stuff to test whether the widget is reachable via the <span class=\"caps\">TAB</span> key.</p>"}}]},{type:"property",attributes:{"name":"font","event":"changeFont","allowNull":"true","inheritable":"true","propertyType":"new","apply":"_applyFont","check":"Font","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The font property describes how to paint the font on the widget.</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyKeepActive","defaultValue":"false","name":"keepActive","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>If this property if enabled, the widget and all of its child widgets\nwill never get activated. The activation keeps at the currently\nactivated widget.</p>\n\n<p>This is mainly useful for widget authors. Please use with caution!</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyKeepFocus","defaultValue":"false","name":"keepFocus","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>If this property if enabled, the widget and all of its child widgets\nwill never get focused. The focus keeps at the currently\nfocused widget.</p>\n\n<p>This only works for widgets which are not {@link focusable}.</p>\n\n<p>This is mainly useful for widget authors. Please use with caution!</p>"}}]},{type:"property",attributes:{"name":"opacity","defaultValue":"null","allowNull":"true","propertyType":"new","apply":"_applyOpacity","check":"Number","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Mapping to native style property opacity.</p>\n\n<p>The uniform opacity setting to be applied across an entire object. Behaves like the new <span class=\"caps\">CSS</span>-3 Property.\n Any values outside the range 0.0 (fully transparent) to 1.0 (fully opaque) will be clamped to this range.</p>"}}]},{type:"property",attributes:{"mode":"shorthand","group":"\"paddingTop\",\"paddingRight\",\"paddingBottom\",\"paddingLeft\"","name":"padding","themeable":"true","propertyType":"group"},children:[{type:"desc",attributes:{"text":"<p>The &#8216;padding&#8217; property is a shorthand property for setting &#8216;paddingTop&#8217;,\n&#8216;paddingRight&#8217;, &#8216;paddingBottom&#8217; and &#8216;paddingLeft&#8217; at the same time.</p>\n\n<p>If four values are specified they apply to top, right, bottom and left respectively.\nIf there is only one value, it applies to all sides, if there are two or three,\nthe missing values are taken from the opposite side.</p>"}}]},{type:"property",attributes:{"name":"paddingBottom","defaultValue":"0","propertyType":"new","apply":"_applyPadding","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Padding of the widget (bottom)</p>"}}]},{type:"property",attributes:{"name":"paddingLeft","defaultValue":"0","propertyType":"new","apply":"_applyPadding","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Padding of the widget (left)</p>"}}]},{type:"property",attributes:{"name":"paddingRight","defaultValue":"0","propertyType":"new","apply":"_applyPadding","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Padding of the widget (right)</p>"}}]},{type:"property",attributes:{"name":"paddingTop","defaultValue":"0","propertyType":"new","apply":"_applyPadding","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Padding of the widget (top)</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applySelectable","defaultValue":"false","name":"selectable","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget contains content which may be selected by the user.</p>\n\n<p>Normally only useful for forms fields, longer texts/documents, editors, etc.</p>"}}]},{type:"property",attributes:{"name":"shadow","defaultValue":"null","event":"changeShadow","allowNull":"true","propertyType":"new","apply":"_applyShadow","check":"Decorator","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The decorator used to render the widget&#8217;s outline/shadow. The decorator&#8217;s\ninsets are interpreted as the amount of pixels the shadow extends the\nwidget&#8217;s size.</p>\n\n<p>Note that shadows work only properly in top level widgets like menus, windows\nor tooltips. If used in inner widgets the shadow may not be cut by the\nparent widget.</p>"}}]},{type:"property",attributes:{"allowNull":"true","apply":"_applyTabIndex","check":"Integer","name":"tabIndex","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Defines the tab index of an widget. If widgets with tab indexes are part\nof the current focus root these elements are sorted in first priority. Afterwards\nthe sorting continues by rendered position, zIndex and other criteria.</p>\n\n<p>Please note: The value must be between 1 and 32000.</p>"}}]},{type:"property",attributes:{"name":"textColor","event":"changeTextColor","allowNull":"true","inheritable":"true","propertyType":"new","apply":"_applyTextColor","check":"Color","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The text color the rendered widget.</p>"}}]},{type:"property",attributes:{"check":"qx.ui.tooltip.ToolTip","allowNull":"true","name":"toolTip","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Contains the tooltip object connected to the widget.</p>"}}]},{type:"property",attributes:{"name":"visibility","defaultValue":"\"visible\"","propertyType":"new","apply":"_applyVisibility","possibleValues":"\"visible\",\"hidden\",\"excluded\"","event":"changeVisibility"},children:[{type:"desc",attributes:{"text":"<p>Controls the visibility. Valid values are:</p>\n\n<ul>\n  <li><b>visible</b>: Render the widget</li>\n  <li><b>hidden</b>: Hide the widget but don't relayout the widget's parent.</li>\n  <li><b>excluded</b>: Hide the widget and relayout the parent as if the\n    widget was not a child of its parent.</li>\n</ul>"}}]},{type:"property",attributes:{"name":"zIndex","defaultValue":"null","event":"changeZIndex","allowNull":"true","propertyType":"new","apply":"_applyZIndex","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The z-index property sets the stack order of an element. An element with\ngreater stack order is always in front of another element with lower stack order.</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"type":"Boolean","name":"DEBUG","value":"false"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget should print out hints and debug messages</p>"}}]}]},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"contains"},children:[{type:"params",children:[{type:"param",attributes:{"name":"parent"},children:[{type:"desc",attributes:{"text":"<p>The parent widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]},{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>The child widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the &#8220;parent&#8221; widget contains the the &#8220;child&#8221; widget.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether one of the &#8220;child&#8221;&#8216;s parents is &#8220;parent&#8221;</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getWidgetByElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">DOM</span> element to search the widget for.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the widget, which contains the given <span class=\"caps\">DOM</span> element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The widget containing the element.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]}]}]}