{type:"class",attributes:{"isAbstract":"true","name":"Abstract","packageName":"qx.ui.core.selection","superClass":"qx.core.Object","childClasses":"qx.ui.core.selection.Widget","fullName":"qx.ui.core.selection.Abstract","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Generic selection manager to bring rich desktop like selection behavior\nto widgets and low-level interactive controls.</p>\n\n<p>The selection handling supports both Shift and Ctrl/Meta modifies like\nknown from native applications.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"}}]},{type:"events",children:[{type:"event",attributes:{"name":"changeSelection"},children:[{type:"desc",attributes:{"text":"<p>Fires after the selection was modified. Contains the selection under the data property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__rangeToMap"},children:[{type:"params",children:[{type:"param",attributes:{"name":"range"},children:[{type:"desc",attributes:{"text":"<p>List of selectable items</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"desc",attributes:{"text":"<p>Internal method to convert a range to a map of hash\ncodes for faster lookup during selection compare routines.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_addToSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds an item to the current selection.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.selection.Abstract#mode","name":"_applyMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>mode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyMode}.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_autoSelect"},children:[{type:"desc",attributes:{"text":"<p>Automatically selects items based on the mouse movement during a drag selection</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_capture"},children:[{type:"desc",attributes:{"text":"<p>Enables capturing of the container.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_cleanup"},children:[{type:"desc",attributes:{"text":"<p>Stops all timers, release capture etc. to cleanup drag selection</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_clearSelection"},children:[{type:"desc",attributes:{"text":"<p>Clears current selection</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_deselectItemRange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item1"},children:[{type:"desc",attributes:{"text":"<p>Start with this item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"item2"},children:[{type:"desc",attributes:{"text":"<p>End with this item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Deselect all items between <code>item1</code> and <code>item2</code>.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_fireChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"context"},children:[{type:"desc",attributes:{"text":"<p>One of <code>click</code>, <code>quick</code>,\n   <code>drag</code> or <code>key</code> or <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Fires the selection change event if the selection has\nbeen modified.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_getAnchorItem"},children:[{type:"desc",attributes:{"text":"<p>Returns the current anchor item. This is the item which is the starting\npoint for all range selections. Normally this is the item which was\nclicked on the last time without any modifier keys pressed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The anchor item or <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getDimension"},children:[{type:"desc",attributes:{"text":"<p>Returns the dimension of the container (available scrolling space).</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Map with the keys <code>width</code> and <code>height</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getFirstSelectable"},children:[{type:"desc",attributes:{"text":"<p>Returns the first selectable item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The first selectable item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getLastSelectable"},children:[{type:"desc",attributes:{"text":"<p>Returns the last selectable item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The last selectable item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getLeadItem"},children:[{type:"desc",attributes:{"text":"<p>Returns the current lead item. Generally the item which was last modified\nby the user (clicked on etc.)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The lead item or <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getLocation"},children:[{type:"desc",attributes:{"text":"<p>Returns the location of the container</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Map with the keys <code>top</code>, <code>right</code>,\n   <code>bottom</code> and <code>left</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getPage"},children:[{type:"params",children:[{type:"param",attributes:{"name":"lead"},children:[{type:"desc",attributes:{"text":"<p>The current lead item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"up"},children:[{type:"desc",attributes:{"text":"<p>Which page key was pressed:\n  <code>up</code> or <code>down</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the item which should be selected on pageUp/pageDown.</p>\n\n<p>May also scroll to the needed position.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getRelatedSelectable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"relation"},children:[{type:"desc",attributes:{"text":"<p>A valid relation: <code>above</code>,\n   <code>right</code>, <code>under</code> or <code>left</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a selectable item which is related to the given\n<code>item</code> through the value of <code>relation</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The related item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getScroll"},children:[{type:"desc",attributes:{"text":"<p>Returns the scroll position of the container.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Map with the keys <code>left</code> and <code>top</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getSelectableFromTarget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>The event target</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Finds the selectable instance from any given target inside\nthe connected widget.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The resulting selectable</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getSelectableLocationX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the relative (to the container) horizontal location of the given item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A map with the keys <code>left</code> and <code>right</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getSelectableLocationY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the relative (to the container) horizontal location of the given item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A map with the keys <code>top</code> and <code>bottom</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getSelectableRange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item1"},children:[{type:"desc",attributes:{"text":"<p>First item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"item2"},children:[{type:"desc",attributes:{"text":"<p>Second item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns all selectable items between the two given items.</p>\n\n<p>The items could be given in any order.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>List of items</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getSelectables"},children:[{type:"desc",attributes:{"text":"<p>Returns all selectable items of the container.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A list of items</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getSelectedItem"},children:[{type:"desc",attributes:{"text":"<p>Returns the first selected item. Only makes sense\nwhen using manager in single selection mode.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The selected item (or <code>null</code>)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_isSelectable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the given item is selectable.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> when the item is selectable"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Timer event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for timer used by drag selection</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_releaseCapture"},children:[{type:"desc",attributes:{"text":"<p>Releases capturing of the container</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_removeFromSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the given item from the current selection.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_scrollBy"},children:[{type:"params",children:[{type:"param",attributes:{"name":"xoff"},children:[{type:"desc",attributes:{"text":"<p>Horizontal offset to scroll by</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"yoff"},children:[{type:"desc",attributes:{"text":"<p>Vertical offset to scroll by</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls by the given offset</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_scrollItemIntoView"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls the given item into the view (make it visible)</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_selectableToHashCode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a unique hashcode for the given item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A valid hashcode</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_selectAllItems"},children:[{type:"desc",attributes:{"text":"<p>Adds all items to the selection</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_selectItemRange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item1"},children:[{type:"desc",attributes:{"text":"<p>Start with this item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"item2"},children:[{type:"desc",attributes:{"text":"<p>End with this item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"extend"},children:[{type:"desc",attributes:{"text":"<p>Whether the current\n   selection should be replaced or extended.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Select a range from <code>item1</code> to <code>item2</code>.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_setAnchorItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Any valid item or <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the anchor item. This is the item which is the starting\npoint for all range selections. Normally this is the item which was\nclicked on the last time without any modifier keys pressed.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_setLeadItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Any valid item or <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the lead item. Generally the item which was last modified\nby the user (clicked on etc.)</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_setSelectedItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any valid selectable item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Replace current selection with given item.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_styleSelectable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Item to modify</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>Any of <code>selected</code>, <code>anchor</code> or <code>lead</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"enabled"},children:[{type:"desc",attributes:{"text":"<p>Whether the given style should be added or removed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Updates the style (appearance) of the given item.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_toggleInSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Toggles the item e.g. remove it when already selected\nor select it when currently not.</p>"}}]},{type:"method",attributes:{"name":"addItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any valid item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds the given item to the existing selection.</p>\n\n<p>Use {@link #selectItem} instead if you want to replace\nthe current selection.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"clearSelection"},children:[{type:"desc",attributes:{"text":"<p>Clears the whole selection at once. Also\nresets the lead and anchor items and their\nstyles.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getDrag","fromProperty":"drag"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>drag</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #drag}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>drag</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMode","fromProperty":"mode"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>mode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #mode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>mode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getQuick","fromProperty":"quick"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>quick</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #quick}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>quick</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSelectedItem"},children:[{type:"desc",attributes:{"text":"<p>Get the selected item. This method does only work in <code>single</code>\nselection mode.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The selected item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"name":"getSelection"},children:[{type:"desc",attributes:{"text":"<p>Returns an array of currently selected items.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>List of items.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object","dimensions":"1"}}]}]}]},{type:"method",attributes:{"name":"getSelectionContext"},children:[{type:"desc",attributes:{"text":"<p>Returns the selection context. One of <code>click</code>,\n<code>quick</code>, <code>drag</code> or <code>key</code> or\n<code>null</code>.</p>"}}]},{type:"method",attributes:{"name":"getSortedSelection"},children:[{type:"desc",attributes:{"text":"<p>Returns the selection sorted by the index in the\ncontainer of the selection (the assigned widget)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Sorted list of items</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object","dimensions":"1"}}]}]}]},{type:"method",attributes:{"name":"handleAddItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method should be connected to the <code>addItem</code> event\nof the managed object.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"handleKeyPress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"event"},children:[{type:"desc",attributes:{"text":"<p>A valid key sequence event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method should be connected to the <code>keypress</code> event\nof the managed object.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"handleLoseCapture"},children:[{type:"params",children:[{type:"param",attributes:{"name":"event"},children:[{type:"desc",attributes:{"text":"<p>A valid mouse event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method should be connected to the <code>losecapture</code> event\nof the managed object.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"handleMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"event"},children:[{type:"desc",attributes:{"text":"<p>A valid mouse event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method should be connected to the <code>mousedown</code> event\nof the managed object.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"handleMouseMove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"event"},children:[{type:"desc",attributes:{"text":"<p>A valid mouse event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method should be connected to the <code>mousemove</code> event\nof the managed object.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"handleMouseOver"},children:[{type:"params",children:[{type:"param",attributes:{"name":"event"},children:[{type:"desc",attributes:{"text":"<p>A valid mouse event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method should be connected to the <code>mouseover</code> event\nof the managed object.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"handleMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"event"},children:[{type:"desc",attributes:{"text":"<p>A valid mouse event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method should be connected to the <code>mouseup</code> event\nof the managed object.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"handleRemoveItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method should be connected to the <code>removeItem</code> event\nof the managed object.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initDrag","fromProperty":"drag"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>drag</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>drag</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #drag}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMode","fromProperty":"mode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>mode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>mode</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #mode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initQuick","fromProperty":"quick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>quick</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>quick</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #quick}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isDrag","fromProperty":"drag"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>drag</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #drag}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isItemSelected"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any valid selectable item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Detects whether the given item is currently selected.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the item is selected</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isQuick","fromProperty":"quick"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>quick</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #quick}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isSelectionEmpty"},children:[{type:"desc",attributes:{"text":"<p>Whether the selection is empty</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the selection is empty</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"removeItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any valid item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the given item from the selection.</p>\n\n<p>Use {@link #clearSelection} when you want to clear\nthe whole selection at once.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"replaceSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"items"},children:[{type:"desc",attributes:{"text":"<p>Items to select</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Replaces current selection with the given items</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetDrag","fromProperty":"drag"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>drag</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #drag}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMode","fromProperty":"mode"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>mode</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #mode}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetQuick","fromProperty":"quick"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>quick</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #quick}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"selectAll"},children:[{type:"desc",attributes:{"text":"<p>Selects all items of the managed object.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"selectItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any valid item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Selects the given item. Replaces current selection\ncompletely with the new item.</p>\n\n<p>Use {@link #addItem} instead if you want to add new\nitems to an existing selection.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"selectItemRange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"begin"},children:[{type:"desc",attributes:{"text":"<p>Item to start with</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"end"},children:[{type:"desc",attributes:{"text":"<p>Item to end at</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Selects an item range between two given items.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setDrag","fromProperty":"drag"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>drag</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>drag</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #drag}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMode","fromProperty":"mode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>mode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>mode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #mode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setQuick","fromProperty":"quick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>quick</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>quick</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #quick}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleDrag","fromProperty":"drag"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>drag</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #drag}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleQuick","fromProperty":"quick"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>quick</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #quick}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"Boolean","defaultValue":"false","name":"drag","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Enable drag selection (multi selection of items through\ndragging the mouse in pressed states).</p>\n\n<p>Only possible for the modes <code>multi</code> and <code>additive</code></p>"}}]},{type:"property",attributes:{"apply":"_applyMode","defaultValue":"\"single\"","name":"mode","possibleValues":"\"single\",\"multi\",\"additive\",\"one\"","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Selects the selection mode to use.</p>\n\n<ul>\n<li>single: One or no element is selected</li>\n<li>multi: Multi items could be selected. Also allows empty selections.</li>\n<li>additive: Easy Web-2.0 selection mode. Allows multiple selections without modifier keys.</li>\n<li>one: If possible always exactly one item is selected</li>\n</ul>"}}]},{type:"property",attributes:{"check":"Boolean","defaultValue":"false","name":"quick","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Enable quick selection mode, where no click is needed to change the selection.</p>\n\n<p>Only possible for the modes <code>single</code> and <code>one</code>.</p>"}}]}]}]}