{type:"class",attributes:{"isStatic":"true","name":"Label","packageName":"qx.bom","fullName":"qx.bom.Label","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Cross browser abstractions to work with labels.</p>"}},{type:"methods-static",children:[{type:"method",attributes:{"access":"private","isStatic":"true","name":"__getStyles"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"false","name":"html"},children:[{type:"desc",attributes:{"text":"<p>Whether <span class=\"caps\">HTML</span> markup should be used.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a map of all styles which should be applied as\na basic set.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Initial styles which should be applied to a label element.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"access":"private","isStatic":"true","name":"__prepareHtml"},children:[{type:"desc",attributes:{"text":"<p>Generates the helper <span class=\"caps\">DOM</span> element for <span class=\"caps\">HTML</span> measuring</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Helper <span class=\"caps\">DOM</span> element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"method",attributes:{"access":"private","isStatic":"true","name":"__prepareText"},children:[{type:"desc",attributes:{"text":"<p>Generates the helper <span class=\"caps\">DOM</span> element for text measuring</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Helper <span class=\"caps\">DOM</span> element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"create"},children:[{type:"params",children:[{type:"param",attributes:{"name":"content"},children:[{type:"desc",attributes:{"text":"<p>Content of the label</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"html"},children:[{type:"desc",attributes:{"text":"<p>Whether <span class=\"caps\">HTML</span> markup should be used.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"win"},children:[{type:"desc",attributes:{"text":"<p>Window to create the element for</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Window"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates a label.</p>\n\n<p>The default mode is &#8216;text&#8217; which means that the overlapping text is cutted of\nusing the ellipsis sign automatically. Text wrapping is disabled in this mode\nas well. Spaces are normalized. Umlauts and other special symbols are only\nallowed in unicode mode as normal characters.</p>\n\n<p>In the <span class=\"caps\">HTML</span> mode you can insert any <span class=\"caps\">HTML</span>, but loose the capability to cut\nof overlapping text. Automatic text wrapping is enabled by default.</p>\n\n<p>It is not possible to modify the mode afterwards.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The created iframe node</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getContent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> element to query.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the content of the element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Content stored in the element.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getHtmlSize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"content"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">HTML</span> markup to measure</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"styles"},children:[{type:"desc",attributes:{"text":"<p>Optional styles to apply</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>To support width for height it is possible to limit the width</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the preferred dimensions of the given <span class=\"caps\">HTML</span> content.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A map with preferred <code>width</code> and <code>height</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getTextSize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"text"},children:[{type:"desc",attributes:{"text":"<p>The text to measure</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"styles"},children:[{type:"desc",attributes:{"text":"<p>Optional styles to apply</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the preferred dimensions of the given text.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A map with preferred <code>width</code> and <code>height</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"setContent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> element to modify.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Content to insert.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the content of the element.</p>\n\n<p>The possibilities of the value depends on the mode\ndefined using {@see #create}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]}]}