{type:"class",attributes:{"name":"Native","packageName":"qx.event.type","superClass":"qx.event.type.Event","childClasses":"qx.event.type.Dom","fullName":"qx.event.type.Native","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Common base class for all native events (DOM events, IO events, ...).</p>"}},{type:"methods",children:[{type:"method",attributes:{"docFrom":"qx.event.type.Event","overriddenFrom":"qx.event.type.Event","name":"clone"},children:[{type:"params",children:[{type:"param",attributes:{"name":"embryo"}}]}]},{type:"method",attributes:{"name":"getNativeEvent"},children:[{type:"desc",attributes:{"text":"<p>Get the native browser event object of this event.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The native browser event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]}]},{type:"method",attributes:{"name":"getReturnValue"},children:[{type:"desc",attributes:{"text":"<p>Retrieves the event&#8217;s return value.</p>"}},{type:"return",attributes:{"defaultValue":"null"},children:[{type:"desc",attributes:{"text":"<p>The return value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.event.type.Event","name":"init"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nativeEvent"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">DOM</span> event to use</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]},{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>The event target</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"relatedTarget"},children:[{type:"desc",attributes:{"text":"<p>The related event target</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"canBubble"},children:[{type:"desc",attributes:{"text":"<p>Whether or not the event is a bubbling event.\n    If the event is bubbling, the bubbling can be stopped using\n    {@link #stopPropagation}</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"cancelable"},children:[{type:"desc",attributes:{"text":"<p>Whether or not an event can have its default\n    action prevented. The default action can either be the browser&#8217;s\n    default action of a native event (e.g. open the context menu on a\n    right click) or the default action of a qooxdoo class (e.g. close\n    the window widget). The default action can be prevented by calling\n    {@link #preventDefault}</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Initialize the fields of the event. The event must be initialized before\nit can be dispatched.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The initialized event instance</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.event.type.Event","name":"preventDefault"},children:[{type:"desc",attributes:{"text":"<p>Prevent browser default behavior, e.g. opening the context menu, ...</p>"}}]},{type:"method",attributes:{"name":"setReturnValue"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"null","name":"returnValue"},children:[{type:"desc",attributes:{"text":"<p>Return value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the event&#8217;s return value. If the return value is set in a\nbeforeunload event, the user will be asked by the browser, whether\nhe really wants to leave the page. The return string will be displayed in\nthe message box.</p>"}}]},{type:"method",attributes:{"name":"stop"},children:[{type:"desc",attributes:{"text":"<p>Stops event from all further processing. Execute this when the\ncurrent handler should have &#8220;exclusive rights&#8221; to the event\nand no further reaction by anyone else should happen.</p>"}}]}]}]}