{type:"class",attributes:{"name":"Base","packageName":"qx.fx","superClass":"qx.core.Object","childClasses":"qx.fx.effect.combination.ColorFlow,qx.fx.effect.combination.Drop,qx.fx.effect.combination.Fold,qx.fx.effect.combination.Grow,qx.fx.effect.combination.Puff,qx.fx.effect.combination.Pulsate,qx.fx.effect.combination.Shake,qx.fx.effect.combination.Shrink,qx.fx.effect.combination.Switch,qx.fx.effect.core.Consecutive,qx.fx.effect.core.Fade,qx.fx.effect.core.Highlight,qx.fx.effect.core.Move,qx.fx.effect.core.Parallel,qx.fx.effect.core.Scale,qx.fx.effect.core.Scroll","fullName":"qx.fx.Base","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Basic class for all core and combination effects.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">DOM</span> element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]}]}]},{type:"events",children:[{type:"event",attributes:{"name":"finish"},children:[{type:"desc",attributes:{"text":"<p>This event is fired when effect ends.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"setup"},children:[{type:"desc",attributes:{"text":"<p>This event is fired when effect starts.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"update"},children:[{type:"desc",attributes:{"text":"<p>This event is fired every time a frame is rendered.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.fx.Base#duration","name":"_applyDuration"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Current value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>Previous value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Apply method for duration. Should be overwritten if needed.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_getElement"},children:[{type:"desc",attributes:{"text":"<p>Returns the effect&#8217;s <span class=\"caps\">DOM</span> element</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_setElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>the element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the element to be animated.</p>"}}]},{type:"method",attributes:{"name":"afertSetup"},children:[{type:"desc",attributes:{"text":"<p>This internal function is after\nthe effect&#8217;s &#8220;setup&#8221; method has been called.</p>"}}]},{type:"method",attributes:{"name":"afterFinish"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called after\nthe effect actually has ended.</p>"}}]},{type:"method",attributes:{"name":"afterFinishInternal"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called before\n&#8220;afterFinished&#8221; and after the effect\nactually has ended.</p>"}}]},{type:"method",attributes:{"name":"afterSetupInternal"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called before\n&#8220;afterSetup&#8221; and after the effect&#8217;s\n&#8220;setup&#8221; method has been called.</p>"}}]},{type:"method",attributes:{"name":"afterUpdate"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called\neach time after the effect&#8217;s &#8220;update&#8221; method is called.</p>"}}]},{type:"method",attributes:{"name":"afterUpdateInternal"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called before\n&#8220;afterUpdate&#8221; and each time after\nthe effect&#8217;s &#8220;update&#8221; method is called.</p>"}}]},{type:"method",attributes:{"name":"beforeFinish"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called before\nthe effect actually ends.</p>"}}]},{type:"method",attributes:{"name":"beforeFinishInternal"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called before\n&#8220;beforeFinished&#8221; and before the effect\nactually ends.</p>"}}]},{type:"method",attributes:{"name":"beforeSetup"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called before\nthe effect&#8217;s &#8220;setup&#8221; method gets called.</p>"}}]},{type:"method",attributes:{"name":"beforeSetupInternal"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called before\n&#8220;beforeSetup&#8221; and before the effect&#8217;s\n&#8220;setup&#8221; method gets called.</p>"}}]},{type:"method",attributes:{"name":"beforeStart"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called\nbefore the effect actually starts.</p>"}}]},{type:"method",attributes:{"name":"beforeStartInternal"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called before\n&#8220;beforeStartInternal&#8221; and before the effect\nactually starts.</p>"}}]},{type:"method",attributes:{"name":"beforeUpdate"},children:[{type:"desc",attributes:{"text":"<p>This internal function is each time before\nthe effect&#8217;s &#8220;update&#8221; method is called.</p>"}}]},{type:"method",attributes:{"name":"beforeUpdateInternal"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called before\n&#8220;beforeUpdateInternal&#8221; and each time before\nthe effect&#8217;s &#8220;update&#8221; method is called.</p>"}}]},{type:"method",attributes:{"name":"cancel"},children:[{type:"desc",attributes:{"text":"<p>Removes effect from queue and sets state to finished.</p>"}}]},{type:"method",attributes:{"name":"end"},children:[{type:"desc",attributes:{"text":"<p>Ends the effect</p>"}}]},{type:"method",attributes:{"name":"finish"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called\nwhen the effect has finished.</p>\n\n<p>Fires &#8220;finish&#8221; event.</p>"}}]},{type:"method",attributes:{"name":"getDelay","fromProperty":"delay"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>delay</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delay}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>delay</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getDuration","fromProperty":"duration"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>duration</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #duration}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>duration</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getFps","fromProperty":"fps"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>fps</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #fps}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>fps</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getFrom","fromProperty":"from"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>from</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #from}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>from</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getQueue","fromProperty":"queue"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>queue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #queue}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>queue</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSync","fromProperty":"sync"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>sync</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sync}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>sync</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getTo","fromProperty":"to"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>to</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #to}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>to</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getTransition","fromProperty":"transition"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>transition</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #transition}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>transition</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"init"},children:[{type:"desc",attributes:{"text":"<p>This internal function is used to update\nproperties before the effect starts.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"initDelay","fromProperty":"delay"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>delay</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>delay</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #delay}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initDuration","fromProperty":"duration"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>duration</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>duration</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #duration}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initFps","fromProperty":"fps"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>fps</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>fps</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #fps}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initFrom","fromProperty":"from"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>from</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>from</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #from}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initQueue","fromProperty":"queue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>queue</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>queue</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #queue}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSync","fromProperty":"sync"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>sync</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>sync</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #sync}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initTo","fromProperty":"to"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>to</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>to</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #to}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initTransition","fromProperty":"transition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>transition</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>transition</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #transition}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isSync","fromProperty":"sync"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>sync</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sync}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"loop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"timePos"},children:[{type:"desc",attributes:{"text":"<p>Effect&#8217;s step on duration between\n0 (just started) and 1 (finished). The longer the duration\nis, the lower is each step.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Invokes update() if effect&#8217;s remaining duration is\nbigger than zero, or ends the effect otherwise.</p>"}}]},{type:"method",attributes:{"name":"render"},children:[{type:"params",children:[{type:"param",attributes:{"name":"pos"},children:[{type:"desc",attributes:{"text":"<p>Effect&#8217;s step on duration between\n0 (just started) and 1 (finished). The longer the duration\nis, the lower is each step.</p>\n\n<p>Fires &#8220;update&#8221; event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls update(), or invokes the effect, if not running.</p>"}}]},{type:"method",attributes:{"name":"resetDelay","fromProperty":"delay"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>delay</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #delay}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetDuration","fromProperty":"duration"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>duration</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #duration}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetFps","fromProperty":"fps"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>fps</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #fps}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetFrom","fromProperty":"from"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>from</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #from}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetQueue","fromProperty":"queue"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>queue</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #queue}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSync","fromProperty":"sync"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>sync</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #sync}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetTo","fromProperty":"to"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>to</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #to}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetTransition","fromProperty":"transition"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>transition</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #transition}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setDelay","fromProperty":"delay"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>delay</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>delay</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delay}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setDuration","fromProperty":"duration"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>duration</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>duration</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #duration}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setFps","fromProperty":"fps"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>fps</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>fps</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #fps}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setFrom","fromProperty":"from"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>from</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>from</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #from}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setQueue","fromProperty":"queue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>queue</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>queue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #queue}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSync","fromProperty":"sync"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>sync</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>sync</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sync}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setTo","fromProperty":"to"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>to</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>to</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #to}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setTransition","fromProperty":"transition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>transition</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>transition</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #transition}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setup"},children:[{type:"desc",attributes:{"text":"<p>This internal function is called\nbefore the effect starts to configure\nthe element or prepare other effects.</p>\n\n<p>Fires &#8220;setup&#8221; event.</p>"}}]},{type:"method",attributes:{"name":"start"},children:[{type:"desc",attributes:{"text":"<p>Starts the effect</p>"}}]},{type:"method",attributes:{"name":"toggleSync","fromProperty":"sync"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>sync</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sync}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"update"},children:[{type:"params",children:[{type:"param",attributes:{"name":"position"},children:[{type:"desc",attributes:{"text":"<p>Animation setup\nas Number between 0 and 1.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>This internal function is called\neach time the effect performs an\nstep of the animation.</p>\n\n<p>Sub classes will overwrite this to\nperform the actual changes on element\nproperties.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"Number","defaultValue":"0.0","name":"delay","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Number of seconds the effect should wait before start.</p>"}}]},{type:"property",attributes:{"check":"Number","apply":"_applyDuration","defaultValue":"0.5","name":"duration","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Number of seconds the effect should run.</p>"}}]},{type:"property",attributes:{"check":"Number","defaultValue":"100","name":"fps","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Number frames per seconds the effect should be rendered with.</p>"}}]},{type:"property",attributes:{"check":"Number","defaultValue":"0","name":"from","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Initial value of effect-specific property (color, opacity, position, etc.).</p>"}}]},{type:"property",attributes:{"check":"Object","name":"queue","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Name of queue the effect should run in.</p>"}}]},{type:"property",attributes:{"check":"Boolean","defaultValue":"false","name":"sync","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Flag indicating if effect should run parallel with others.</p>"}}]},{type:"property",attributes:{"check":"Number","defaultValue":"1","name":"to","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>End value of effect-specific property. When this value is reached, the effect will end.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"linear\",\"easeInQuad\",\"easeOutQuad\",\"sinodial\",\"reverse\",\"flicker\",\"wobble\",\"pulse\",\"spring\",\"none\",\"full\"","defaultValue":"\"linear\"","name":"transition","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Function which modifies the effect-specific property during the transtion\nbetween &#8220;from&#8221; and &#8220;to&#8221; value.</p>"}}]}]}]}