{type:"class",attributes:{"name":"RequestQueue","isInternal":"true","packageName":"qx.io.remote","access":"internal","superClass":"qx.core.Object","isSingleton":"true","fullName":"qx.io.remote.RequestQueue","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Handles scheduling of requests to be sent to a server.</p>\n\n<p>This class is a singleton and is used by qx.io.remote.Request to schedule its\nrequests. It should not be used directly.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"}}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.io.remote.RequestQueue#enabled","name":"_applyEnabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyEnabled}.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_check"},children:[{type:"desc",attributes:{"text":"<p>Checks the queue if any request is left to send and uses the transport\nlayer to send the open requests.\nThis method calls itself until every request in the queue is send.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_debug"},children:[{type:"desc",attributes:{"text":"<p>Generates debug output</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_oncompleted"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listens for the &#8220;completed&#8221; event of the transport object and decreases\nthe counter for active requests.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_oninterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listens for the &#8220;interval&#8221; event of the transport object and checks\nif the active requests are timed out.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onsending"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listens for the &#8220;sending&#8221; event of the transport object and increases\nthe counter for active requests.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTransport"},children:[{type:"desc",attributes:{"text":"<p>Transport object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.io.remote.Exchange"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes a transport object from the active queue and disposes the\ntransport object in order stop the request.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"abort"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRequest"},children:[{type:"desc",attributes:{"text":"<p>The request</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Remove the request from the pending requests queue.</p>\n\n<p>The underlying transport of the request is forced into the aborted\n state (&#8220;aborted&#8221;) and listeners of the &#8220;aborted&#8221;\n signal are notified about the event. If the request isn&#8217;t in the\n pending requests queue, this method is a noop.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRequest"},children:[{type:"desc",attributes:{"text":"<p>The request</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add the request to the pending requests queue.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getDefaultTimeout","fromProperty":"defaultTimeout"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>defaultTimeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #defaultTimeout}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>defaultTimeout</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getEnabled","fromProperty":"enabled"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>enabled</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMaxConcurrentRequests","fromProperty":"maxConcurrentRequests"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>maxConcurrentRequests</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxConcurrentRequests}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>maxConcurrentRequests</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMaxTotalRequests","fromProperty":"maxTotalRequests"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>maxTotalRequests</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxTotalRequests}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>maxTotalRequests</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initDefaultTimeout","fromProperty":"defaultTimeout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>defaultTimeout</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>defaultTimeout</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #defaultTimeout}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initEnabled","fromProperty":"enabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>enabled</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>enabled</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMaxConcurrentRequests","fromProperty":"maxConcurrentRequests"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>maxConcurrentRequests</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>maxConcurrentRequests</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #maxConcurrentRequests}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMaxTotalRequests","fromProperty":"maxTotalRequests"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>maxTotalRequests</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>maxTotalRequests</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #maxTotalRequests}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isEnabled","fromProperty":"enabled"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>enabled</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"resetDefaultTimeout","fromProperty":"defaultTimeout"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>defaultTimeout</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #defaultTimeout}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetEnabled","fromProperty":"enabled"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>enabled</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMaxConcurrentRequests","fromProperty":"maxConcurrentRequests"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>maxConcurrentRequests</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #maxConcurrentRequests}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMaxTotalRequests","fromProperty":"maxTotalRequests"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>maxTotalRequests</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #maxTotalRequests}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setDefaultTimeout","fromProperty":"defaultTimeout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>defaultTimeout</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>defaultTimeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #defaultTimeout}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setEnabled","fromProperty":"enabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>enabled</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMaxConcurrentRequests","fromProperty":"maxConcurrentRequests"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>maxConcurrentRequests</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>maxConcurrentRequests</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxConcurrentRequests}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMaxTotalRequests","fromProperty":"maxTotalRequests"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>maxTotalRequests</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>maxTotalRequests</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxTotalRequests}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleEnabled","fromProperty":"enabled"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"Integer","defaultValue":"5000","name":"defaultTimeout","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Default timeout for remote requests in milliseconds.</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyEnabled","defaultValue":"true","name":"enabled","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Indicates whether queue is enabled or not.</p>"}}]},{type:"property",attributes:{"check":"Integer","defaultValue":"3","name":"maxConcurrentRequests","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Maximum number of parallel requests.</p>"}}]},{type:"property",attributes:{"check":"Integer","allowNull":"true","name":"maxTotalRequests","propertyType":"new"},children:[{type:"deprecated"}]}]},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"getInstance"},children:[{type:"desc",attributes:{"text":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The singleton instance of this class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.io.remote.RequestQueue"}}]}]}]}]}]}