{type:"class",attributes:{"isStatic":"true","name":"String","packageName":"qx.lang","fullName":"qx.lang.String","type":"bootstrap"},children:[{type:"desc",attributes:{"text":"<p>String helper functions</p>\n\n<p>The native JavaScript String is not modified by this class. However,\nthere are modifications to the native String in {@link qx.lang.Core} for\nbrowsers that do not support certain features.</p>\n\n<p>The string/array generics introduced in JavaScript 1.6 are supported by\n{@link qx.lang.Generics}.</p>"}},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"camelCase"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>hyphenated string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Converts a hyphenated string (seperated by &#8217;-&#8217;) to camel case.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">qx.lang.String.camelCase(\"I-like-cookies\"); //returns \"ILikeCookies\"</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>camelcase string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"capitalize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>any string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Converts a string to camel case.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">qx.lang.String.camelCase(\"i like cookies\"); //returns \"I Like Cookies\"</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>capitalized string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"contains"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"substring"},children:[{type:"desc",attributes:{"text":"<p>substring to search for</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Check whether the string contains a given substring</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the string contains the substring</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"endsWith"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fullstr"},children:[{type:"desc",attributes:{"text":"<p>the string to search in</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"substr"},children:[{type:"desc",attributes:{"text":"<p>the substring to look for</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Check whether the string ends with the given substring</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the string ends with the given substring</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"escapeRegexpChars"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the string where to escape the chars.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Escapes all chars that have a special meaning in regular expressions</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the string with the escaped chars.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"firstLow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Convert the first character of the string to lower case.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the string with a lower case first character</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"firstUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Convert the first character of the string to upper case.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the string with a upper case first character</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"format"},children:[{type:"params",children:[{type:"param",attributes:{"name":"pattern"},children:[{type:"desc",attributes:{"text":"<p>format string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"args"},children:[{type:"desc",attributes:{"text":"<p>array of arguments to insert into the format string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"desc",attributes:{"text":"<p>Print a list of arguments using a format string\nIn the format string occurences of %n are replaced by the n&#8217;th element of the args list.\nExample:</p>\n\n<pre class=\"javascript\">qx.lang.String.format(\"Hello %1, my name is %2\", [\"Egon\", \"Franz\"]) == \"Hello Egon, my name is Franz\"</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the formatted string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"hyphenate"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>camelcased string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Converts a camelcased string to a hyphenated (seperated by &#8217;-&#8217;) string.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">qx.lang.String.camelCase(\"ILikeCookies\"); //returns \"I-like-cookies\"</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>hyphenated string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"pad"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the string to pad</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"length"},children:[{type:"desc",attributes:{"text":"<p>the final length of the string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"ch"},children:[{type:"desc",attributes:{"text":"<p>character used to fill up the string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Pad a string up to a given length. Padding characters are added to the left of the string.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>paddded string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"startsWith"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fullstr"},children:[{type:"desc",attributes:{"text":"<p>the string to search in</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"substr"},children:[{type:"desc",attributes:{"text":"<p>the substring to look for</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Check whether the string starts with the given substring</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the string starts with the given substring</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"stripTags"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>string containing tags</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Remove <span class=\"caps\">HTML</span>/XML tags from a string\nExample:</p>\n\n<pre class=\"javascript\">qx.lang.String.stripTags(\"&lt;h1>Hello&lt;/h1>\") == \"Hello\"</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the string with stripped tags</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"toArray"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the string which should be splitted</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Converts a string to an array of characters.</p>\n\n<pre>\"hello\" => [ \"h\", \"e\", \"l\", \"l\", \"o\" ];</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the result array of characters</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"trim"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the string to trim</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>removes white space from the left and the right side of a string</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the trimmed string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"trimLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the string to trim</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>removes white space from the left side of a string</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the trimmed string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"trimRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the string to trim</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>removes white space from the right side of a string</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the trimmed string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]}]}]}