{type:"class",attributes:{"isStatic":"true","name":"Logger","packageName":"qx.log","fullName":"qx.log.Logger","type":"bootstrap"},children:[{type:"desc",attributes:{"text":"<p>Main qooxdoo logging class.</p>\n\n<p>Used as central logging feature by qx.core.Object.</p>\n\n<p>Extremely modular and lightweight to support logging at bootstrap and\nat shutdown as well.</p>\n\n<ul>\n<li>Supports dynamic appenders to push the output to the user</li>\n<li>Supports buffering of the last 50 messages (configurable)</li>\n<li>Supports different debug levels (&#8220;debug&#8221;, &#8220;info&#8221;, &#8220;warn&#8221; or &#8220;error&#8221;)</li>\n<li>Simple data serialization for incoming messages</li>\n</ul>"}},{type:"methods-static",children:[{type:"method",attributes:{"access":"private","isStatic":"true","name":"__detect"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Incoming value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Detects the type of the variable given.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Type of the incoming value. Possible values:\n  &#8220;undefined&#8221;, &#8220;null&#8221;, &#8220;boolean&#8221;, &#8220;number&#8221;, &#8220;string&#8221;,\n  &#8220;function&#8221;, &#8220;array&#8221;, &#8220;error&#8221;, &#8220;map&#8221;,\n  &#8220;class&#8221;, &#8220;instance&#8221;, &#8220;node&#8221;, &#8220;stringify&#8221;, &#8220;unknown&#8221;</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"access":"private","isStatic":"true","name":"__log"},children:[{type:"params",children:[{type:"param",attributes:{"name":"level"},children:[{type:"desc",attributes:{"text":"<p>One of &#8220;debug&#8221;, &#8220;info&#8221;, &#8220;warn&#8221; or &#8220;error&#8221;</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"args"},children:[{type:"desc",attributes:{"text":"<p>List of other arguments, where the first is\n  taken as the context object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"desc",attributes:{"text":"<p>Internal logging main routine.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","isStatic":"true","name":"__serialize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Incoming value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"deep"},children:[{type:"desc",attributes:{"text":"<p>Whether arrays and maps should be\n   serialized for a limited number of items</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Serializes the incoming value. If it is a singular value, the result is\na simple string. For an array or a map the result can also be a\nserialized string of a limited number of individual items.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Contains the keys <code>type</code> and <code>text</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"clear"},children:[{type:"desc",attributes:{"text":"<p>Deletes the current buffer. Does not influence message handling of the\nconnected appenders.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"debug"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"},children:[{type:"desc",attributes:{"text":"<p>Contextual object (either instance or static class)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"message"},children:[{type:"desc",attributes:{"text":"<p>Any number of arguments supported. An argument may\n  have any JavaScript data type. All data is serialized immediately and\n  does not keep references to other objects.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sending a message at level &#8220;debug&#8221; to the logger.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"deprecatedClassWarning"},children:[{type:"params",children:[{type:"param",attributes:{"name":"clazz"},children:[{type:"desc",attributes:{"text":"<p>reference to the deprecated class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Class"}}]}]},{type:"param",attributes:{"defaultValue":"","name":"msg"},children:[{type:"desc",attributes:{"text":"<p>Optional message to be printed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Prints a class deprecation warning and a stack trace if the setting\n<code>qx.debug</code> is set to <code>on</code>.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"deprecatedMethodWarning"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fcn"},children:[{type:"desc",attributes:{"text":"<p>reference to the deprecated function. This is\n    arguments.callee if the calling method is to be deprecated.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"defaultValue":"","name":"msg"},children:[{type:"desc",attributes:{"text":"<p>Optional message to be printed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Prints a method deprecation warning and a stack trace if the setting\n<code>qx.debug</code> is set to <code>on</code>.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"error"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"},children:[{type:"desc",attributes:{"text":"<p>Contextual object (either instance or static class)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"message"},children:[{type:"desc",attributes:{"text":"<p>Any number of arguments supported. An argument may\n  have any JavaScript data type. All data is serialized immediately and\n  does not keep references to other objects.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sending a message at level &#8220;error&#8221; to the logger.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getLevel"},children:[{type:"desc",attributes:{"text":"<p>Returns the currently configured minimum log level required for new\nmessages.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Debug level</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getTreshold"},children:[{type:"desc",attributes:{"text":"<p>Returns the currently configured number of messages to be kept in the\nbuffer.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Treshold value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"info"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"},children:[{type:"desc",attributes:{"text":"<p>Contextual object (either instance or static class)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"message"},children:[{type:"desc",attributes:{"text":"<p>Any number of arguments supported. An argument may\n  have any JavaScript data type. All data is serialized immediately and\n  does not keep references to other objects.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sending a message at level &#8220;info&#8221; to the logger.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"register"},children:[{type:"params",children:[{type:"param",attributes:{"name":"appender"},children:[{type:"desc",attributes:{"text":"<p>A static appender class supporting at\n  least a <code>process()</code> method to handle incoming messages.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Class"}}]}]}]},{type:"desc",attributes:{"text":"<p>Registers the given appender and inserts the last cached messages.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"setLevel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>One of &#8220;debug&#8221;, &#8220;info&#8221;, &#8220;warn&#8221; or &#8220;error&#8221;.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Configures the minimum log level required for new messages.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"setTreshold"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Any positive integer</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Configures the number of messages to be kept in the buffer.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"trace"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"},children:[{type:"desc",attributes:{"text":"<p>Contextual object (either instance or static class)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Prints the current stack trace at level &#8220;info&#8221;</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"unregister"},children:[{type:"params",children:[{type:"param",attributes:{"name":"appender"},children:[{type:"desc",attributes:{"text":"<p>A static appender class</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Class"}}]}]}]},{type:"desc",attributes:{"text":"<p>Unregisters the given appender</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"warn"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"},children:[{type:"desc",attributes:{"text":"<p>Contextual object (either instance or static class)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"message"},children:[{type:"desc",attributes:{"text":"<p>Any number of arguments supported. An argument may\n  have any JavaScript data type. All data is serialized immediately and\n  does not keep references to other objects.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sending a message at level &#8220;warn&#8221; to the logger.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]}]}