{type:"class",attributes:{"name":"RadioButton","packageName":"qx.ui.form","superClass":"qx.ui.form.Button","fullName":"qx.ui.form.RadioButton","type":"class","interfaces":"qx.ui.form.IRadioItem"},children:[{type:"desc",attributes:{"text":"<p>Radio buttons can be used in radio groups to allow to the user to select\nexactly one item from a list. Radio groups are established by adding\nradio buttons to a radio manager {@link qx.ui.form.RadioGroup}.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\n  var container = new qx.ui.container.Composite(new qx.ui.layout.VBox);\n\n  var female = new qx.ui.form.RadioButton(\"female\");\n  var male = new qx.ui.form.RadioButton(\"male\");\n\n  var mgr = new qx.ui.form.RadioGroup;\n  mgr.add(female, male);\n\n  container.add(male);\n  container.add(female);\n</pre>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.form.Button","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"null","name":"label"},children:[{type:"desc",attributes:{"text":"<p>An optional label for the radio button.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"allowGrowX","docFrom":"qx.ui.core.LayoutItem","defaultValue":"false","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.core.LayoutItem"}},{type:"property",attributes:{"name":"appearance","docFrom":"qx.ui.core.Widget","defaultValue":"\"radiobutton\"","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.form.Button"}},{type:"property",attributes:{"name":"checked","defaultValue":"false","event":"changeChecked","propertyType":"new","apply":"_applyChecked","check":"Boolean"},children:[{type:"desc",attributes:{"text":"<p>Boolean value signals if the button is checked</p>"}}]},{type:"property",attributes:{"allowNull":"true","apply":"_applyGroup","check":"qx.ui.form.RadioGroup","name":"group","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The assigned qx.ui.form.RadioGroup which handles the switching between registered buttons</p>"}}]}]},{type:"events",children:[{type:"event",attributes:{"name":"changeChecked"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #checked}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.form.RadioButton#checked","name":"_applyChecked"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>checked</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyChecked}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.form.RadioButton#group","name":"_applyGroup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.form.RadioGroup"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.form.RadioGroup"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>group</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyGroup}.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onExecute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>execute event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for the &#8220;execute&#8221; event.</p>\n\n<p>Sets the property &#8220;checked&#8221; to true.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onKeyPress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>KeyPress event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for the &#8220;keyPress&#8221; event.</p>\n\n<p>Selects the previous RadioButton when pressing &#8220;Left&#8221; or &#8220;Up&#8221; and\nSelects the next RadioButton when pressing &#8220;Right&#8221; and &#8220;Down&#8221;</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getChecked","fromProperty":"checked"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>checked</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #checked}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>checked</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getGroup","fromProperty":"group"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>group</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #group}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>group</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initChecked","fromProperty":"checked"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>checked</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>checked</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #checked}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initGroup","fromProperty":"group"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>group</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>group</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #group}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isChecked","fromProperty":"checked"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>checked</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #checked}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"isTabable"}},{type:"method",attributes:{"name":"resetChecked","fromProperty":"checked"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>checked</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #checked}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetGroup","fromProperty":"group"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>group</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #group}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setChecked","fromProperty":"checked"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>checked</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>checked</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #checked}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setGroup","fromProperty":"group"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>group</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>group</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #group}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleChecked","fromProperty":"checked"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>checked</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #checked}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]}]}