{type:"class",attributes:{"name":"RepeatButton","packageName":"qx.ui.form","superClass":"qx.ui.form.Button","fullName":"qx.ui.form.RepeatButton","type":"class"},children:[{type:"desc",attributes:{"text":"<p>The RepeatButton is a special button, which fires repeatedly {@link execute}\nevents, while the mouse button is pressed on the button. The initial delay\nand the interval time can be set using the properties {@link #firstInterval}\nand {@link #interval}. The {@link execute} events will be fired in a shorter\namount of time if the mouse button is hold, until the min {@link #minTimer}\nis reached. The {@link #timerDecrease} property sets the amount of milliseconds\nwhich will decreased after every firing.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.form.Button","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"label"},children:[{type:"desc",attributes:{"text":"<p>Label to use</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"icon"},children:[{type:"desc",attributes:{"text":"<p>Icon to use</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]}]}]},{type:"events",children:[{type:"event",attributes:{"name":"execute"},children:[{type:"desc",attributes:{"text":"<p>This event gets dispatched with every interval. The timer gets executed\nas long as the user holds down the mouse button.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"press"},children:[{type:"desc",attributes:{"text":"<p>This event gets dispatched when the button is pressed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"release"},children:[{type:"desc",attributes:{"text":"<p>This event gets dispatched when the button is released.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__startInternalTimer"},children:[{type:"desc",attributes:{"text":"<p>Starts the internal timer which causes firing of execution\nevents in an interval. It also presses the button.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__stopInternalTimer"},children:[{type:"desc",attributes:{"text":"<p>Stops the internal timer and releases the button.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.Widget#enabled","overriddenFrom":"qx.ui.core.Widget","name":"_applyEnabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyEnabled}.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>interval event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Callback for the interval event.</p>\n\n<p>Stops the timer and starts it with a new interval\n(value of the &#8220;interval&#8221; property &#8211; value of the &#8220;timerDecrease&#8221; property).\nDispatches the &#8220;execute&#8221; event.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","overriddenFrom":"qx.ui.form.Button","name":"_onKeyDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Key event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener method for &#8220;keydown&#8221; event.</p>\n\n<p>Removes &#8220;abandoned&#8221; and adds &#8220;pressed&#8221; state\nfor the keys &#8220;Enter&#8221; or &#8220;Space&#8221;. It also starts\nthe internal timer (same like mousedown).</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","overriddenFrom":"qx.ui.form.Button","name":"_onKeyUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Key event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener method for &#8220;keyup&#8221; event.</p>\n\n<p>Removes &#8220;abandoned&#8221; and &#8220;pressed&#8221; state (if &#8220;pressed&#8221; state is set)\nfor the keys &#8220;Enter&#8221; or &#8220;Space&#8221; and stopps the internal timer\n(same like mouse up).</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","overriddenFrom":"qx.ui.form.Button","name":"_onMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouseDown event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Callback method for the &#8220;mouseDown&#8221; method.</p>\n\n<p>Sets the interval of the timer (value of firstInterval property) and\nstarts the timer. Additionally removes the state &#8220;abandoned&#8221; and adds the\nstate &#8220;pressed&#8221;.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","overriddenFrom":"qx.ui.form.Button","name":"_onMouseOut"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Mouse event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener method for &#8220;mouseout&#8221; event\n<ul>\n<li>Removes &#8220;hovered&#8221; state</li>\n<li>Adds &#8220;abandoned&#8221; and removes &#8220;pressed&#8221; state (if &#8220;pressed&#8221; state is set)</li>\n</ul></p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","overriddenFrom":"qx.ui.form.Button","name":"_onMouseOver"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Mouse event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener method for &#8220;mouseover&#8221; event\n<ul>\n<li>Adds state &#8220;hovered&#8221;</li>\n<li>Removes &#8220;abandoned&#8221; and adds &#8220;pressed&#8221; state (if &#8220;abandoned&#8221; state is set)</li>\n</ul></p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","overriddenFrom":"qx.ui.form.Button","name":"_onMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouseUp event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Callback method for the &#8220;mouseUp&#8221; event.</p>\n\n<p>Handles the case that the user is releasing the mouse button\nbefore the timer interval method got executed. This way the\n&#8220;execute&#8221; method get executed at least one time.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getFirstInterval","fromProperty":"firstInterval"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>firstInterval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #firstInterval}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>firstInterval</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getInterval","fromProperty":"interval"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>interval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>interval</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMinTimer","fromProperty":"minTimer"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>minTimer</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #minTimer}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>minTimer</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getTimerDecrease","fromProperty":"timerDecrease"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>timerDecrease</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timerDecrease}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>timerDecrease</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initFirstInterval","fromProperty":"firstInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>firstInterval</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>firstInterval</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #firstInterval}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initInterval","fromProperty":"interval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>interval</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>interval</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMinTimer","fromProperty":"minTimer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>minTimer</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>minTimer</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #minTimer}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initTimerDecrease","fromProperty":"timerDecrease"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>timerDecrease</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>timerDecrease</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #timerDecrease}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.form.Button","name":"press"},children:[{type:"desc",attributes:{"text":"<p>Calling this function is like a click from the user on the\nbutton with all consequences.\n<span>Be shure to call the {@link #release} function.</span></p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.form.Button","name":"release"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"true","name":"fireExecuteEvent"},children:[{type:"desc",attributes:{"text":"<p>flag which signals, if a event should be fired</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calling this function is like a release from the user on the\nbutton with all consequences.\nUsually the {@link #release} function will be called before the call of\nthis function.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetFirstInterval","fromProperty":"firstInterval"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>firstInterval</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #firstInterval}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetInterval","fromProperty":"interval"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>interval</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMinTimer","fromProperty":"minTimer"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>minTimer</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #minTimer}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetTimerDecrease","fromProperty":"timerDecrease"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>timerDecrease</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #timerDecrease}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setFirstInterval","fromProperty":"firstInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>firstInterval</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>firstInterval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #firstInterval}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setInterval","fromProperty":"interval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>interval</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>interval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMinTimer","fromProperty":"minTimer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>minTimer</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>minTimer</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #minTimer}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setTimerDecrease","fromProperty":"timerDecrease"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>timerDecrease</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>timerDecrease</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timerDecrease}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"Integer","defaultValue":"500","name":"firstInterval","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Interval used for the first run of the timer. Usually a greater value\nthan the &#8220;interval&#8221; property value to a little delayed reaction at the first\ntime.</p>"}}]},{type:"property",attributes:{"check":"Integer","defaultValue":"100","name":"interval","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Interval used after the first run of the timer. Usually a smaller value\nthan the &#8220;firstInterval&#8221; property value to get a faster reaction.</p>"}}]},{type:"property",attributes:{"check":"Integer","defaultValue":"20","name":"minTimer","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>This configures the minimum value for the timer interval.</p>"}}]},{type:"property",attributes:{"check":"Integer","defaultValue":"2","name":"timerDecrease","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Decrease of the timer on each interval (for the next interval) until minTimer reached.</p>"}}]}]}]}