{type:"class",attributes:{"name":"Canvas","packageName":"qx.ui.layout","superClass":"qx.ui.layout.Abstract","fullName":"qx.ui.layout.Canvas","type":"class"},children:[{type:"desc",attributes:{"text":"<p>The Canvas is an extended Basic layout.</p>\n\n<p>It is possible to position a widget relative to the right or bottom edge of\nthe available space. It further supports stretching between left and right\nor top and bottom e.g. <code>left=20</code> and <code>right=20<code> would\nkeep a margin of 20 pixels to both edges. The Canvas layout has support for\npercent dimensions and locations.</p>\n\n<p><strong>Features</strong></p>\n\n<ul>\n<li>Pixel dimensions and locations</li>\n<li>Percent dimensions and locations</li>\n<li>Stretching between left+right and top+bottom</li>\n<li>Minimum and maximum dimensions</li>\n<li>Children are automatically shrunk to their minimum dimensions if not enough space is available</li>\n<li>Auto sizing (ignoring percent values)</li>\n<li>Margins (also negative ones)</li>\n</ul>\n\n<p><strong>Item Properties</strong></p>\n\n<ul>\n<li><strong>left</strong> <em>(Integer|String)</em>: The left coordinate in pixel or as a percent string e.g. <code>20</code> or <code>30%</code>.</li>\n<li><strong>top</strong> <em>(Integer|String)</em>: The top coordinate in pixel or as a percent string e.g. <code>20</code> or <code>30%</code>.</li>\n<li><strong>right</strong> <em>(Integer|String)</em>: The right coordinate in pixel or as a percent string e.g. <code>20</code> or <code>30%</code>.</li>\n<li><strong>bottom</strong> <em>(Integer|String)</em>: The bottom coordinate in pixel or as a percent string e.g. <code>20</code> or <code>30%</code>.</li>\n<li><strong>width</strong> <em>(String)</em>: A percent width e.g. <code>40%</code>.</li>\n<li><strong>height</strong> <em>(String)</em>: A percent height e.g. <code>60%</code>.</li>\n</ul>\n\n<p><strong>Notes</strong></p>\n\n<ul>\n<li>Stretching (<code>left</code>-><code>right</code> or <code>top</code>-><code>bottom</code>)\n  has a higher priority than the preferred dimensions</li>\n<li>Stretching has a lower priority than the min/max dimensions.</li>\n<li>Percent values have no influence on the size hint of the layout.</li>\n</ul>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the canvas layout.</p>\n\n<pre class=\"javascript\">\nvar container = new qx.ui.container.Composite(new qx.ui.layout.Canvas());\n\n// simple positioning\ncontainer.add(new qx.ui.core.Widget(), {top: 10, left: 10});\n\n// strech vertically with 10 pixel distance to the parent's top\n// and bottom border\ncontainer.add(new qx.ui.core.Widget(), {top: 10, left: 10, bottom: 10});\n\n// percent positioning and size\ncontainer.add(new qx.ui.core.Widget(), {left: \"50%\", top: \"50%\", width: \"25%\", height: \"40%\"});\n</pre>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://qooxdoo.org/documentation/0.8/layout/canvas\">\nExtended documentation</a> and links to demos of this layout in the qooxdoo wiki."}},{type:"methods",children:[{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.layout.Abstract","overriddenFrom":"qx.ui.layout.Abstract","name":"_computeSizeHint"}},{type:"method",attributes:{"docFrom":"qx.ui.layout.Abstract","overriddenFrom":"qx.ui.layout.Abstract","name":"renderLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"availWidth"}},{type:"param",attributes:{"name":"availHeight"}}]}]}]}]}