{type:"class",attributes:{"isAbstract":"true","name":"AbstractTreeItem","packageName":"qx.ui.tree","superClass":"qx.ui.core.Widget","childClasses":"qx.ui.tree.TreeFile,qx.ui.tree.TreeFolder","fullName":"qx.ui.tree.AbstractTreeItem","type":"class"},children:[{type:"desc",attributes:{"text":"<p>The AbstractTreeItem serves as a common superclass for the {@link\nTreeFile} and {@link TreeFolder} classes.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.ui.core.Widget","isCtor":"true","name":"ctor"}}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__addChildrenToParent"},children:[{type:"desc",attributes:{"text":"<p>Adds the item&#8217;s children container the the parent&#8217;s children container.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_addWidgets"},children:[{type:"desc",attributes:{"text":"<p>This method configures the tree item by adding its sub widgets like\nlabel, icon, open symbol, ...</p>\n\n<p>This method must be overridden by sub classes.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.tree.AbstractTreeItem#icon","name":"_applyIcon"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>icon</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyIcon}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.tree.AbstractTreeItem#indent","name":"_applyIndent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>indent</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyIndent}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.tree.AbstractTreeItem#label","name":"_applyLabel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>label</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyLabel}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.tree.AbstractTreeItem#open","name":"_applyOpen"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>open</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyOpen}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.tree.AbstractTreeItem#openSymbolMode","name":"_applyOpenSymbolMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>openSymbolMode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyOpenSymbolMode}.</p>"}}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_createChildControlImpl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"}}]}]},{type:"method",attributes:{"access":"protected","name":"_onChangeOpen"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler, which listentes to open state changes of the open button</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_shouldShowOpenSymbol"},children:[{type:"desc",attributes:{"text":"<p>Whether the open symbol should be shown</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the open symbol should be shown.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_updateIndent"},children:[{type:"desc",attributes:{"text":"<p>Update the indentation of the tree item.</p>"}}]},{type:"method",attributes:{"name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>variable number of tree items to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds the passed tree items to the end of this item&#8217;s children list.</p>"}}]},{type:"method",attributes:{"name":"addAfter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"treeItem"},children:[{type:"desc",attributes:{"text":"<p>tree item to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]},{type:"param",attributes:{"name":"after"},children:[{type:"desc",attributes:{"text":"<p>existing child to add the item after</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add a tree item to this item after the existing child <code>before</code>.</p>"}}]},{type:"method",attributes:{"name":"addAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"treeItem"},children:[{type:"desc",attributes:{"text":"<p>new tree item to insert</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]},{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>position to insert into</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds the tree item to the current item, at the given index.</p>"}}]},{type:"method",attributes:{"name":"addAtBegin"},children:[{type:"params",children:[{type:"param",attributes:{"name":"treeItem"},children:[{type:"desc",attributes:{"text":"<p>tree item to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add a tree item as the first child of this item.</p>"}}]},{type:"method",attributes:{"name":"addBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"treeItem"},children:[{type:"desc",attributes:{"text":"<p>tree item to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]},{type:"param",attributes:{"name":"before"},children:[{type:"desc",attributes:{"text":"<p>existing child to add the item before</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add a tree item to this item before the existing child <code>before</code>.</p>"}}]},{type:"method",attributes:{"name":"addIcon"},children:[{type:"desc",attributes:{"text":"<p>Adds the icon widget to the item&#8217;s horizontal box layout. If the icon\nwidget has been added before, it is removed from its old position and\nadded to the end of the layout.</p>"}}]},{type:"method",attributes:{"name":"addLabel"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"0","name":"text"},children:[{type:"desc",attributes:{"text":"<p>The label&#8217;s contents</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds the label to the item&#8217;s horizontal box layout. If the label\nhas been added before, it is removed from its old position and\nadded to the end of the layout.</p>"}}]},{type:"method",attributes:{"name":"addOpenButton"},children:[{type:"desc",attributes:{"text":"<p>Adds the open button to the item&#8217;s horizontal box layout. If the open\nbutton has been added before, it is removed from its old position and\nadded to the end of the layout.</p>"}}]},{type:"method",attributes:{"name":"addSpacer"},children:[{type:"desc",attributes:{"text":"<p>Adds the spacer used to render the indentation to the item&#8217;s horizontal\nbox layout. If the spacer has been added before, it is removed from its\nold position and added to the end of the layout.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"addState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"state"}}]}]},{type:"method",attributes:{"name":"addWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>The widget to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"options"},children:[{type:"desc",attributes:{"text":"<p>The (optional) layout options to use for the widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds a sub widget to the tree item&#8217;s horizontal box layout.</p>"}}]},{type:"method",attributes:{"name":"getChildren"},children:[{type:"desc",attributes:{"text":"<p>Get all child items.</p>\n\n<p>Note: Don&#8217;t modifiy the returned array, since this function does not\nreturn a copy!</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>An array of all child items.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem","dimensions":"1"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Widget","name":"getChildrenContainer"},children:[{type:"desc",attributes:{"text":"<p>Returns the widget, which atcs as container for the child items.\nThis widget must have a vertical box layout.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The children container</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"name":"getIcon","fromProperty":"icon"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>icon</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>icon</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getIndent","fromProperty":"indent"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>indent</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #indent}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>indent</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getItems"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"true","name":"recursive"},children:[{type:"desc",attributes:{"text":"<p>whether children of subfolder should be\n    included</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"defaultValue":"true","name":"invisible"},children:[{type:"desc",attributes:{"text":"<p>whether invisible children should be\n    included</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"defaultValue":"true","name":"ignoreFirst"},children:[{type:"desc",attributes:{"text":"<p>Whether the current treeItem should\n    be excluded from the list.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns all children of the folder.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>list of children</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem","dimensions":"1"}}]}]}]},{type:"method",attributes:{"name":"getLabel","fromProperty":"label"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>label</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>label</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getLevel"},children:[{type:"desc",attributes:{"text":"<p>Computes the item&#8217;s nesting level. If the item is not part of a tree\nthis function will return <code>null</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The item&#8217;s nesting level or <code>null</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"name":"getOpen","fromProperty":"open"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>open</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #open}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>open</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getOpenSymbolMode","fromProperty":"openSymbolMode"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>openSymbolMode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #openSymbolMode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>openSymbolMode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getParent","fromProperty":"parent"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>parent</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parent}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>parent</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getParentChildrenContainer"},children:[{type:"desc",attributes:{"text":"<p>Get the children container of the item&#8217;s parent. This function will return\n<code>null</code>, if the item does not have a parent or is not the root\nitem.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The parent&#8217;s children container.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"name":"getTree"},children:[{type:"desc",attributes:{"text":"<p>Returns the tree the tree item is connected to. If the item is not part of\na tree <code>null</code> will be returned.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The item&#8217;s tree or <code>null</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.tree.Tree"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"name":"hasChildren"},children:[{type:"desc",attributes:{"text":"<p>Whether the item has any children</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the item has any children.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initIcon","fromProperty":"icon"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>icon</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>icon</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initIndent","fromProperty":"indent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>indent</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>indent</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #indent}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initLabel","fromProperty":"label"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>label</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>label</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initOpen","fromProperty":"open"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>open</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>open</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #open}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initOpenSymbolMode","fromProperty":"openSymbolMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>openSymbolMode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>openSymbolMode</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #openSymbolMode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initParent","fromProperty":"parent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>parent</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>parent</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #parent}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isOpen","fromProperty":"open"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>open</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #open}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isOpenable"},children:[{type:"desc",attributes:{"text":"<p>Whether the tree item can be opened.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the tree item can be opened.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"internal","isInternal":"true","name":"recursiveAddToWidgetQueue"},children:[{type:"desc",attributes:{"text":"<p>Adds this item and recursively all sub items to the widget queue to\nupdate the indentation.</p>"}}]},{type:"method",attributes:{"name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>variable number of tree items to remove</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the passed tree items from this item.</p>"}}]},{type:"method",attributes:{"name":"removeAll"},children:[{type:"desc",attributes:{"text":"<p>Remove all child items from this item.</p>"}}]},{type:"method",attributes:{"name":"removeAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>Index of the child to remove</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Remove the child with the given child index.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"removeState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"state"}}]}]},{type:"method",attributes:{"name":"resetIcon","fromProperty":"icon"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>icon</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetIndent","fromProperty":"indent"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>indent</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #indent}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetLabel","fromProperty":"label"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>label</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetOpen","fromProperty":"open"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>open</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #open}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetOpenSymbolMode","fromProperty":"openSymbolMode"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>openSymbolMode</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #openSymbolMode}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetParent","fromProperty":"parent"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>parent</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #parent}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setIcon","fromProperty":"icon"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>icon</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>icon</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setIndent","fromProperty":"indent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>indent</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>indent</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #indent}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setLabel","fromProperty":"label"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>label</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>label</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setOpen","fromProperty":"open"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>open</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>open</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #open}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setOpenSymbolMode","fromProperty":"openSymbolMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>openSymbolMode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>openSymbolMode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #openSymbolMode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setParent","fromProperty":"parent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>parent</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>parent</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parent}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"syncWidget"}},{type:"method",attributes:{"name":"toggleOpen","fromProperty":"open"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>open</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #open}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"icon","allowNull":"true","propertyType":"new","apply":"_applyIcon","check":"String","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Any <span class=\"caps\">URI</span> String supported by qx.ui.basic.Image to display a icon</p>"}}]},{type:"property",attributes:{"name":"indent","defaultValue":"19","propertyType":"new","apply":"_applyIndent","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The number of pixel to indent the tree item for each level.</p>"}}]},{type:"property",attributes:{"check":"String","apply":"_applyLabel","defaultValue":"\"\"","name":"label","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The label/caption/text</p>"}}]},{type:"property",attributes:{"name":"open","defaultValue":"false","event":"changeOpen","propertyType":"new","apply":"_applyOpen","check":"Boolean"},children:[{type:"desc",attributes:{"text":"<p>Whether the tree item is opened.</p>"}}]},{type:"property",attributes:{"name":"openSymbolMode","defaultValue":"\"auto\"","propertyType":"new","apply":"_applyOpenSymbolMode","possibleValues":"\"always\",\"never\",\"auto\"","event":"changeOpenSymbolMode"},children:[{type:"desc",attributes:{"text":"<p>Controls, when to show the open symbol. If the mode is &#8220;auto&#8221; , the open\nsymbol is shown only if the item has child items.</p>"}}]},{type:"property",attributes:{"check":"qx.ui.tree.AbstractTreeItem","allowNull":"true","name":"parent","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The parent tree folder.</p>"}}]}]},{type:"events",children:[{type:"event",attributes:{"name":"changeOpen"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #open}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeOpenSymbolMode"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #openSymbolMode}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]}]}