// $Id: DistCalc.java 46b340ff2c03 2009/03/13 16:19:42 Oliver Lau <oliver@von-und-fuer-lau.de> $
// Copyright (c) 2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// Alle Rechte vorbehalten.

package de.heise.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.WindowResizeListener;
import com.google.gwt.user.client.ui.HorizontalSplitPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestOracle.Suggestion;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.SuggestionEvent;
import com.google.gwt.user.client.ui.SuggestionHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.maps.client.control.LargeMapControl;
import com.google.gwt.maps.client.control.OverviewMapControl;
import com.google.gwt.maps.client.control.HierarchicalMapTypeControl;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.MapType;
import com.google.gwt.maps.client.geom.LatLng;
import com.google.gwt.maps.client.overlay.Marker;
import com.google.gwt.maps.client.overlay.Polyline;
import com.google.gwt.maps.client.overlay.PolylineOptions;
import com.google.gwt.maps.client.geocode.Geocoder;
import com.google.gwt.maps.client.geocode.LatLngCallback;
import com.google.gwt.maps.client.geocode.DirectionQueryOptions;
import com.google.gwt.maps.client.geocode.DirectionResults;
import com.google.gwt.maps.client.geocode.Directions;
import com.google.gwt.maps.client.geocode.DirectionsPanel;
import com.google.gwt.maps.client.geocode.DirectionsCallback;
import com.google.gwt.maps.client.geocode.StatusCodes;


public class DistCalc implements EntryPoint {

	private int zoomLevel = 13;
	private HorizontalSplitPanel hPanel = null;
	private Geocoder geocoder = new Geocoder();
	private MapWidget map = null;
	private MultiWordSuggestOracle oracle =  null;
	private DirectionsPanel directionsPanel = null;
	private DirectionQueryOptions directionQueryOpts = null;
	private TextBox homeCoord = null;
	private TextBox foreignCoord = null;
	private TextBox distanceBeeline = null;
	private TextBox distanceRoute = null;
	private SuggestBox homeAddress = null;
	private SuggestBox foreignAddress = null;
	private LatLng homeLatLng = null;
	private LatLng foreignLatLng = null;
	private Marker homeMarker = null;
	private Marker foreignMarker = null;
	private LatLng[] points = new LatLng[2];
	private PolylineOptions geodesicLineOptions = PolylineOptions.newInstance(false, true);
	private java.util.TreeSet<String> address = null;

	private void updateMap()
	{
		// Zeichnen der geodätischen Linie zwischen Start und Ziel
	    if (homeLatLng != null && foreignLatLng != null) {
	    	points[0] = homeLatLng;
	    	points[1] = foreignLatLng;
	    	Polyline polyline = new Polyline(points, "#cc3333", 4, 0.7, geodesicLineOptions);
			map.removeOverlay(polyline);
	    	map.addOverlay(polyline);
	    }
	}
	
	private void updateCookie()
	{
		JSONArray cookieData = new JSONArray();
		int i = 0;
		java.util.Iterator<String> addressList = address.iterator();
		while (addressList.hasNext())
			cookieData.set(i++, new JSONString(addressList.next()));
		String suggestions = cookieData.toString();
		java.util.Date now = new java.util.Date();
		java.util.Date expires = new java.util.Date(now.getTime() + 31536000000L);
		Cookies.setCookie("suggestions", suggestions, expires);
	}
	
	private void addAddress(String addressLine)
	{
		address.add(addressLine);
		oracle.add(addressLine);
		updateCookie();
	}
	
	private void queryRoute()
	{
		String query = "from: " + homeAddress.getText() + " to: " + foreignAddress.getText();
		Directions.load(query, directionQueryOpts, new DirectionsCallback() {
			public void onFailure(int statusCode) {
				Window.alert("Laden der Wegbeschreibungen fehlgeschlagen: Status "
						+ StatusCodes.getName(statusCode) + " " + statusCode);
			}
			public void onSuccess(DirectionResults result) {
				double d = foreignLatLng.distanceFrom(homeLatLng) / 1000;
				NumberFormat fmt = NumberFormat.getFormat("#.00#");
				distanceBeeline.setText(fmt.format(d));
				distanceRoute.setText(fmt.format(result.getDistance().inMeters() / 1000));
				hPanel.setSplitPosition("80%");
				map.setWidth("80%");
				updateMap();
			}
		});		
	}
	
	private void homeChanged()
	{
		geocoder.getLatLng(homeAddress.getText(), new LatLngCallback() {
			public void onFailure() {
				Window.alert(homeAddress.getText() + " nicht gefunden");
			}
			public void onSuccess(LatLng point) {
				GWT.log("Neue Startkoordinaten: " + point.toString(), null);
				homeLatLng = point;
				if (homeMarker == null) {
					homeMarker = new Marker(point);
					homeMarker.setImage("http://maps.google.com/intl/en_ALL/mapfiles/icon_greenA.png");
				}
				else {
					homeMarker.setLatLng(point);
				}
				map.removeOverlay(homeMarker);
				map.addOverlay(homeMarker);
				NumberFormat fmt = NumberFormat.getFormat("#.0000000#");
				homeCoord.setText(fmt.format(point.getLatitude()) + ", " + fmt.format(point.getLongitude()));
				map.setCenter(point, zoomLevel);
				addAddress(homeAddress.getText());
			}
		});
	}
	
	private void foreignChanged()
	{
		geocoder.getLatLng(foreignAddress.getText(), new LatLngCallback() {
			public void onFailure() {
				Window.alert(foreignAddress.getText() + " nicht gefunden");
			}
			public void onSuccess(LatLng point) {
				GWT.log("Neue Zielkoordinaten: " + point.toString(), null);
				foreignLatLng = point;
				if (foreignMarker == null) {
					foreignMarker = new Marker(point);
					foreignMarker.setImage("http://maps.google.com/intl/en_ALL/mapfiles/icon_greenB.png");
				}
				else {
					foreignMarker.setLatLng(point);
				}
				map.removeOverlay(foreignMarker);
				map.addOverlay(foreignMarker);
			    NumberFormat fmt = NumberFormat.getFormat("#.0000000#");
			    foreignCoord.setText(fmt.format(point.getLatitude()) + ", " + fmt.format(point.getLongitude()));
				map.setCenter(point, zoomLevel);
				addAddress(foreignAddress.getText());
			}
		});
	}
	
	private void resizeMap(int width, int height)
	{
		map.setPixelSize(width - 10, height - map.getAbsoluteTop() - 10);
		hPanel.setSplitPosition("100%");
	}
	
	public void onModuleLoad()
	{
		address = new java.util.TreeSet<String>();
		address.add("Helstorfer Straße 7, 30625 Hannover, Deutschland");
		address.add("Messe/Nord, 30519 Hannover, Deutschland");

		map = new MapWidget(LatLng.newInstance(51.5087, 9.9756), 5);
		map.addControl(new LargeMapControl());
		map.addControl(new OverviewMapControl());
		map.addControl(new HierarchicalMapTypeControl());
		map.addMapType(MapType.getPhysicalMap());
		
		Window.addWindowResizeListener(new WindowResizeListener() {
			public void onWindowResized(int w, int h) {
				resizeMap(w, h);
			}
		});

		directionsPanel = new DirectionsPanel();
		directionQueryOpts = new DirectionQueryOptions(map, directionsPanel);
		
		oracle = new MultiWordSuggestOracle();
		java.util.Iterator<String> i = address.iterator();
		while (i.hasNext())
			oracle.add(i.next());

		homeCoord = new TextBox();
		homeCoord.setEnabled(false);
		homeCoord.setVisibleLength(23);

		homeAddress = new SuggestBox(oracle);
		homeAddress.setWidth("300px");
		homeAddress.addChangeListener(new ChangeListener() {
			public void onChange(Widget sender) {
				homeChanged();
			}
		});
		homeAddress.addEventHandler(new SuggestionHandler() {
			public void onSuggestionSelected(SuggestionEvent event) {
				Suggestion sugg = event.getSelectedSuggestion();
				homeAddress.setText(sugg.getReplacementString());
				homeChanged();
			}
		});

		foreignCoord = new TextBox();
		foreignCoord.setEnabled(false);
		foreignCoord.setVisibleLength(23);

		foreignAddress = new SuggestBox(oracle);
		foreignAddress.setWidth("300px");
		foreignAddress.addChangeListener(new ChangeListener() {
			public void onChange(Widget sender) {
				foreignChanged();
			}
		});
		foreignAddress.addEventHandler(new SuggestionHandler() {
			public void onSuggestionSelected(SuggestionEvent event) {
				Suggestion sugg = event.getSelectedSuggestion();
				foreignAddress.setText(sugg.getReplacementString());
				foreignChanged();
			}
		});

		distanceBeeline = new TextBox();
		distanceBeeline.setEnabled(false);
		distanceBeeline.setVisibleLength(10);
		
		distanceRoute = new TextBox();
		distanceRoute.setEnabled(false);
		distanceRoute.setVisibleLength(10);

		final Button submitButton = new Button("Route berechnen");
		submitButton.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				map.clearOverlays();
				queryRoute();
			};
		});
		
		Grid form = new Grid(6, 4);
		form.setWidget(0, 2, new Label("Adresse"));
		form.setWidget(0, 3, new Label("Breiten- und Längengrad"));
		form.setWidget(1, 0, new Label("Von"));
		form.setWidget(1, 1, new Image("icon_small_greenA.png"));
		form.setWidget(2, 0, new Label("Nach"));
		form.setWidget(2, 1, new Image("icon_small_greenB.png"));
		form.setWidget(1, 2, homeAddress);
		form.setWidget(1, 3, homeCoord);
		form.setWidget(2, 2, foreignAddress);
		form.setWidget(2, 3, foreignCoord);
		form.setWidget(3, 2, submitButton);
		form.setWidget(4, 0, new Label("Luftlinie [km]"));
		form.setWidget(4, 2, distanceBeeline);
		form.setWidget(5, 0, new Label("Route [km]"));
		form.setWidget(5, 2, distanceRoute);

		VerticalPanel mainPanel = new VerticalPanel();
		mainPanel.add(form);
		mainPanel.add(map);
		
		hPanel = new HorizontalSplitPanel();
		hPanel.add(mainPanel);
		hPanel.add(directionsPanel);
		hPanel.setSplitPosition("100%");
		
		RootPanel.get("DistCalcApp").add(hPanel);
		resizeMap(Window.getClientWidth(), Window.getClientHeight());
	}
}
