﻿/*
c'time
Eine Zeiterfassung für Opera Unite
(c) Herbert Braun 2009, c't
Verwendung und Modifizierung gestattet
*/

var webserver, dir;
var eintraege = []; // vorerst leeres Array für die Listeneinträge
var store = 'json'; // Dateiname für Datenspeicherung
// gruende bei Bedarf ergänzen!
var gruende = ['Arbeit', 'Freizeit', 'Pause', 'Sonstiges'];
var monate = ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'];
var tage = ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag'];

window.onload = function() {
 // Datenspeicherplatz mounten
 dir = opera.io.filesystem.mountSystemDirectory('storage');
 // Webserver
 webserver = opera.io.webserver;
 if (webserver) {
  // "URLs" der Anwendung
  webserver.addEventListener('_index', ausgabe, false);
  webserver.addEventListener('form', eingabe, false);
  webserver.addEventListener('save', speichern, false);
 }
}

function ausgabe(e) {
 // gibt die Einträge als Liste aus
 var response = e.connection.response;
 response.write('<!DOCTYPE html>'
  + '<html><head><title>Einträge</title></head>'
  + '<body><ul>');
 // liest beim ersten Aufruf Speicherdatei ein
 if (!eintraege.length) {
  var datei = lesen();
  eintraege = eval(datei);
 }
 // schreibt die Einträge
 for (var i = 0, eintrag; eintrag = eintraege[i]; i++) {
  response.write('<li>' + datumformat(eintrag.datum) + ' <b>' + gruende[eintrag.grund] + '</b> (' + eintrag.text + ') – ');
  // berechnet die Zeitdifferenz zum nächsten Eintrag
  if (eintraege[i+1]) {
   var zeit = (eintraege[i+1].datum - eintraege[i].datum);
   response.write(zeitformat(zeit));
  } else {
   // berechnet die Zeitdifferenz zu jetzt
   var d = new Date();
   var zeit = (d - eintraege[i].datum);
   response.write('bisher ' + zeitformat(zeit));
  }
  response.write('</li>');
 }
 response.write('</ul><p><a href="form">Eintrag hinzufügen</a></p>');
 response.write('</body></html>');
 response.close();
}

function eingabe(e) {
 // zeigt ein Eingabeformular an
 var response = e.connection.response;
 response.write('<!DOCTYPE html>'
  + '<html><head><title>Eintrag hinzufügen</title></head>'
  + '<body><h1>Eintrag hinzufügen</h1>'
  + '<form method="post" action="save">'
  + '<p><label for="namefield">Grund</label> <select id="nameField" name="grund"><option value="">-</option>');
 // Gründe als Auswahlliste
 for (var i = 0, grund; grund = gruende[i]; i++) {
  response.write('<option value="' + i + '">' + gruende[i] + '</option>');
 }
 response.write('</select></p>'
  + '<p><label for="textArea">Text</label> <textarea id="textArea" name="text"></textarea></p>'
  + '<p><input type="submit" name="Eintrag hinzufügen"></p>'
  + '</form>'
  + '</body></html>'
 );
 response.close();
}

function lesen() {
 // liest die Speicherdatei ein
 // Verzeichnis muss aktualisiert werden
 dir.refresh();
 // wenn die Datei angelegt ist ...
 if (dir.length) {
  // ... öffne sie ...
  stream = dir.open(store, opera.io.filemode.READ);
  // ... und lies sie zeilenweise ein (sie besteht nur aus einer Zeile)
  var datei = stream.readLine();
  stream.close();
  return datei;
  // wenn keine Datei existiert, gib den String für ein leeres Array zurück
 } else return('[]');
}

function speichern(e) {
 // schreibt den Inhalt von eintraege in die Speicherdatei
 var request = e.connection.request;
 var response = e.connection.response;
 // liest das Eingabeformular aus
 var grund = request.bodyItems['grund'][0];
 var text = request.bodyItems['text'][0];
 var datum = new Date();
 // ergänze das Array eintraege
 eintraege.push({
  'grund' : grund,
  'text' : text,
  'datum' : Date.parse(datum)
 });
 // öffne die Speicherdatei zum Schreiben
 var stream = dir.open(store, opera.io.filemode.WRITE);
 // konviertiert eintraege mit der JSON-Bibliothek in einen String und schreibt es
 stream.write(JSON.stringify(eintraege));
 stream.close();
 // Weiterleitung zur Listenansicht
 response.setStatusCode(302);
 response.setResponseHeader('Location', webserver.currentServicePath);
 response.close();
}

function datumformat(d) {
 // formatiert das Datum (das als Zahl der Millisekunden gespeichert ist)
 var dat = new Date(d);
 var ds = tage[dat.getDay()] + ', ' + dat.getDate() + '. ' + monate[dat.getMonth()] + ' ' + dat.getFullYear() + ', ' + dat.getHours() + ':';
 var min = dat.getMinutes();
 ds += (min < 10)? '0' : '';
 ds += min;
 return(ds);
}

function zeitformat(z) {
 // formatiert die Anzahl der Millisekunden Zeitdifferenz
 var zeit = Math.round(z/1000);
 var zeitstring = (zeit % 60) + ' s';
 if (zeit < 60) return(zeitstring);
 zeit = Math.floor(zeit/60);
 zeitstring = (zeit % 60) + ' min ' + zeitstring;
 if (zeit < 60) return(zeitstring);
 zeit = Math.floor(zeit/60);
 zeitstring = zeit + ' h ' + zeitstring;
 return(zeitstring);
}