function StateShift()
    -- This function increases the M key state by one and
    -- cycles back to 1 when the last mode is reached.
    -- Adjust the "total_modes" value if your device has 
    -- more than three M keys.
    total_modes = 3
    nextstate = GetMKeyState() + 1
    if (nextstate > total_modes) then
        nextstate = 1
    end
    SetMKeyState(nextstate)
end

function OnEvent(event, arg)
    -- Set the "g_key" value to the number of the G key which
    -- should be used to shift the mode. Default is G23.
    g_key = 23
    if (event == "G_PRESSED" and arg == g_key) then
        return StateShift()
    end
end