class SessionsController < ApplicationController
  def create
   authenticate_with_open_id(
    params[:openid_url],
    :required => [:nickname, :email],
    :optional => [:dob, :gender, :fullname]
   ) do |result, identity_url, registration|
    if result.successful?
     if User.find_or_create_by_identity_url(identity_url)
      render :text => "Angemeldet (#{registration['email']})."
     else
      render :text => 'Nicht angemeldet'
     end
    else
     render :text => result.message
    end
   end
  end
end
