<?php

/*

     mirror my friends timeline + DMs

     search with:

     # grep -i -w -R --include="*.txt" XXX <dir>

     Copyright (c) 2009 Juergen Schmidt  ju@heisec.de

*/


require "tw-pass.php";

$debug=1;	// give some debug output
$all=0;		// process all available statuses
$DM=1;		// process DMs

if ($uname=="XXXX") 
 die("Please enter username and password in tw-pass.php\n");


if (($argc>0) && ($argv[1]=="-a")) {
   if ($debug) print "Getting it all.\n";
   $all=1;
}

$dir	 = getcwd();
$tdir    = $dir . "/$uname";
$tdirDM  = $tdir . "/DM";
$tdirDMS = $tdir . "/DM-Sent";

chkdir($tdir); chkdir($tdirDM); chkdir($tdirDMS);

// get friends feed
if  (! chdir($tdir)) die("chdir: $tdir\n");
getxml("status",'https://twitter.com/statuses/friends_timeline.xml');


if ($DM == 0) exit(0);

print "checking DMs now\n";

// DMs Inbox
if  (! chdir("$tdirDM")) die("chdir: $tdirDM\n");
getxml("direct_message",'https://twitter.com/direct_messages.xml');

// DMs sent
if (! chdir("$tdirDMS")) die("chdir: $tdirDMS\n");
getxml("direct_message",'https://twitter.com/direct_messages/sent.xml');



// clean exit
exit(0);



//-----------------------------------------------------

function getxml($element, $xurl) {

 global $debug, $all;
 $page=0; $found=0;

 while (($found == 0) || ($all == 1)) {
  $page++;
  $buffer = getfeed($xurl, "page=$page");
  if (empty($buffer)) {
    if ($debug) print "Hit the wall\n";
    break;
  }

  // split in single status updates
  if (! $xml =  new SimpleXMLElement($buffer) ) {
      if ($debug) print "$buffer\n";
  }
  
  $s_array = $xml->xpath($element);

  if (empty($s_array[0])) {
    if ($debug) print "Got empty $element array\n";
    break;
  }
  
  foreach ($s_array as $stat){

    $id = $stat->id;
    $name = $stat->user->name;
    $text = html_entity_decode($stat->text,$quote_style=ENT_COMPAT, "UTF-8");
    $date = $stat->created_at;

    $fxml = $id . ".xml";
    if (file_exists($fxml)) {
      // if ($debug) print ("Already saved $id\n");
      $found=1;
      continue;
    } 

    if ($debug) print "\nID: $id $name $text\n";

    if (! $fid = fopen($fxml, 'w')) die("can't open $fxml\n");
    fputs ($fid, $stat->asXML());
    fclose ($fid);

    if (! $fid = fopen($id.".txt", 'w')) die("can't open $id.txt\n");
    fputs ($fid, "$name: $text # $date $id" );
    fclose ($fid);

  }
 } 
}



function getfeed($ffeed, $options) {

  global $debug, $uname, $pwd;

  $ffeed = $ffeed . "?count=200";
  if (! empty($options)) $ffeed = $ffeed . "&$options";

  if ($debug) print "getting: $ffeed\n";

  $curl_handle = curl_init();
  curl_setopt($curl_handle,CURLOPT_USERPWD,"$uname:$pwd");
  curl_setopt($curl_handle,CURLOPT_URL,"$ffeed");
  curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
  curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
  $buffer = curl_exec($curl_handle);
  $httpcode = curl_getinfo($curl_handle,CURLINFO_HTTP_CODE); 
  curl_close($curl_handle);

  if (empty($buffer) || ($httpcode != 200)) {
     if ($debug) print "$buffer\n";
     die("Twitter returned error $httpcode on\n $ffeed\n");
  }
  return $buffer;
}





function chkdir($cdir) {

 global $debug;

 if ( !is_dir($cdir) ) {
  if ($debug) print "creating $cdir\n";
  if ( !mkdir($cdir, 0755, true) ) 
    die("error creating directory $cdir\n");
 }
} 

?>


