% Beispielcode für den Artikel 
% "Funktionsprinzip. Nebenläufige und verteilte Programme mit Erlang"
% aus c't 2009, Heft 19
% von Christoph Dornheim

-module(list_server).
-compile(export_all).

start(Node,Name) ->
  spawn(Node, 
        fun() -> global:register_name(Name,self()),
                 loop([])
      	end).

loop(L) ->
  receive
    stop          -> server_stopped;
    {update,Cmds} -> loop(update_cmds(L,Cmds));
    {get,Pid,Id}  -> Pid ! {reply,L,Id},
                     loop(L)
  end.

stop(Name) -> 
  global:whereis_name(Name) ! stop.

update(Name,Cmds) ->
  global:whereis_name(Name) ! {update,Cmds}.

get(Name) ->
  Pid=global:whereis_name(Name),
  Id=erlang:monitor(process,Pid),
  Pid ! {get,self(),Id},
  Reply=
    receive
      {reply,L,Id}                 -> L;
      {'DOWN',Id,process,Pid,Info} -> {error,Info}
    end,
  erlang:demonitor(Id,[flush]),
  Reply.

remove([],_)    -> [];
remove([X|R],X) -> R;
remove([Y|R],X) -> [Y|remove(R,X)].

update_cmd(L,{Cmd,X}) ->
  case Cmd of
    add    -> [X|L];
    delete -> remove(L,X)
  end.

foldl(Acc,[],_)      -> Acc;
foldl(Acc,[X|R],Fun) -> foldl(Fun(Acc,X),R,Fun).

update_cmds(L,Cmds) ->
  Fun = fun(AccL,Cmd) -> 
          update_cmd(AccL,Cmd)
        end,
  case catch(foldl(L,Cmds,Fun)) of
    {'EXIT',_Error} -> L;
    NewL    	    -> NewL
  end.

